---
generated_at: 2026-01-22 19:40:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：6-アクセス拒否

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠あり、優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/resources/jenkins/model/Jenkins/accessDenied.jelly`
- E-02: `core/src/main/java/hudson/security/ACL.java`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 権限不足時に表示される | E-01, E-03 | ○ |
| C-02 | 403 Forbiddenに相当する | E-03 (備考欄) | ○ |
| C-03 | タイトルは"Access Denied" | E-01 (32行目) | ○ |
| C-04 | 例外メッセージを表示 | E-01 (34行目) | ○ |
| C-05 | st:outでエスケープ表示 | E-01 (34行目) | ○ |
| C-06 | サイドパネルは非表示 | E-01 (28行目コメント, 30行目) | ○ |
| C-07 | ヘッダータイトルは"Jenkins Login" | E-01 (29行目) | ○ |
| C-08 | l:layoutでレイアウト | E-01 (27行目) | ○ |
| C-09 | 関連機能は認可(29)、権限管理(31) | E-04 | ○ |
| C-10 | 認証フローからの遷移 | E-05 | ○ |
| C-11 | p.errorクラスでエラー表示 | E-01 (34行目) | ○ |
| C-12 | h1タグでタイトル表示 | E-01 (32行目) | ○ |
| C-13 | l:side-panelは空で定義 | E-01 (30行目) | ○ |
| C-14 | l:main-panelにコンテンツ | E-01 (31行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - シンプルなエラー画面で、全ての表示要素がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] サイドパネルが正しく非表示になることを確認
- [ ] 例外メッセージが適切にエスケープされることを確認
- [ ] HTTPステータス403が返されることを確認
