---
generated_at: 2026-01-22 11:15:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：60-スクリプトコンソール

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  1. 特になし - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/resources/jenkins/model/Jenkins/_script.jelly` (33行)
- E-02: `core/src/main/resources/lib/hudson/scriptConsole.jelly` (81行)
- E-03: `core/src/main/java/hudson/util/RemotingDiagnostics.java` (247行)
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` (60行目)
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (60行目関連)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | t:scriptConsoleタグを使用 | E-01 (30-32行目) | ○ |
| C-02 | サンプルスクリプトが表示される | E-01 (31行目 `println(Jenkins.instance.pluginManager.plugins)`) | ○ |
| C-03 | permission="${app.ADMINISTER}"で権限設定 | E-02 (39行目) | ○ |
| C-04 | it.channelでチャネル状態確認 | E-02 (49行目 `<j:when test="${it.channel != null}">`) | ○ |
| C-05 | フォームのaction="script" | E-02 (59行目) | ○ |
| C-06 | textareaのname="script" | E-02 (60行目) | ○ |
| C-07 | f:submitでRunボタン | E-02 (62行目 `value="${%Run}"`) | ○ |
| C-08 | CodeMirror Groovyモード使用 | E-02 (65行目 `org.kohsuke.stapler.codemirror.mode.groovy.groovy`) | ○ |
| C-09 | 結果表示時にResultヘッダー | E-02 (68-69行目 `<j:if test="${output!=null}">`) | ○ |
| C-10 | l:copyButtonでコピー機能 | E-02 (70行目) | ○ |
| C-11 | オフライン時にimpossibleOfflineメッセージ | E-02 (76行目 `${%impossibleOffline}`) | ○ |
| C-12 | executeGroovy()でスクリプト実行 | E-03 (121-128行目) | ○ |
| C-13 | ScriptListener.fireScriptExecution()で監査 | E-03 (124行目) | ○ |
| C-14 | ScriptListener.fireScriptOutput()で出力監査 | E-03 (126行目) | ○ |
| C-15 | channel.call(new Script(script))で実行 | E-03 (125行目) | ○ |
| C-16 | CompilerConfigurationでインポート設定 | E-03 (148-153行目) | ○ |
| C-17 | GroovyShellでスクリプト評価 | E-03 (154行目 `new GroovyShell(cl, new Binding(), cc)`) | ○ |
| C-18 | out変数にPrintWriter設定 | E-03 (158行目 `shell.setVariable("out", pw)`) | ○ |
| C-19 | 戻り値は"Result: "プレフィックス付き | E-03 (161-162行目) | ○ |
| C-20 | 関連機能はGroovyコンソール(44)とJenkins本体(1) | E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし - すべての主要な処理について根拠が確認できた

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に根拠あり
- 0: 低リスク - 権限チェックが最高レベル（ADMINISTER）で適切
- 0: 低リスク - 監査ログ機能が実装されている

## 6) レビュアーチェックリスト（最小）
- [ ] executeGroovy()の処理フローが正確か確認
- [ ] 監査ログの記録内容を確認
- [ ] リモートノードでのスクリプト実行の挙動を確認
- [ ] セキュリティ上の注意点を追加する必要があるか検討
