---
generated_at: 2026-01-22 19:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：61-メモリ使用状況

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **URLパス**：実際のJenkins環境での検証推奨
  2. **権限要件**：SYSTEM_READ/MANAGEの両方が必要かどうか確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/hudson/diagnosis/MemoryUsageMonitor.java`
- E-02: `core/src/main/resources/hudson/diagnosis/MemoryUsageMonitor/index.jelly`
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | JVMのメモリ使用状況をグラフ表示する | E-01 行96-99, E-02 行64 | ○ |
| C-02 | ヒープ領域と非ヒープ領域を監視 | E-01 行102-108 | ○ |
| C-03 | 10秒間隔でデータ収集 | E-01 行112-114 `TimeUnit.SECONDS.toMillis(10)` | ○ |
| C-04 | typeパラメータでsec10/min/hourを指定可能 | E-02 行34-62 | ○ |
| C-05 | デフォルトのtypeはmin | E-02 行34 `?: 'min'` | ○ |
| C-06 | グラフサイズは500x300ピクセル | E-02 行64 `width=500&height=300` | ○ |
| C-07 | 使用量は赤色(RED)で表示 | E-01 行62 `ColorPalette.RED` | ○ |
| C-08 | 最大量は青色(BLUE)で表示 | E-01 行66 `ColorPalette.BLUE` | ○ |
| C-09 | SYSTEM_READ/MANAGE権限が必要 | E-01 行97 `checkAnyPermission` | ○ |
| C-10 | KB単位でデータ保存 | E-01 行86-87 `used /= 1024; max /= 1024;` | ○ |
| C-11 | GC後のメモリ使用量を取得 | E-01 行79 `getCollectionUsage()` | ○ |
| C-12 | @Extensionアノテーションで自動登録 | E-01 行50 `@Extension @Symbol("memoryUsage")` | ○ |
| C-13 | PeriodicWorkを継承 | E-01 行51 `extends PeriodicWork` | ○ |
| C-14 | 関連機能は管理モニター | E-03 行134 | ○ |
| C-15 | MultiStageTimeSeriesでデータ管理 | E-01 行62, 66 | ○ |
| C-16 | ManagementFactoryからMXBean取得 | E-01 行106 | ○ |
| C-17 | TrendChartを生成して返却 | E-01 行98 | ○ |
| C-18 | URLパスは/manage/systemInfo/memoryUsage | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- URLパスの正確な形式についてはコード上から明確な根拠が見つからず
  - 候補：Staplerのルーティング定義 / web.xml / 実際の動作確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コードベースから直接確認できる主張が大半
- 1: 中リスク - URLパス形式は実環境での確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] URLパスが実際のJenkins環境で正しくアクセスできるか確認
- [ ] グラフ表示が正常に動作するか確認
- [ ] 権限チェックが適切に機能するか確認
