---
generated_at: 2026-01-22 19:32:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：62-ディスク使用状況

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **HudsonHomeDiskUsageChecker**：実際のチェックロジック確認推奨
  2. **disabledの永続化先**：ファイルパスの正確性要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/hudson/diagnosis/HudsonHomeDiskUsageMonitor.java`
- E-02: `core/src/main/resources/hudson/diagnosis/HudsonHomeDiskUsageMonitor/index.jelly`
- E-03: `core/src/main/resources/hudson/diagnosis/HudsonHomeDiskUsageMonitor/index.properties`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | JENKINS_HOMEディスク容量不足時に警告表示 | E-01 行50 `activated`, E-03 行23 | ○ |
| C-02 | AdministrativeMonitorを継承 | E-01 行46 `extends AdministrativeMonitor` | ○ |
| C-03 | モニターIDは "hudsonHomeIsFull" | E-01 行53 `super("hudsonHomeIsFull")` | ○ |
| C-04 | @Extension @Symbol("diskUsageCheck") | E-01 行45 | ○ |
| C-05 | doAct()でno パラメータ判定 | E-01 行69-77 | ○ |
| C-06 | disable(true)で警告を無効化 | E-01 行72 | ○ |
| C-07 | /manage へリダイレクト | E-01 行73 `redirectViaContextPath("/manage")` | ○ |
| C-08 | getSolutions()でSolution一覧取得 | E-01 行79-81 | ○ |
| C-09 | Solutionは拡張ポイント | E-01 行111 `implements ExtensionPoint` | ○ |
| C-10 | app.rootDir でJENKINS_HOMEパス表示 | E-02 行35 | ○ |
| C-11 | 解決策1: パーティションクリーンアップ | E-03 行28 `solution.1` | ○ |
| C-12 | 解決策2: JENKINS_HOMEの移行 | E-03 行29-31 `solution.2` | ○ |
| C-13 | message.jelly でSolution表示 | E-02 行49 `st:include page="message.jelly"` | ○ |
| C-14 | 警告アイコン icon-warning表示 | E-02 行30 `class="icon-warning icon-xlg"` | ○ |
| C-15 | HudsonHomeDiskUsageCheckerがactivatedを更新 | E-01 行48-50 コメントとフィールド | ○ |
| C-16 | 無効化設定の永続化先 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 無効化設定の正確な永続化先（config.xmlの具体的な構造）
  - 候補：AdministrativeMonitor.disableの実装 / Jenkins config.xml

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コードベースから直接確認できる主張が大半
- 1: 中リスク - HudsonHomeDiskUsageCheckerの詳細ロジックは別ファイルで要確認

## 6) レビュアーチェックリスト（最小）
- [ ] HudsonHomeDiskUsageCheckerの閾値設定を確認
- [ ] Solution拡張ポイントの利用例を確認
- [ ] disable(true)後の永続化処理を確認
