---
generated_at: 2026-01-22 19:34:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：63-ヒープダンプ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **アクセスパス**：実際のJenkins環境でURLパスを確認推奨
  2. **エージェントノード対応**：リモートノードでの動作確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/hudson/util/RemotingDiagnostics.java`
- E-02: `core/src/main/resources/hudson/util/RemotingDiagnostics/HeapDump/index.jelly`
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | HPROF形式でヒープダンプ取得 | E-01 行187 `".hprof"` | ○ |
| C-02 | ADMINISTER権限が必要 | E-02 行3 `permission="${app.ADMINISTER}"`, E-01 行219 | ○ |
| C-03 | @WebMethodでheapdump.hprofにマッピング | E-01 行216 | ○ |
| C-04 | @RequirePOSTでPOSTリクエストのみ許可 | E-01 行217 | ○ |
| C-05 | Content-Typeはapplication/octet-stream | E-01 行220 | ○ |
| C-06 | 一時ファイルパターンはhudson-heapdump*.hprof | E-01 行187 | ○ |
| C-07 | MBeanServerでdumpHeapを呼び出し | E-01 行191-192 | ○ |
| C-08 | HotSpotDiagnostic MBeanを使用 | E-01 行191 `"com.sun.management:type=HotSpotDiagnostic"` | ○ |
| C-09 | ダウンロード後にファイル削除 | E-01 行226 `dump.delete()` | ○ |
| C-10 | FilePathでファイルパスを返却 | E-01 行194 | ○ |
| C-11 | VirtualChannelでリモート実行可能 | E-01 行209, 181 | ○ |
| C-12 | ModelObjectインターフェースを実装 | E-01 行207 `implements ModelObject` | ○ |
| C-13 | getDisplayName()でHeap Dumpを返す | E-01 行243-245 | ○ |
| C-14 | MasterToSlaveCallableを継承 | E-01 行184 | ○ |
| C-15 | アクセスURLパス形式 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- アクセスURLパスの正確な形式はコードからは推測
  - 候補：Computer.javaのgetHeapDump() / Jenkins.javaのheapDump属性

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コードベースから直接確認できる主張が大半
- 1: 中リスク - HotSpot以外のJVMでの動作は未検証

## 6) レビュアーチェックリスト（最小）
- [ ] 実際のJenkins環境でヒープダンプが取得できるか確認
- [ ] エージェントノードからもヒープダンプが取得できるか確認
- [ ] 大きなヒープサイズでのダウンロード動作を確認
