---
generated_at: 2026-01-22 19:36:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：64-JVMクラッシュログ一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. すべての主張に根拠あり - 機能確認テストを推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/jenkins/diagnosis/HsErrPidList.java`
- E-02: `core/src/main/java/jenkins/diagnosis/HsErrPidFile.java`
- E-03: `core/src/main/resources/jenkins/diagnosis/HsErrPidList/index.jelly`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AdministrativeMonitorを継承 | E-01 行38 `extends AdministrativeMonitor` | ○ |
| C-02 | @Extension @Symbol("hsErrPid") | E-01 行37 | ○ |
| C-03 | filesリストでHsErrPidFileを管理 | E-01 行42 | ○ |
| C-04 | カレントディレクトリをスキャン | E-01 行60 `"./hs_err_pid%p.log"` | ○ |
| C-05 | /tmpディレクトリをスキャン | E-01 行67 `"/tmp/hs_err_pid%p.log"` | ○ |
| C-06 | -XX:ErrorFileオプションを解析 | E-01 行74-76, 170 `ERROR_FILE_OPTION` | ○ |
| C-07 | secret.keyでファイル所有者を判定 | E-01 行133-143, 150-152 | ○ |
| C-08 | isActivated()はfilesが空でないとき | E-01 行166-168 | ○ |
| C-09 | getFiles()で@StaplerDispatchable | E-01 行93-96 | ○ |
| C-10 | doDownload()でファイルダウンロード | E-02 行47-49 | ○ |
| C-11 | doDelete()でファイル削除 | E-02 行52-58 | ○ |
| C-12 | Files.deleteIfExists()を使用 | E-02 行55 | ○ |
| C-13 | 削除後にfiles.remove(this) | E-02 行56 | ○ |
| C-14 | 削除後に../..へリダイレクト | E-02 行57 | ○ |
| C-15 | ADMINISTER権限チェック | E-02 行48, 54 | ○ |
| C-16 | テーブルはソート可能(sortable) | E-03 行34 `class="jenkins-table sortable"` | ○ |
| C-17 | 経過時間を{0} agoで表示 | E-03 行54 `${%ago(f.timeSpanString)}` | ○ |
| C-18 | フォームでPOST削除 | E-03 行57 `method="post"` | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべての主張に根拠が確認できました

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべてのClaimがコードベースから確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 実際のhs_err_pidファイルが正しく検出されるか確認
- [ ] ダウンロード機能が正常に動作するか確認
- [ ] 削除後にファイルが正しく消去されるか確認
