---
generated_at: 2026-01-22 19:38:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：65-API情報

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **SecureRequester**：JSONP許可の実装詳細を確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/hudson/model/Api.java`
- E-02: `core/src/main/resources/hudson/model/Api/index.jelly`
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | beanフィールドに対象オブジェクトを保持 | E-01 行85 `public final Object bean` | ○ |
| C-02 | getDisplayName()でAPIを返す | E-01 行92-94 | ○ |
| C-03 | getSearchUrl()でapiを返す | E-01 行97-99 | ○ |
| C-04 | doXml()でXMLシリアライズ | E-01 行104-211 | ○ |
| C-05 | xpath, wrapper, tree, depthパラメータ対応 | E-01 行105-108 | ○ |
| C-06 | setHeaders()でセキュリティヘッダー設定 | E-01 行307-315 | ○ |
| C-07 | X-Jenkinsヘッダーにバージョン設定 | E-01 行309 | ○ |
| C-08 | X-Content-Type-Options: nosniff | E-01 行312 | ○ |
| C-09 | X-Frame-Options: deny | E-01 行314 | ○ |
| C-10 | doJson()でJSONシリアライズ | E-01 行231-263 | ○ |
| C-11 | doPython()でPythonシリアライズ | E-01 行268-296 | ○ |
| C-12 | doSchema()でXMLスキーマ生成 | E-01 行220-226 | ○ |
| C-13 | wrapperパラメータの検証 | E-01 行156-162 | ○ |
| C-14 | Api_NoXPathMatchエラー | E-01 行175 | ○ |
| C-15 | Api_MultipleMatchエラー | E-01 行179 | ○ |
| C-16 | Api_WrapperParamInvalidエラー | E-01 行160 | ○ |
| C-17 | JSONP禁止時403エラー | E-01 行261 | ○ |
| C-18 | one-columnレイアウト | E-02 行27 `type="one-column"` | ○ |
| C-19 | tree説明にサンプルリンク | E-02 行94 | ○ |
| C-20 | SecureRequesterの役割 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- SecureRequesterインターフェースの詳細実装（別ファイル）
  - 候補：jenkins/security/SecureRequester.java

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - APIの主要機能はコードから確認済み
- 1: 中リスク - JSONP許可のセキュリティ設定は要確認

## 6) レビュアーチェックリスト（最小）
- [ ] treeパラメータによるフィルタリングが正常に動作するか確認
- [ ] XPath処理のセキュリティ（FilteredFunctionContext）を確認
- [ ] JSONPアクセスのセキュリティ設定を確認
