---
generated_at: 2026-01-22 19:42:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：67-フィンガープリント詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. すべての主張に根拠あり - 機能確認テストを推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/resources/hudson/model/Fingerprint/index.jelly`
- E-02: `core/src/main/java/hudson/model/Fingerprint.java`
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | one-columnレイアウト | E-01 行27 `type="one-column"` | ○ |
| C-02 | タイトルはファイル名 | E-01 行27 `title="${it.fileName}"` | ○ |
| C-03 | MD5ハッシュ表示 | E-01 行33 `${it.hashString}` | ○ |
| C-04 | timestampString表示 | E-01 行36 `${%introduced(it.timestampString)}` | ○ |
| C-05 | originalがnullの場合"outside Jenkins" | E-01 行38-39 `j:when test="${it.original==null}"` | ○ |
| C-06 | t:buildLinkでビルドリンク生成 | E-01 行42 | ○ |
| C-07 | Usageセクション表示 | E-01 行46 `${%Usage}` | ○ |
| C-08 | jobsが空の場合のメッセージ | E-01 行49-52 | ○ |
| C-09 | usagesをiterate | E-01 行59-62 `${usages[j]}` | ○ |
| C-10 | 権限チェック(job!=null) | E-01 行63 `j:if test="${job!=null}"` | ○ |
| C-11 | t:buildRangeLinkでビルド範囲リンク | E-01 行68 | ○ |
| C-12 | sortedFacetsで拡張表示 | E-01 行77-79 | ○ |
| C-13 | BuildPtrでビルド参照 | E-02 行89-219 | ○ |
| C-14 | RangeSetで範囲管理 | E-02 行342-400 | ○ |
| C-15 | hasPermissionToDiscoverBuild()で権限チェック | E-02 行124-133 | ○ |
| C-16 | ADMINISTERで削除ジョブも表示可 | E-02 行128-129 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべての主張に根拠が確認できました

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべてのClaimがコードベースから確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] フィンガープリント詳細画面が正常に表示されるか確認
- [ ] ビルドリンクが正しく動作するか確認
- [ ] 権限チェックが適切に機能するか確認
