---
generated_at: 2026-01-22 19:44:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：68-プロジェクト関係図

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **Job.getRelationship()**：実装詳細の確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/resources/jenkins/model/Jenkins/projectRelationship.jelly`
- E-02: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | タイトルは"Project Relationship" | E-01 行31, 36 | ○ |
| C-02 | サイドパネル表示 | E-01 行32 | ○ |
| C-03 | パンくずリスト表示 | E-01 行33 | ○ |
| C-04 | ヘルプリンク | E-01 行37 `t:help href="projectRelationship-help"` | ○ |
| C-05 | GETメソッドのフォーム | E-01 行44 `method="get"` | ○ |
| C-06 | lhsコンボボックス | E-01 行47 `id="lhs"` | ○ |
| C-07 | rhsコンボボックス | E-01 行52 `id="rhs"` | ○ |
| C-08 | fillJobNameItemsでオートコンプリート | E-01 行47, 52 `fillUrl="fillJobNameItems"` | ○ |
| C-09 | app.getItemByFullNameでジョブ取得 | E-01 行57-58 | ○ |
| C-10 | ジョブnullチェック | E-01 行61, 64 | ○ |
| C-11 | エラー"No such project" | E-01 行62, 65 | ○ |
| C-12 | jl.getRelationship(jr)で関係取得 | E-01 行69 | ○ |
| C-13 | 関係が空の場合のエラー | E-01 行71 `empty(relation)` | ○ |
| C-14 | t:buildLinkでビルドリンク | E-01 行76 | ○ |
| C-15 | t:buildRangeLinkでビルド範囲 | E-01 行82 | ○ |
| C-16 | Job.getRelationship()の詳細実装 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Job.getRelationship()メソッドの詳細実装
  - 候補：hudson/model/Job.java / AbstractProject.java

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 画面表示部分はJellyから確認済み
- 1: 中リスク - 関係算出ロジックは要確認

## 6) レビュアーチェックリスト（最小）
- [ ] Job.getRelationship()の実装を確認
- [ ] フィンガープリントに基づく関係算出が正しく動作するか確認
- [ ] コンボボックスのオートコンプリートが正常に動作するか確認
