---
generated_at: 2026-01-22 19:46:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：69-404エラー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **web.xml設定**：エラーページ設定の確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/resources/jenkins/model/Jenkins/_404.jelly`
- E-02: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | st:statusCodeでステータス設定 | E-01 行31 | ○ |
| C-02 | セッションにfrom属性保存 | E-01 行32 | ○ |
| C-03 | one-columnレイアウト | E-01 行33 `type="one-column"` | ○ |
| C-04 | タイトルはエラーメッセージ | E-01 行33 `title="${%title(...)}` | ○ |
| C-05 | rage.svgアイコン表示 | E-01 行37 | ○ |
| C-06 | Oops!見出し | E-01 行38 `${%Oops!}` | ○ |
| C-07 | ResourceDomainRootAction.error確認 | E-01 行42 | ○ |
| C-08 | app.useSecurityで分岐 | E-01 行45 | ○ |
| C-09 | noAccessメッセージ | E-01 行46 | ○ |
| C-10 | h.isAnonymous()で匿名判定 | E-01 行47 | ○ |
| C-11 | tryLoggingInメッセージ | E-01 行48 | ○ |
| C-12 | notFoundメッセージ | E-01 行52 | ○ |
| C-13 | oops.jellyと類似構成 | E-01 コメント行29 | ○ |
| C-14 | web.xmlのerror-page設定 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- web.xmlのerror-page設定の詳細
  - 候補：WEB-INF/web.xml

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 画面表示ロジックはJellyから確認済み
- 1: 中リスク - web.xml設定は要確認

## 6) レビュアーチェックリスト（最小）
- [ ] web.xmlのerror-page設定を確認
- [ ] セキュリティ有効/無効時のメッセージ表示を確認
- [ ] 匿名ユーザー時のログイン促進が正しく表示されるか確認
