---
generated_at: 2026-01-22 19:42:00
metrics:
  claims_total: 24
  claims_with_evidence: 23
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：7-ユーザー登録（サインアップ）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：23 / 24、根拠なし：1
- 優先レビュー（高）
  1. **パスワード強度計算ロジック**：register.jsの詳細確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/resources/hudson/security/HudsonPrivateSecurityRealm/signup.jelly`
- E-02: `core/src/main/java/hudson/security/HudsonPrivateSecurityRealm.java`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | セルフサインアップ画面である | E-01, E-03 | ○ |
| C-02 | URLは/securityRealm/signup | E-01 | ○ |
| C-03 | セルフサインアップ有効時のみアクセス可能 | E-02 (159-161行目) | ○ |
| C-04 | username入力フィールドがある | E-01 (68-81行目) | ○ |
| C-05 | fullname入力フィールドがある | E-01 (82-96行目) | ○ |
| C-06 | email入力はMailerプラグイン時のみ | E-01 (97行目) | ○ |
| C-07 | password1フィールドがある | E-01 (128-150行目) | ○ |
| C-08 | password2はhiddenフィールド | E-01 (154-159行目) | ○ |
| C-09 | CAPTCHA入力はCAPTCHA有効時のみ | E-01 (114行目) | ○ |
| C-10 | パスワード強度表示がある | E-01 (147-149行目) | ○ |
| C-11 | 強度は4段階（Strong/Moderate/Weak/Poor） | E-01 (62-65行目) | ○ |
| C-12 | /securityRealm/createAccountにPOST | E-01 (67行目) | ○ |
| C-13 | or sign inリンクがある | E-01 (165-167行目) | ○ |
| C-14 | キャッシュ制御ヘッダーが設定される | E-01 (31-32行目) | ○ |
| C-15 | NOFOLLOWメタタグがある | E-01 (47行目) | ○ |
| C-16 | register.jsが読み込まれる | E-01 (52行目) | ○ |
| C-17 | CSRF対策のCrumbトークンが含まれる | E-01 (168行目) | ○ |
| C-18 | エラー時にフィールドがエラー状態になる | E-01 (40行目) | ○ |
| C-19 | 関連機能はユーザー管理(30)、認証(28) | E-04 | ○ |
| C-20 | ログイン画面から遷移 | E-05 | ○ |
| C-21 | パスワード表示チェックボックスがある | E-01 (133-136行目) | ○ |
| C-22 | セルフサインアップ無効時は401 | E-02 (272行目) | ○ |
| C-23 | 登録後は自動ログイン | E-02 (279行目) | ○ |
| C-24 | パスワード強度計算の具体的ロジック | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- パスワード強度計算の詳細ロジック
  - 候補：`war/src/main/js/pages/register.js`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 画面構成は明確にソースコードで確認可能
- 1: 中リスク - パスワード強度の具体的な計算基準の詳細確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] セルフサインアップ機能の有効/無効判定が正しいか
- [ ] CAPTCHA機能の条件付き表示が正しいか
- [ ] メールアドレスフィールドの条件付き表示が正しいか
- [ ] パスワード強度表示の基準が適切か
