---
generated_at: 2026-01-22 19:48:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：70-500エラー（Oops）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **UncaughtExceptionHandler**：ロギングID生成の詳細確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/resources/jenkins/model/Jenkins/oops.jelly`
- E-02: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | st:statusCodeでステータス設定 | E-01 行30 | ○ |
| C-02 | one-columnレイアウト | E-01 行31 `type="one-column"` | ○ |
| C-03 | rage.svgアイコン表示 | E-01 行35 | ○ |
| C-04 | Oops!見出し | E-01 行35 `${%Oops!}` | ○ |
| C-05 | problemHappenedメッセージ | E-01 行38 | ○ |
| C-06 | ロギングID表示 | E-01 行39 `jenkins.exception.id` | ○ |
| C-07 | app.shouldShowStackTrace()で表示制御 | E-01 行41 | ○ |
| C-08 | checkJIRAメッセージ | E-01 行42 | ○ |
| C-09 | voteメッセージ | E-01 行42 | ○ |
| C-10 | pleaseReportメッセージ | E-01 行42 | ○ |
| C-11 | stackTracePleaseメッセージ | E-01 行42 | ○ |
| C-12 | checkMLメッセージ | E-01 行42 | ○ |
| C-13 | h.printThrowable()でスタックトレース取得 | E-01 行43 | ○ |
| C-14 | l:copyButtonでコピー機能 | E-01 行46 | ○ |
| C-15 | preタグでスタックトレース表示 | E-01 行48 | ○ |
| C-16 | UncaughtExceptionHandlerの詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- UncaughtExceptionHandlerの実装詳細
  - 候補：hudson/util/UncaughtExceptionHandler.java

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 画面表示ロジックはJellyから確認済み
- 1: 中リスク - ロギングID生成処理は要確認

## 6) レビュアーチェックリスト（最小）
- [ ] UncaughtExceptionHandlerの実装を確認
- [ ] スタックトレースの表示/非表示設定を確認
- [ ] コピーボタンが正常に動作するか確認
