---
generated_at: 2026-01-22 19:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：71-ローディング中

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **loading.jsの詳細動作**：スクリプトファイル内容未確認
  2. **simple-page.cssの存在確認**：SCSSファイルのパス未確認
  3. **モバイルレスポンシブ対応の詳細**：メタタグ以外の実装未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/hudson/util/HudsonIsLoading.java`
- E-02: `core/src/main/resources/hudson/util/HudsonIsLoading/index.jelly`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | HTTP 503ステータスコードを返却する | E-01 (L45), E-02 (L27) | ○ |
| C-02 | doDynamicメソッドでリクエスト処理を行う | E-01 (L44-46) | ○ |
| C-03 | キャッシュ制御ヘッダーが設定される | E-02 (L28-29) | ○ |
| C-04 | ページタイトルは「Starting Jenkins」 | E-02 (L37) | ○ |
| C-05 | Jenkinsロゴを表示する | E-02 (L48) | ○ |
| C-06 | スピナーアニメーションを表示する | E-02 (L50-51) | ○ |
| C-07 | 自動リロード通知メッセージを表示 | E-02 (L53-55) | ○ |
| C-08 | loading.jsを読み込む | E-02 (L58) | ○ |
| C-09 | ROBOTSメタタグがNOFOLLOWに設定 | E-02 (L39) | ○ |
| C-10 | モバイル対応のviewportメタタグ | E-02 (L41) | ○ |
| C-11 | 関連機能は初期化フレームワーク（70） | E-04 (L147) | ○ |
| C-12 | カテゴリはシステム状態 | E-03 (L72) | ○ |
| C-13 | Jenkins初期化完了後にダッシュボードへ遷移 | E-05 | ○ |
| C-14 | 認証・認可の前に表示される | E-01, E-02 | ○ |
| C-15 | ServletContextにHudsonIsLoadingが設定される | E-01 (Javadoc L36-40) | ○ |
| C-16 | ローカライズ対応（言語タグ設定） | E-02 (L35) | ○ |
| C-17 | loading.jsによる定期ポーリングの詳細動作 | **根拠なし** | △ |
| C-18 | simple-page.cssによるレスポンシブデザイン | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- loading.jsスクリプトの内容・動作詳細
  - 候補：`core/src/main/resources/scripts/loading.js` / `war/src/main/js/`
- simple-page.cssの完全なパスと内容
  - 候補：`war/src/main/scss/simple-page.scss` / `war/src/main/webapp/jsbundles/`

## 5) リスクフラグ（レビュー観点）
- 0: HTTP 503返却とキャッシュ制御（コードで確認済み）
- 0: 表示内容とメッセージ（テンプレートで確認済み）
- 1: JavaScriptによる自動リロード動作（スクリプト未確認）
- 1: CSSスタイルの詳細（SCSSファイル未確認）

## 6) レビュアーチェックリスト（最小）
- [ ] loading.jsファイルの存在と動作を確認
- [ ] simple-page.cssまたはSCSSファイルのパスを確認
- [ ] 自動リロードの実際の動作をブラウザで確認
- [ ] HTTP 503レスポンスが正しく返却されることを確認
