---
generated_at: 2026-01-22 19:32:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：72-再起動中

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **loading.jsの詳細動作**：スクリプトファイル内容未確認
  2. **safe-restartingクラスのCSS詳細**：スタイル定義未確認
  3. **エージェントビルド継続の実装詳細**：実装コード未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/hudson/util/HudsonIsRestarting.java`
- E-02: `core/src/main/resources/hudson/util/HudsonIsRestarting/index.jelly`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | HTTP 503ステータスコードを返却する | E-01 (L59), E-02 (L27) | ○ |
| C-02 | doDynamicメソッドでリクエスト処理を行う | E-01 (L58-61) | ○ |
| C-03 | safeRestartフラグを持つ | E-01 (L44, L49-51) | ○ |
| C-04 | キャッシュ制御ヘッダーが設定される | E-02 (L28-29) | ○ |
| C-05 | ページタイトルは「Restarting Jenkins」 | E-02 (L37) | ○ |
| C-06 | Jenkinsロゴを表示する | E-02 (L47-48) | ○ |
| C-07 | スピナーアニメーションを表示する | E-02 (L50-51) | ○ |
| C-08 | 自動リロード通知メッセージを表示 | E-02 (L53-55) | ○ |
| C-09 | Safe Restart時に追加メッセージを表示 | E-02 (L56-65) | ○ |
| C-10 | isSafeRestart()メソッドでフラグを返却 | E-01 (L66-68) | ○ |
| C-11 | loading.jsを読み込む | E-02 (L68) | ○ |
| C-12 | ROBOTSメタタグがNOFOLLOWに設定 | E-02 (L39) | ○ |
| C-13 | モバイル対応のviewportメタタグ | E-02 (L41) | ○ |
| C-14 | 関連機能は初期化フレームワーク（70） | E-04 (L148) | ○ |
| C-15 | カテゴリはシステム状態 | E-03 (L73) | ○ |
| C-16 | Jenkins再起動完了後にダッシュボードへ遷移 | E-05 | ○ |
| C-17 | ServletContextにHudsonIsRestartingが設定される | E-01 (Javadoc L36-39) | ○ |
| C-18 | ローカライズ対応（言語タグ設定） | E-02 (L35) | ○ |
| C-19 | loading.jsによる定期ポーリングの詳細動作 | **根拠なし** | △ |
| C-20 | エージェント上のビルド継続の実装詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- loading.jsスクリプトの内容・動作詳細
  - 候補：`core/src/main/resources/scripts/loading.js` / `war/src/main/js/`
- エージェントビルド継続の実装コード
  - 候補：`core/src/main/java/jenkins/model/Jenkins.java`のsafeRestart関連メソッド

## 5) リスクフラグ（レビュー観点）
- 0: HTTP 503返却とキャッシュ制御（コードで確認済み）
- 0: safeRestartフラグの管理（コードで確認済み）
- 0: Safe Restart時の追加メッセージ表示（テンプレートで確認済み）
- 1: JavaScriptによる自動リロード動作（スクリプト未確認）
- 1: エージェントビルド継続の実装詳細（コア実装未確認）

## 6) レビュアーチェックリスト（最小）
- [ ] loading.jsファイルの存在と動作を確認
- [ ] Safe Restartモードでの追加メッセージ表示を確認
- [ ] 自動リロードの実際の動作をブラウザで確認
- [ ] HTTP 503レスポンスが正しく返却されることを確認
- [ ] エージェントビルドが実際に継続されることを確認
