---
generated_at: 2026-01-22 19:35:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：73-起動エラー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **WebAppMain.javaでの実際の呼び出し箇所**：呼び出しコード未確認
  2. **ErrorObject基底クラスのstackTraceString実装**：実装詳細未確認
  3. **セキュリティ観点のアクセス制御**：スタックトレース公開のリスク

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/hudson/util/HudsonFailedToLoad.java`
- E-02: `core/src/main/java/hudson/util/BootFailure.java`
- E-03: `core/src/main/resources/hudson/util/HudsonFailedToLoad/index.jelly`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | HTTP 500ステータスコードを返却する | E-03 (L27) | ○ |
| C-02 | HudsonFailedToLoadはBootFailureを継承 | E-01 (L38) | ○ |
| C-03 | exceptionフィールドで例外を保持 | E-01 (L39-40, L42-45) | ○ |
| C-04 | l:layoutで標準レイアウトを使用 | E-03 (L28-35) | ○ |
| C-05 | 「Error」見出しを表示 | E-03 (L32) | ○ |
| C-06 | stackTraceStringでスタックトレースを表示 | E-03 (L33) | ○ |
| C-07 | publish()でServletContextに設定 | E-02 (L42-45) | ○ |
| C-08 | GroovyHookScriptでboot-failureを実行 | E-02 (L49-54) | ○ |
| C-09 | failed-boot-attempts.txtに履歴記録 | E-02 (L94-96) | ○ |
| C-10 | loadAttempts()で起動試行履歴を読み込み | E-02 (L61-85) | ○ |
| C-11 | 関連機能は初期化フレームワーク（70） | E-05 (L149) | ○ |
| C-12 | カテゴリはシステム状態 | E-04 (L74) | ○ |
| C-13 | 致命的エラー時のみ表示 | E-04 (備考) | ○ |
| C-14 | LOGGER.log(Level.SEVERE)でログ出力 | E-02 (L43) | ○ |
| C-15 | getBootFailureFile()でファイルパス取得 | E-02 (L94-96) | ○ |
| C-16 | SimpleDateFormatで日付パース | E-02 (L70) | ○ |
| C-17 | Lifecycleのコールバック呼び出し | E-02 (L55) | ○ |
| C-18 | ErrorObject基底クラスからstackTraceString継承 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- ErrorObject.javaの実装詳細
  - 候補：`core/src/main/java/hudson/util/ErrorObject.java`
- WebAppMain.javaでのHudsonFailedToLoad生成箇所
  - 候補：`core/src/main/java/hudson/WebAppMain.java`

## 5) リスクフラグ（レビュー観点）
- 0: HTTP 500返却（コードで確認済み）
- 0: BootFailure継承とpublish()メソッド（コードで確認済み）
- 0: Groovyフックスクリプト実行（コードで確認済み）
- 0: スタックトレース表示（テンプレートで確認済み）
- 1: ErrorObject基底クラスの実装（未確認）
- 2: スタックトレース公開のセキュリティリスク（要検討）

## 6) レビュアーチェックリスト（最小）
- [ ] ErrorObject.javaのstackTraceStringプロパティ実装を確認
- [ ] WebAppMain.javaでのHudsonFailedToLoad生成箇所を確認
- [ ] boot-failure.groovyフックスクリプトの動作を確認
- [ ] failed-boot-attempts.txtファイルの内容形式を確認
- [ ] 本番環境でのスタックトレース公開に関するセキュリティレビュー
