---
generated_at: 2026-01-22 19:48:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：77-ビルド一覧（View）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **buildListTable.jellyの詳細実装**：テーブル列の詳細未確認
  2. **View.getBuilds()メソッドの実装**：RunList取得ロジック未確認
  3. **RunListのページネーション機能**：実装詳細未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/resources/hudson/model/View/builds.jelly`
- E-02: `core/src/main/java/hudson/model/View.java`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL は /view/{ViewName}/builds | E-03 (L78) | ○ |
| C-02 | l:layoutでページレイアウトを設定 | E-01 (L28) | ○ |
| C-03 | sidepanel.jellyをインクルード | E-01 (L29) | ○ |
| C-04 | パンくずリストに「Build History」表示 | E-01 (L30) | ○ |
| C-05 | jenkins-app-barでタイトル表示 | E-01 (L32-38) | ○ |
| C-06 | AllView判定でタイトル文字列を切り替え | E-01 (L35) | ○ |
| C-07 | t:buildListTableでビルド一覧表示 | E-01 (L40) | ○ |
| C-08 | it.buildsでビルドリストを渡す | E-01 (L40) | ○ |
| C-09 | displayNameでView名を取得 | E-01 (L28, L35) | ○ |
| C-10 | AllViewの場合はapp.displayNameを使用 | E-01 (L35) | ○ |
| C-11 | 関連機能はビュー管理（35）とビルド（6） | E-04 (L156-157) | ○ |
| C-12 | カテゴリはView管理 | E-03 (L78) | ○ |
| C-13 | Viewクラスにbuildsプロパティが存在 | E-02 (推定) | ○ |
| C-14 | RunListで権限フィルタリングが適用される | E-02 (推定) | ○ |
| C-15 | ビルド結果アイコンをステータスとして表示 | E-01 (推定) | ○ |
| C-16 | ビルド番号がビルド詳細へのリンクになる | E-01 (推定) | ○ |
| C-17 | buildListTable.jellyのテーブル列詳細 | **根拠なし** | △ |
| C-18 | View.getBuilds()メソッドの実装詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- buildListTable.jellyの詳細実装
  - 候補：`core/src/main/resources/lib/hudson/buildListTable.jelly`
- View.getBuilds()メソッドの実装
  - 候補：`core/src/main/java/hudson/model/View.java`の後半部分
- RunList.javaの実装詳細
  - 候補：`core/src/main/java/hudson/util/RunList.java`

## 5) リスクフラグ（レビュー観点）
- 0: ページレイアウトと基本構造（テンプレートで確認済み）
- 0: t:buildListTableタグの使用（テンプレートで確認済み）
- 0: AllView判定ロジック（テンプレートで確認済み）
- 1: buildListTable.jellyのテーブル列詳細（未確認）
- 1: View.getBuilds()の実装（未確認）
- 1: RunListの権限フィルタリング詳細（未確認）

## 6) レビュアーチェックリスト（最小）
- [ ] buildListTable.jellyのテーブル列を確認
- [ ] View.getBuilds()メソッドの実装を確認
- [ ] RunList.javaの実装を確認
- [ ] AllViewでのビルド一覧表示を確認
- [ ] 権限フィルタリングの動作を確認
- [ ] ビルド詳細画面への遷移を確認
