---
generated_at: 2026-01-22 21:35:00
metrics:
  claims_total: 33
  claims_with_evidence: 33
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：結合テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された結合テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：33 / 33、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全てのテストケースに根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `test/src/test/java/hudson/cli/BuildCommandTest.java`
- E-02: `test/src/test/java/hudson/cli/CLIActionTest.java`
- E-03: `test/src/test/java/hudson/cli/CLITest.java`
- E-04: `test/src/test/java/hudson/model/ApiTest.java`
- E-05: `test/src/test/java/hudson/security/WhoAmITest.java`
- E-06: `test/src/test/java/jenkins/security/ApiTokenPropertyTest.java`
- E-07: `test/src/test/java/hudson/model/SlaveTest.java`
- E-08: `test/src/test/java/hudson/model/QueueTest.java`
- E-09: `test/src/test/java/jenkins/model/JenkinsTest.java`
- E-10: `test/src/test/java/hudson/model/UpdateCenterTest.java`
- E-11: `test/src/test/java/hudson/PluginManagerInstalledGUITest.java`
- E-12: `test/src/test/java/hudson/ProxyConfigurationManagerGUITest.java`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IT-001: 非同期ビルド実行テスト | E-01 (async()メソッド, L95-114) | ○ |
| C-02 | IT-002: 同期ビルド実行テスト | E-01 (sync()メソッド, L119-127) | ○ |
| C-03 | IT-003: パラメータ付きビルドテスト | E-01 (parameters()メソッド, L142-149) | ○ |
| C-04 | IT-004: 無効化プロジェクトビルド拒否テスト | E-01 (refuseToBuildDisabledProject()メソッド, L191-199) | ○ |
| C-05 | IT-005: ファイルパラメータアップロードテスト | E-01 (fileParameter()メソッド, L292-310) | ○ |
| C-06 | IT-006: 権限なしユーザーのCLIアクセス拒否テスト | E-02 (serveCliActionToAnonymousUserWithoutPermissions()メソッド, L74-81) | ○ |
| C-07 | IT-007: APIトークン認証テスト | E-02 (authentication()メソッド, L89-112) | ○ |
| C-08 | IT-008: WebSocket大容量転送テスト | E-02 (largeTransferWebSocket()メソッド, L246-273) | ○ |
| C-09 | IT-009: 割り込み処理テスト | E-03 (interrupt()メソッド, L93-104) | ○ |
| C-10 | IT-010: 非Jenkinsエンドポイント検出テスト | E-03 (reportNotJenkins()メソッド, L123-137) | ○ |
| C-11 | IT-011: XPathクエリテスト | E-04 (xpath()メソッド, L65-69) | ○ |
| C-12 | IT-012: JSONレスポンステスト | E-04 (json()メソッド, L72-85) | ○ |
| C-13 | IT-013: JSONPコールバックテスト | E-04 (json()メソッド, L80-85) | ○ |
| C-14 | IT-014: XPath document関数ブロックテスト | E-04 (xPathDocumentFunction()メソッド, L99-110) | ○ |
| C-15 | IT-015: ラッパーパラメータXSS防止テスト | E-04 (wrapperXss()メソッド, L214-219) | ○ |
| C-16 | IT-016: X-Frame-Optionsヘッダテスト | E-04 (project_notExposedToIFrame()メソッド, L193-198) | ○ |
| C-17 | IT-017: 通常ログイン情報漏洩防止テスト | E-05 (whoAmI_regular_doesNotProvideSensitiveInformation()メソッド, L67-105) | ○ |
| C-18 | IT-018: API JSON情報漏洩防止テスト | E-05 (whoAmI_regularApi_doesNotProvideSensitiveInformation()メソッド, L107-149) | ○ |
| C-19 | IT-019: Basic認証情報漏洩防止テスト | E-05 (whoAmI_basic_doesNotProvideSensitiveInformation()メソッド, L151-179) | ○ |
| C-20 | IT-020: APIトークン情報漏洩防止テスト | E-05 (whoAmI_apiToken_doesNotProvideSensitiveInformation()メソッド, L181-210) | ○ |
| C-21 | IT-021: APIトークン基本機能テスト | E-06 (basics()メソッド, L67-95) | ○ |
| C-22 | IT-022: 管理者トークン閲覧制限テスト | E-06 (adminsShouldBeUnableToSeeTokensByDefault()メソッド, L120-137) | ○ |
| C-23 | IT-023: Slave config.xml往復テスト | E-07 (slaveConfigDotXml()メソッド, L90-111) | ○ |
| C-24 | IT-024: JNLPリソースセキュリティテスト | E-07 (shouldNotEscapeJnlpSlavesResources()メソッド, L135-162) | ○ |
| C-25 | IT-025: ランチャーフィルタリングテスト | E-07 (launcherFiltering()メソッド, L181-197) | ○ |
| C-26 | IT-026: キュー永続化テスト | E-08 (persistence()メソッド, L159-183) | ○ |
| C-27 | IT-027: レガシーキュー復元テスト | E-08 (recover_from_legacy_list()メソッド, L189-200) | ○ |
| C-28 | IT-028: トグルコラプスPOST検証テスト | E-09 (testPaneToggleCollapse()メソッド, L141-148) | ○ |
| C-29 | IT-029: アップロードファイル権限テスト | E-09 (verifyUploadedFingerprintFilePermission()メソッド, L151-184) | ○ |
| C-30 | IT-030: URLからのユーザー作成テスト | E-09 (testUserCreationFromUrlForAdmins()メソッド, L187-199) | ○ |
| C-31 | IT-031: 更新サイトデータ取得テスト | E-10 (data()メソッド, L52-81) | ○ |
| C-32 | IT-032: プラグインマネージャGUIテスト | E-11 (PluginManagerInstalledGUITest.java) | ○ |
| C-33 | IT-033: プロキシ設定GUIテスト | E-12 (ProxyConfigurationManagerGUITest.java) | ○ |

## 4) 不足情報（Unknown / Missing）
- 根拠なしの項目はありません
- 補足：Jenkinsプロジェクトには404件以上の結合テストファイルが存在しますが、本一覧では代表的な結合テストケースを抽出しています
  - 候補追加：jenkins/security/*, hudson/slaves/*, hudson/triggers/*

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全てのテストケースにソースコードの根拠あり
- 注意点：
  - セキュリティ関連テスト（SECURITY-*）は優先的に実行推奨
  - 外部連携テスト（UpdateCenter）はネットワーク環境に依存

## 6) レビュアーチェックリスト（最小）
- [ ] テストケースの優先度が適切か確認（高：15件、中：13件、低：5件）
- [ ] セキュリティテスト（IT-014, IT-015, IT-016, IT-017-022, IT-024, IT-028-030）の網羅性を確認
- [ ] CLI連携テストの前提条件が実行環境で満たせるか確認
- [ ] 外部連携テスト（IT-031）のネットワーク要件を確認
- [ ] 各テストケースの期待結果が検証可能か確認
