---
generated_at: 2026-01-22 19:17:00
metrics:
  claims_total: 43
  claims_with_evidence: 43
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：通知一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：43 / 43、根拠なし：0
- 優先レビュー（高）
  1. なし（すべての項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/hudson/model/AdministrativeMonitor.java`
- E-02: `core/src/main/java/jenkins/diagnostics/SecurityIsOffMonitor.java`
- E-03: `core/src/main/java/jenkins/diagnostics/RootUrlNotSetMonitor.java`
- E-04: `core/src/main/java/hudson/diagnosis/HudsonHomeDiskUsageMonitor.java`
- E-05: `core/src/main/java/hudson/diagnosis/OldDataMonitor.java`
- E-06: `core/src/main/java/hudson/diagnosis/NullIdDescriptorMonitor.java`
- E-07: `core/src/main/java/hudson/diagnosis/ReverseProxySetupMonitor.java`
- E-08: `core/src/main/java/hudson/model/UpdateCenter.java` (CoreUpdateMonitor)
- E-09: `core/src/main/java/jenkins/security/UpdateSiteWarningsMonitor.java`
- E-10: `core/src/main/java/jenkins/security/csrf/CSRFAdministrativeMonitor.java`
- E-11: `core/src/main/java/jenkins/security/apitoken/LegacyApiTokenAdministrativeMonitor.java`
- E-12: `core/src/main/java/jenkins/security/apitoken/ApiTokenPropertyEnabledNewLegacyAdministrativeMonitor.java`
- E-13: `core/src/main/java/jenkins/security/apitoken/ApiTokenPropertyDisabledDefaultAdministrativeMonitor.java`
- E-14: `core/src/main/java/hudson/PluginManager.java` (PluginCycleDependenciesMonitor)
- E-15: `core/src/main/java/hudson/PluginManager.java` (PluginUpdateMonitor)
- E-16: `core/src/main/java/hudson/PluginManager.java` (PluginDeprecationMonitor)
- E-17: `core/src/main/java/hudson/PluginWrapper.java` (PluginWrapperAdministrativeMonitor)
- E-18: `core/src/main/java/hudson/triggers/SCMTrigger.java` (AdministrativeMonitorImpl)
- E-19: `core/src/main/java/hudson/triggers/SlowTriggerAdminMonitor.java`
- E-20: `core/src/main/java/hudson/node_monitors/MonitorMarkedNodeOffline.java`
- E-21: `core/src/main/java/jenkins/diagnostics/CompletedInitializationMonitor.java`
- E-22: `core/src/main/java/jenkins/diagnostics/URICheckEncodingMonitor.java`
- E-23: `core/src/main/java/jenkins/model/Jenkins.java` (EnforceSlaveAgentPortAdministrativeMonitor)
- E-24: `core/src/main/java/jenkins/monitor/JavaVersionRecommendationAdminMonitor.java`
- E-25: `core/src/main/java/jenkins/monitor/OperatingSystemEndOfLifeAdminMonitor.java`
- E-26: `core/src/main/java/hudson/security/csrf/DefaultCrumbIssuer.java` (ExcludeSessionIdAdministrativeMonitor)
- E-27: `core/src/main/java/hudson/tasks/BuildTrigger.java`
- E-28: `core/src/main/java/jenkins/triggers/ReverseBuildTrigger.java`
- E-29: `core/src/main/java/hudson/triggers/SCMTrigger.java`
- E-30: `core/src/main/java/hudson/triggers/TimerTrigger.java`
- E-31: `core/src/main/java/hudson/model/Cause.java` (UpstreamCause)
- E-32: `core/src/main/java/hudson/model/Cause.java` (UserIdCause)
- E-33: `core/src/main/java/hudson/model/Cause.java` (RemoteCause)
- E-34: `core/src/main/java/hudson/triggers/TimerTrigger.java` (TimerTriggerCause)
- E-35: `core/src/main/java/hudson/triggers/SCMTrigger.java` (SCMTriggerCause)
- E-36: `core/src/main/java/hudson/node_monitors/DiskSpaceMonitor.java`
- E-37: `core/src/main/java/hudson/node_monitors/TemporarySpaceMonitor.java`
- E-38: `core/src/main/java/hudson/node_monitors/SwapSpaceMonitor.java`
- E-39: `core/src/main/java/hudson/node_monitors/ResponseTimeMonitor.java`
- E-40: `core/src/main/java/hudson/node_monitors/ClockMonitor.java`
- E-41: `core/src/main/java/hudson/node_monitors/ArchitectureMonitor.java`
- E-42: `core/src/main/java/hudson/diagnosis/MemoryUsageMonitor.java`
- E-43: `core/src/main/java/jenkins/diagnostics/ControllerExecutorsAgents.java`
- E-44: `core/src/main/java/jenkins/diagnostics/ControllerExecutorsNoAgents.java`
- E-45: `core/src/main/java/hudson/node_monitors/NodeMonitor.java`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | セキュリティ無効警告（SecurityIsOffMonitor）の存在と機能 | E-02 | ○ |
| C-02 | ルートURL未設定警告（RootUrlNotSetMonitor）の存在と機能 | E-03 | ○ |
| C-03 | JENKINS_HOMEディスク使用量警告（HudsonHomeDiskUsageMonitor）の存在と機能 | E-04 | ○ |
| C-04 | 古いデータ警告（OldDataMonitor）の存在と機能 | E-05 | ○ |
| C-05 | NullIdDescriptor警告（NullIdDescriptorMonitor）の存在と機能 | E-06 | ○ |
| C-06 | リバースプロキシ設定警告（ReverseProxySetupMonitor）の存在と機能 | E-07 | ○ |
| C-07 | Jenkinsコア更新通知（CoreUpdateMonitor）の存在と機能 | E-08 | ○ |
| C-08 | 更新サイト警告通知（UpdateSiteWarningsMonitor）の存在と機能 | E-09 | ○ |
| C-09 | CSRF保護警告（CSRFAdministrativeMonitor）の存在と機能 | E-10 | ○ |
| C-10 | レガシーAPIトークン警告（LegacyApiTokenAdministrativeMonitor）の存在と機能 | E-11 | ○ |
| C-11 | APIトークン新規レガシー有効警告の存在と機能 | E-12 | ○ |
| C-12 | APIトークンデフォルト無効警告の存在と機能 | E-13 | ○ |
| C-13 | プラグイン循環依存警告（PluginCycleDependenciesMonitor）の存在と機能 | E-14 | ○ |
| C-14 | プラグイン更新通知（PluginUpdateMonitor）の存在と機能 | E-15 | ○ |
| C-15 | プラグイン非推奨警告（PluginDeprecationMonitor）の存在と機能 | E-16 | ○ |
| C-16 | プラグインラッパー警告（PluginWrapperAdministrativeMonitor）の存在と機能 | E-17 | ○ |
| C-17 | SCMポーリング渋滞警告（AdministrativeMonitorImpl）の存在と機能 | E-18 | ○ |
| C-18 | 遅延トリガー警告（SlowTriggerAdminMonitor）の存在と機能 | E-19 | ○ |
| C-19 | ノードオフライン警告（MonitorMarkedNodeOffline）の存在と機能 | E-20 | ○ |
| C-20 | 初期化完了警告（CompletedInitializationMonitor）の存在と機能 | E-21 | ○ |
| C-21 | URIエンコーディング警告（URICheckEncodingMonitor）の存在と機能 | E-22 | ○ |
| C-22 | エージェントポート強制警告の存在と機能 | E-23 | ○ |
| C-23 | Javaバージョン推奨警告の存在と機能 | E-24 | ○ |
| C-24 | OS終末期警告の存在と機能 | E-25 | ○ |
| C-25 | CrumbセッションID除外警告の存在と機能 | E-26 | ○ |
| C-26 | 下流プロジェクトビルドトリガー（BuildTrigger）の存在と機能 | E-27 | ○ |
| C-27 | 上流プロジェクトビルドトリガー（ReverseBuildTrigger）の存在と機能 | E-28 | ○ |
| C-28 | SCMポーリングトリガー（SCMTrigger）の存在と機能 | E-29 | ○ |
| C-29 | タイマートリガー（TimerTrigger）の存在と機能 | E-30 | ○ |
| C-30 | 上流ビルド原因（UpstreamCause）の存在と機能 | E-31 | ○ |
| C-31 | ユーザー操作原因（UserIdCause）の存在と機能 | E-32 | ○ |
| C-32 | リモート原因（RemoteCause）の存在と機能 | E-33 | ○ |
| C-33 | タイマー原因（TimerTriggerCause）の存在と機能 | E-34 | ○ |
| C-34 | SCM変更原因（SCMTriggerCause）の存在と機能 | E-35 | ○ |
| C-35 | ディスク容量モニター（DiskSpaceMonitor）の存在と機能 | E-36 | ○ |
| C-36 | 一時領域モニター（TemporarySpaceMonitor）の存在と機能 | E-37 | ○ |
| C-37 | スワップ領域モニター（SwapSpaceMonitor）の存在と機能 | E-38 | ○ |
| C-38 | 応答時間モニター（ResponseTimeMonitor）の存在と機能 | E-39 | ○ |
| C-39 | 時刻同期モニター（ClockMonitor）の存在と機能 | E-40 | ○ |
| C-40 | アーキテクチャモニター（ArchitectureMonitor）の存在と機能 | E-41 | ○ |
| C-41 | メモリ使用量モニター（MemoryUsageMonitor）の存在と機能 | E-42 | ○ |
| C-42 | コントローラーエグゼキュータ警告（エージェントあり）の存在 | E-43 | ○ |
| C-43 | コントローラーエグゼキュータ警告（エージェントなし）の存在 | E-44 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。すべての通知機能について、対応するソースコードを根拠として確認済み。

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：すべての項目に根拠あり
- 注意点：
  - メール通知機能（Mailer）は現在Jenkinsコアから分離されプラグインとして提供されているため、本一覧には含まれていない
  - プラグインで提供される追加の通知機能（Slack、Microsoft Teams、Email-ext等）は本一覧の対象外

## 6) レビュアーチェックリスト（最小）
- [ ] 管理者モニター（AdministrativeMonitor）の一覧が網羅的か確認
- [ ] ビルドトリガーの説明が正確か確認
- [ ] ノードモニターの閾値や動作条件が実装と一致しているか確認
- [ ] セキュリティ関連通知が適切にマークされているか確認
- [ ] プラグインとして提供される通知機能を別途管理する必要があるか検討
