# 通知設計書 1-セキュリティ無効警告（SecurityIsOffMonitor）

## 概要

本ドキュメントは、Jenkinsのセキュリティが無効になっている場合に管理者へ警告を表示するSecurityIsOffMonitor（セキュリティ無効警告）の通知設計について記述する。

### 本通知の処理概要

SecurityIsOffMonitorは、Jenkins管理画面においてセキュリティが無効化されている状態を検出し、管理者に対して警告メッセージを表示する通知機能である。

**業務上の目的・背景**：Jenkinsはデフォルトでセキュリティが有効化されているが、設定変更や特殊な環境により無効化される場合がある。セキュリティが無効な状態では、認証・認可なしでJenkinsの全機能にアクセス可能となり、重大なセキュリティリスクを引き起こす。本通知は、管理者がこの危険な状態を即座に認識し、適切なセキュリティ設定を行うよう促すことを目的とする。

**通知の送信タイミング**：Jenkins管理画面（/manage）にアクセスした際に、`isActivated()`メソッドが呼び出され、`Jenkins.get().isUseSecurity()`がfalseを返す場合に通知が有効化される。つまり、管理画面を表示するたびにリアルタイムでセキュリティ状態がチェックされる。

**通知の受信者**：Jenkins管理画面にアクセスできるユーザー（主に管理者）が対象となる。ただし、セキュリティが無効な状態では全ユーザーがアクセス可能であるため、実質的に全ユーザーが警告を目にする可能性がある。

**通知内容の概要**：警告メッセージ（blurb）として「Jenkinsのセキュリティが無効になっています」という旨のメッセージが表示され、「Setup Security」ボタンでセキュリティ設定画面への誘導、「Dismiss」ボタンで警告の非表示化が可能となる。

**期待されるアクション**：管理者は「Setup Security」ボタンをクリックしてセキュリティ設定画面（/configureSecurity）に遷移し、適切な認証・認可設定を行うことが期待される。緊急性が低いと判断した場合のみ「Dismiss」で警告を非表示にできるが、推奨されない。

## 通知種別

アプリ内通知（管理画面バナー表示）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（画面レンダリング時） |
| 優先度 | 高（セキュリティ関連） |
| リトライ | 無（画面表示のため不要） |

### 送信先決定ロジック

Jenkins管理画面（/manage）にアクセスした全ユーザーに対して表示される。ただし、`isEnabled()`がtrueであること（管理者によって明示的に無効化されていないこと）が条件となる。

## 通知テンプレート

### アプリ内通知の場合

| 項目 | 内容 |
|-----|------|
| 表示位置 | 管理画面上部 |
| アラートタイプ | jenkins-alert-warning（警告） |
| 形式 | HTML |

### 本文テンプレート

```html
<div class="jenkins-alert jenkins-alert-warning">
  <form method="post" action="${rootURL}/${it.url}/act" name="${it.id}">
    <f:submit name="yes" value="Setup Security"/>
    <f:submit name="no" value="Dismiss"/>
  </form>
  ${%blurb}
</div>
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| rootURL | JenkinsのルートURL | Jenkins.get().getRootUrl() | Yes |
| it.url | モニターのURL | AdministrativeMonitor.getUrl() | Yes |
| it.id | モニターのID | AdministrativeMonitor.id | Yes |
| blurb | 警告メッセージ本文 | Messages.properties | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | 管理画面（/manage）へのアクセス | Jenkins.isUseSecurity() == false | セキュリティが無効な場合に表示 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| disable(true)が呼び出された場合 | 管理者が「Dismiss」をクリックした場合、以降表示されない |
| isEnabled() == false | Jenkins設定でこのモニターが無効化されている場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[管理画面へアクセス] --> B{isEnabled?}
    B -->|No| C[表示しない]
    B -->|Yes| D{isActivated?}
    D -->|No| C
    D -->|Yes| E[警告バナー表示]
    E --> F{ユーザーアクション}
    F -->|Setup Security| G[/configureSecurity へリダイレクト]
    F -->|Dismiss| H[disable true で無効化]
    G --> I[終了]
    H --> J[/manage へリダイレクト]
    J --> I
    C --> I
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（ファイルベースの設定を参照）

### 参照ファイル

| ファイル | 用途 | 備考 |
|---------|------|------|
| $JENKINS_HOME/config.xml | useSecurity設定の参照 | Jenkins本体の設定ファイル |

### 更新ファイル

| ファイル | 操作 | 概要 |
|---------|------|------|
| $JENKINS_HOME/config.xml | UPDATE | disable()呼び出し時にdisabledAdministrativeMonitorsを更新 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 設定保存失敗 | disable()時のIOException | ログ出力、ユーザーに再試行を促す |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

該当なし（画面表示のため）

### 配信時間帯

制限なし（常時有効）

## セキュリティ考慮事項

- 本通知はセキュリティ関連（`isSecurity()` = true）としてマークされている
- セキュリティが無効な状態では全ユーザーがこの警告を見ることができる
- 「Dismiss」アクションは`@RequirePOST`で保護されている
- セキュリティ設定画面への誘導により、速やかな対処を促す

## 備考

- Symbol: `securityIsOff`
- パッケージ: jenkins.diagnostics
- 導入バージョン: Jenkins 1.x系から存在
- メッセージリソース: jenkins/diagnostics/Messages.properties

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

AdministrativeMonitorの基本構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | AdministrativeMonitor.java | `core/src/main/java/hudson/model/AdministrativeMonitor.java` | 管理モニターの基底クラス、id/isEnabled/isActivatedの仕組み |

**読解のコツ**: ExtensionPointを実装しており、@Extensionアノテーションで自動登録される点に注目。

#### Step 2: エントリーポイントを理解する

SecurityIsOffMonitorクラスがエントリーポイント。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SecurityIsOffMonitor.java | `core/src/main/java/jenkins/diagnostics/SecurityIsOffMonitor.java` | isActivated()でセキュリティ状態をチェック、doAct()でユーザーアクション処理 |

**主要処理フロー**:
1. **30-32行目**: `isActivated()` - `!Jenkins.get().isUseSecurity()`でセキュリティ無効を検出
2. **34-37行目**: `isSecurity()` - trueを返しセキュリティ関連通知としてマーク
3. **42-50行目**: `doAct()` - POSTリクエスト処理、yes/noパラメータで分岐

#### Step 3: ビューテンプレートを理解する

Jellyテンプレートで警告UIを構成。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | message.jelly | `core/src/main/resources/jenkins/diagnostics/SecurityIsOffMonitor/message.jelly` | 警告バナーのHTML構造、フォームボタンの配置 |

**主要処理フロー**:
- **27行目**: jenkins-alert-warningクラスで警告スタイル適用
- **28-31行目**: フォームでSetup Security/Dismissボタンを定義
- **32行目**: `${%blurb}`でローカライズされたメッセージを表示

### プログラム呼び出し階層図

```
Jenkins.getAdministrativeMonitors()
    │
    ├─ SecurityIsOffMonitor.isEnabled()
    │      └─ Jenkins.getDisabledAdministrativeMonitors().contains(id)
    │
    ├─ SecurityIsOffMonitor.isActivated()
    │      └─ Jenkins.isUseSecurity()
    │
    └─ SecurityIsOffMonitor.doAct(req, rsp)
           ├─ disable(true) → Jenkins.setDisabledAdministrativeMonitors()
           └─ rsp.sendRedirect()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

管理画面アクセス ───▶ isActivated()チェック ───▶ 警告バナー表示
                         │
                         └─ Jenkins.isUseSecurity()
                                    │
                                    ▼
                            config.xml参照
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SecurityIsOffMonitor.java | `core/src/main/java/jenkins/diagnostics/SecurityIsOffMonitor.java` | ソース | メインクラス |
| AdministrativeMonitor.java | `core/src/main/java/hudson/model/AdministrativeMonitor.java` | ソース | 基底クラス |
| message.jelly | `core/src/main/resources/jenkins/diagnostics/SecurityIsOffMonitor/message.jelly` | テンプレート | 警告UI |
| description.jelly | `core/src/main/resources/jenkins/diagnostics/SecurityIsOffMonitor/description.jelly` | テンプレート | 説明文 |
| Messages.properties | `core/src/main/resources/jenkins/diagnostics/Messages.properties` | リソース | メッセージ定義 |
| Jenkins.java | `core/src/main/java/jenkins/model/Jenkins.java` | ソース | isUseSecurity()提供 |
