# 通知設計書 11-APIトークン新規レガシー有効警告（ApiTokenPropertyEnabledNewLegacyAdministrativeMonitor）

## 概要

本ドキュメントは、Jenkins管理画面に表示される「APIトークン新規レガシー有効警告」通知の設計仕様を定義する。この通知は、レガシーAPIトークンの新規作成が有効になっている場合に管理者に警告を表示する。

### 本通知の処理概要

この通知は、Jenkinsの管理画面（/manage）においてセキュリティ警告として表示される管理者モニター機能である。レガシーAPIトークンの手動作成が許可されている設定状態を検出し、セキュリティリスクについて管理者に警告する。

**業務上の目的・背景**：レガシーAPIトークンは、新しいAPIトークンシステムと比較してセキュリティ上の脆弱性を持つ可能性がある。既存のレガシートークンを持たないユーザーでも新規にレガシートークンを作成できる設定は、セキュリティポリシーの観点から推奨されない。この警告により、管理者はセキュリティ設定の見直しを促される。

**通知の送信タイミング**：Jenkins管理画面（/manage）にアクセスした際に、`ApiTokenPropertyConfiguration.isCreationOfLegacyTokenEnabled()`がtrueを返す場合に表示される。具体的には、セキュリティ設定でレガシーAPIトークンの新規作成が有効化されている状態。

**通知の受信者**：Jenkins管理者（ADMINISTER権限を持つユーザー）。管理画面にアクセスできるユーザーのみがこの警告を確認可能。

**通知内容の概要**：レガシーAPIトークンの新規作成が有効であることの警告メッセージと、設定を無効化するためのアクションボタン、または警告を非表示にするためのDismissボタンが表示される。

**期待されるアクション**：管理者は「Prevent users from manually creating legacy API tokens」ボタンをクリックして設定を無効化するか、「Dismiss」ボタンで警告を非表示にする。セキュリティ上は設定の無効化が推奨される。

## 通知種別

アプリ内通知（Jenkins管理画面内のAdministrativeMonitor）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（画面レンダリング時に判定） |
| 優先度 | 高（セキュリティ関連警告） |
| リトライ | 該当なし（画面表示のため） |

### 送信先決定ロジック

AdministrativeMonitorフレームワークにより、Jenkins管理画面（/manage）にアクセスした管理者権限を持つユーザーに対して自動的に表示される。

## 通知テンプレート

### 表示形式

| 項目 | 内容 |
|-----|------|
| 表示エリア | Jenkins管理画面上部の警告セクション |
| スタイル | jenkins-alert jenkins-alert-warning（黄色背景の警告スタイル） |
| 形式 | HTML（Jellyテンプレート） |

### 本文テンプレート

```html
<div class="jenkins-alert jenkins-alert-warning">
    <form method="post" action="${rootURL}/${it.url}/act" name="${it.id}">
        <button name="yes">Prevent users from manually creating legacy API tokens</button>
        <button name="no">Dismiss</button>
    </form>
    警告メッセージ（国際化対応）
</div>
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| rootURL | JenkinsのルートURL | Jenkins.get().getRootUrl() | Yes |
| it.url | モニターのURL | AdministrativeMonitor.getUrl() | Yes |
| it.id | モニターのID | AdministrativeMonitor.getId() | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | /manage画面アクセス | isCreationOfLegacyTokenEnabled() == true | レガシートークン作成が有効な場合 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| creationOfLegacyTokenEnabled == false | レガシートークン作成が無効化されている場合は非表示 |
| モニターがdisable状態 | 管理者がDismissボタンで明示的に非表示にした場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[管理画面アクセス] --> B[AdministrativeMonitor.all取得]
    B --> C[各モニターのisActivated呼び出し]
    C --> D{ApiTokenPropertyConfiguration<br>.isCreationOfLegacyTokenEnabled?}
    D -->|true| E[警告メッセージ表示]
    D -->|false| F[表示スキップ]
    E --> G{ユーザーアクション}
    G -->|yes| H[設定を無効化]
    G -->|no| I[モニターをdisable]
    H --> J[管理画面へリダイレクト]
    I --> J
    F --> K[終了]
    J --> K
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| 該当なし | - | XMLファイルベースの設定参照 |

### 設定ファイル参照

#### ApiTokenPropertyConfiguration

| 参照項目 | 用途 | 取得条件 |
|-------------------|------|---------|
| creationOfLegacyTokenEnabled | レガシートークン作成許可設定 | GlobalConfiguration経由でロード |

### 更新処理

| 操作 | 対象 | 更新値 | 備考 |
|-----|-----------------|-------|------|
| UPDATE | creationOfLegacyTokenEnabled | false | 「Prevent」ボタン押下時 |
| UPDATE | AdministrativeMonitor.disabled | true | 「Dismiss」ボタン押下時 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 権限エラー | ADMINISTER権限なしでdoAct呼び出し | @RequirePOSTによる自動チェック |
| 設定保存エラー | 設定ファイル書き込み失敗 | IOException発生、ログ出力 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 該当なし（画面操作のため） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（画面表示のため） |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（管理画面アクセス時に常時判定）

## セキュリティ考慮事項

- doActメソッドは@RequirePOSTアノテーションにより、CSRF対策としてPOSTリクエストのみ受け付ける
- isSecurity()メソッドがtrueを返すことで、セキュリティ関連の警告として強調表示される
- 設定変更にはJenkins管理者権限（ADMINISTER）が必要

## 備考

- このモニターはJenkins 2.129以降で導入された
- CloudBees社により2018年に実装されたセキュリティ強化機能の一部
- @Symbol("apiTokenNewLegacyWithoutExisting")で識別可能

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、APIトークン設定の構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ApiTokenPropertyConfiguration.java | `core/src/main/java/jenkins/security/apitoken/ApiTokenPropertyConfiguration.java` | creationOfLegacyTokenEnabledフィールドと関連メソッドの役割を理解 |

**読解のコツ**: GlobalConfigurationを継承しており、Jenkins全体の設定として永続化される点に注目。

#### Step 2: エントリーポイントを理解する

処理の起点となるAdministrativeMonitorクラスを特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ApiTokenPropertyEnabledNewLegacyAdministrativeMonitor.java | `core/src/main/java/jenkins/security/apitoken/ApiTokenPropertyEnabledNewLegacyAdministrativeMonitor.java` | isActivated()とdoAct()メソッドの処理フローを確認 |

**主要処理フロー**:
1. **行45-48**: getDisplayName()でモニター名を返却
2. **行50-53**: isActivated()でcreationOfLegacyTokenEnabledの状態をチェック
3. **行55-58**: isSecurity()がtrueを返しセキュリティ警告として識別
4. **行60-68**: doAct()でユーザーアクション（設定変更またはdisable）を処理

#### Step 3: UIテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | message.jelly | `core/src/main/resources/jenkins/security/apitoken/ApiTokenPropertyEnabledNewLegacyAdministrativeMonitor/message.jelly` | 警告メッセージのHTML構造とフォームアクションを確認 |

**主要処理フロー**:
- **行26-33**: フォームとボタン、警告メッセージの表示ロジック

### プログラム呼び出し階層図

```
Jenkins管理画面（/manage）
    │
    ├─ AdministrativeMonitor.all()
    │      └─ ApiTokenPropertyEnabledNewLegacyAdministrativeMonitor.isActivated()
    │             └─ ApiTokenPropertyConfiguration.get().isCreationOfLegacyTokenEnabled()
    │
    └─ message.jelly（表示時）
           └─ doAct()（ボタン押下時）
                  ├─ ApiTokenPropertyConfiguration.setCreationOfLegacyTokenEnabled(false)
                  └─ disable(true)
```

### データフロー図

```
[入力]                    [処理]                           [出力]

管理画面アクセス ───▶ isActivated()判定 ───▶ 警告表示/非表示
                              │
                    ApiTokenPropertyConfiguration
                              │
ユーザーアクション ───▶ doAct()処理 ───▶ 設定更新/disable
                              │
                    HttpResponses.redirectViaContextPath
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ApiTokenPropertyEnabledNewLegacyAdministrativeMonitor.java | `core/src/main/java/jenkins/security/apitoken/` | ソース | メインの監視ロジック |
| ApiTokenPropertyConfiguration.java | `core/src/main/java/jenkins/security/apitoken/` | ソース | 設定管理 |
| message.jelly | `core/src/main/resources/jenkins/security/apitoken/ApiTokenPropertyEnabledNewLegacyAdministrativeMonitor/` | テンプレート | 警告表示UI |
| description.jelly | `core/src/main/resources/jenkins/security/apitoken/ApiTokenPropertyEnabledNewLegacyAdministrativeMonitor/` | テンプレート | モニター説明 |
| Messages.properties | `core/src/main/resources/jenkins/security/apitoken/` | 設定 | 国際化メッセージ |
