# 通知設計書 13-プラグイン循環依存警告（PluginCycleDependenciesMonitor）

## 概要

本ドキュメントは、Jenkins管理画面に表示される「プラグイン循環依存警告」通知の設計仕様を定義する。この通知は、インストールされているプラグイン間に循環依存関係が検出された場合に管理者に警告を表示する。

### 本通知の処理概要

この通知は、Jenkinsの管理画面（/manage）において危険度の高い警告（danger）として表示される管理者モニター機能である。プラグイン間の依存関係を解析し、循環依存が存在する場合に管理者に通知する。

**業務上の目的・背景**：プラグイン間の循環依存関係は、プラグインの正常なロードを妨げ、予期しない動作やシステムの不安定化を引き起こす可能性がある。この警告により、管理者は問題のあるプラグイン構成を早期に発見し、プラグインの更新や削除による解決を検討できる。

**通知の送信タイミング**：Jenkins管理画面（/manage）にアクセスした際に、PluginWrapper.hasCycleDependency()がtrueを返すプラグインが1つ以上存在する場合に表示される。Jenkinsの起動時にプラグインのロード処理中に循環依存が検出されると、該当プラグインにフラグが設定される。

**通知の受信者**：Jenkins管理者（ADMINISTER権限を持つユーザー）。管理画面にアクセスできるユーザーのみがこの警告を確認可能。

**通知内容の概要**：循環依存関係を持つプラグインのリスト（プラグイン名とバージョン）が表示される。これにより管理者は問題のあるプラグインを特定できる。

**期待されるアクション**：管理者は表示されたプラグインリストを確認し、プラグインマネージャーで該当プラグインの更新、無効化、またはアンインストールを行う。循環依存の解消には、依存関係の競合を解決するプラグインバージョンへの更新が必要。

## 通知種別

アプリ内通知（Jenkins管理画面内のAdministrativeMonitor）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（画面レンダリング時に判定） |
| 優先度 | 高（システム安定性に関わる警告） |
| リトライ | 該当なし（画面表示のため） |

### 送信先決定ロジック

AdministrativeMonitorフレームワークにより、Jenkins管理画面（/manage）にアクセスした管理者権限を持つユーザーに対して自動的に表示される。

## 通知テンプレート

### 表示形式

| 項目 | 内容 |
|-----|------|
| 表示エリア | Jenkins管理画面上部の警告セクション |
| スタイル | jenkins-alert jenkins-alert-danger（赤色背景の危険スタイル） |
| 形式 | HTML（Jellyテンプレート） |

### 本文テンプレート

```html
<div class="jenkins-alert jenkins-alert-danger">
    <dl>
        <dt>循環依存関係を持つプラグイン：</dt>
        <!-- 各プラグインについて繰り返し -->
        <dd>プラグイン名 vバージョン</dd>
    </dl>
</div>
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| it.pluginsWithCycle | 循環依存を持つプラグインリスト | PluginCycleDependenciesMonitor.getPluginsWithCycle() | Yes |
| p.longName | プラグインの正式名称 | PluginWrapper.getLongName() | Yes |
| p.version | プラグインのバージョン | PluginWrapper.getVersion() | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | /manage画面アクセス | pluginsWithCycle.size() > 0 | 循環依存プラグインが存在する場合 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 循環依存プラグインなし | 全プラグインでhasCycleDependency() == falseの場合は非表示 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[Jenkins起動] --> B[プラグインロード処理]
    B --> C{循環依存検出?}
    C -->|あり| D[PluginWrapper.hasCycleDependency=true]
    C -->|なし| E[通常起動]
    D --> F[管理画面アクセス]
    E --> F
    F --> G[AdministrativeMonitor.all取得]
    G --> H[PluginCycleDependenciesMonitor.isActivated]
    H --> I{循環依存プラグイン<br>リストをスキャン}
    I -->|存在| J[警告メッセージ表示]
    I -->|不在| K[表示スキップ]
    J --> L[終了]
    K --> L
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| 該当なし | - | メモリ上のプラグイン状態を参照 |

### メモリ参照

#### PluginManager / PluginWrapper

| 参照項目 | 用途 | 取得条件 |
|-------------------|------|---------|
| plugins | 全プラグインリスト | Jenkins.get().getPluginManager().getPlugins() |
| hasCycleDependency | 循環依存フラグ | PluginWrapper.hasCycleDependency() |

### 更新処理

| 操作 | 対象 | 更新値 | 備考 |
|-----|-----------------|-------|------|
| 参照のみ | - | - | 本モニターは状態を更新しない |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| プラグインリスト取得エラー | PluginManager未初期化 | 空リストとして扱う |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 該当なし（画面操作のため） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（画面表示のため） |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（管理画面アクセス時に常時判定）

## セキュリティ考慮事項

- 本モニターは読み取り専用で、状態変更を行わない
- プラグイン情報の表示には管理者権限が必要

## 備考

- このモニターはPluginManager内部クラスとして定義されている
- @Symbol("pluginCycleDependencies")で識別可能
- 循環依存の解決はプラグインマネージャー（/pluginManager）で行う
- isActivated()は初回呼び出し時にプラグインリストをスキャンしてキャッシュする（遅延初期化）

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、プラグインの依存関係管理構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | PluginWrapper.java | `core/src/main/java/hudson/PluginWrapper.java` | hasCycleDependency, setHasCycleDependency, dependencies, optionalDependenciesフィールドを理解 |

**読解のコツ**: PluginWrapperはプラグインのメタデータと依存関係情報を保持する。行169のhasCycleDependencyフィールドとその関連メソッドに注目。

#### Step 2: エントリーポイントを理解する

処理の起点となるAdministrativeMonitorクラスを特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | PluginManager.java | `core/src/main/java/hudson/PluginManager.java` | PluginCycleDependenciesMonitor内部クラス（行2555-2583付近）を確認 |

**主要処理フロー**:
1. **行2555**: PluginCycleDependenciesMonitorクラス定義
2. **行2562**: isActiveフラグとpluginsWithCycleリストの遅延初期化
3. **行2567-2578**: isActivated()で全プラグインをスキャンし、循環依存プラグインをリストに追加
4. **行2580-2582**: getPluginsWithCycle()でリストを返却

#### Step 3: UIテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | message.jelly | `core/src/main/resources/hudson/PluginManager/PluginCycleDependenciesMonitor/message.jelly` | 警告メッセージのHTML構造とプラグインリスト表示を確認 |

**主要処理フロー**:
- **行27-35**: jenkins-alert-dangerスタイルでプラグインリストを表示

### プログラム呼び出し階層図

```
Jenkins管理画面（/manage）
    │
    ├─ AdministrativeMonitor.all()
    │      └─ PluginCycleDependenciesMonitor.isActivated()
    │             └─ Jenkins.get().getPluginManager().getPlugins()
    │                    └─ PluginWrapper.hasCycleDependency()
    │
    └─ message.jelly（表示時）
           └─ getPluginsWithCycle()
                  └─ PluginWrapper.getLongName(), getVersion()
```

### データフロー図

```
[入力]                       [処理]                        [出力]

Jenkins起動 ───▶ プラグイン依存関係解析 ───▶ hasCycleDependencyフラグ設定
                        │
                  循環検出アルゴリズム
                        │
管理画面アクセス ───▶ isActivated()判定 ───▶ 警告表示/非表示
                        │
                プラグインリストスキャン
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| PluginManager.java | `core/src/main/java/hudson/` | ソース | モニター定義（内部クラス） |
| PluginWrapper.java | `core/src/main/java/hudson/` | ソース | プラグイン情報・依存関係管理 |
| message.jelly | `core/src/main/resources/hudson/PluginManager/PluginCycleDependenciesMonitor/` | テンプレート | 警告表示UI |
| description.jelly | `core/src/main/resources/hudson/PluginManager/PluginCycleDependenciesMonitor/` | テンプレート | モニター説明 |
| Messages.properties | `core/src/main/resources/hudson/` | 設定 | 国際化メッセージ |
