# 通知設計書 14-プラグイン更新通知（PluginUpdateMonitor）

## 概要

本ドキュメントは、Jenkins管理画面に表示される「プラグイン更新通知」の設計仕様を定義する。この通知は、インストールされているプラグインに必要な更新がある場合に管理者に通知を表示する。

### 本通知の処理概要

この通知は、Jenkinsの管理画面（/manage）において危険度の高い警告（danger）として表示される管理者モニター機能である。他のプラグインや機能が特定のプラグインの更新を要求した場合に、管理者に通知する。

**業務上の目的・背景**：プラグイン間の互換性や新機能の利用には、適切なバージョンのプラグインが必要となる場合がある。この通知により、管理者は他のプラグインが必要とするプラグイン更新を認識し、システムの互換性を維持できる。

**通知の送信タイミング**：Jenkins管理画面（/manage）にアクセスした際に、ifPluginOlderThenReport()やaddPluginToUpdate()メソッドで登録された更新情報が存在する場合に表示される。主に他のプラグインやJenkinsコアが特定のプラグイン更新を要求する際に使用される。

**通知の受信者**：Jenkins管理者（ADMINISTER権限を持つユーザー）。管理画面にアクセスできるユーザーのみがこの警告を確認可能。

**通知内容の概要**：更新が必要なプラグインのリスト（プラグイン名と更新理由のメッセージ）が表示される。

**期待されるアクション**：管理者は表示されたプラグインリストを確認し、プラグインマネージャーで該当プラグインを更新する。更新により他のプラグインとの互換性問題が解消される。

## 通知種別

アプリ内通知（Jenkins管理画面内のAdministrativeMonitor）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（画面レンダリング時に判定） |
| 優先度 | 高（プラグイン互換性に関わる通知） |
| リトライ | 該当なし（画面表示のため） |

### 送信先決定ロジック

AdministrativeMonitorフレームワークにより、Jenkins管理画面（/manage）にアクセスした管理者権限を持つユーザーに対して自動的に表示される。

## 通知テンプレート

### 表示形式

| 項目 | 内容 |
|-----|------|
| 表示エリア | Jenkins管理画面上部の警告セクション |
| スタイル | jenkins-alert jenkins-alert-danger（赤色背景の危険スタイル） |
| 形式 | HTML（Jellyテンプレート） |

### 本文テンプレート

```html
<div class="jenkins-alert jenkins-alert-danger">
    <dl>
        <dt>必要なプラグイン更新：</dt>
        <!-- 各プラグインについて繰り返し -->
        <dd>プラグイン名 — 更新理由メッセージ</dd>
    </dl>
</div>
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| it.pluginsToBeUpdated | 更新が必要なプラグイン情報リスト | PluginUpdateMonitor.getPluginsToBeUpdated() | Yes |
| p.pluginName | プラグイン名 | PluginUpdateInfo.pluginName | Yes |
| p.message | 更新理由メッセージ | PluginUpdateInfo.message | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | /manage画面アクセス | pluginsToBeUpdated.size() > 0 | 更新要求プラグインが存在する場合 |
| API呼び出し | ifPluginOlderThenReport() | プラグインが指定バージョンより古い場合 | 他のプラグインからの更新要求 |
| API呼び出し | addPluginToUpdate() | 明示的な更新要求 | 直接的な更新要求登録 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 更新要求プラグインなし | pluginsToBeUpdated.isEmpty()の場合は非表示 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[他のプラグイン/コア] --> B{プラグイン更新要求}
    B -->|ifPluginOlderThenReport| C[バージョンチェック]
    B -->|addPluginToUpdate| D[直接登録]
    C -->|古い| E[pluginsToBeUpdatedに追加]
    C -->|新しい| F[追加なし]
    D --> E
    E --> G[管理画面アクセス]
    F --> G
    G --> H[AdministrativeMonitor.all取得]
    H --> I[PluginUpdateMonitor.isActivated]
    I --> J{pluginsToBeUpdated<br>が空でない?}
    J -->|はい| K[警告メッセージ表示]
    J -->|いいえ| L[表示スキップ]
    K --> M[終了]
    L --> M
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| 該当なし | - | メモリ上の状態を参照 |

### メモリ参照

#### PluginUpdateMonitor

| 参照項目 | 用途 | 取得条件 |
|-------------------|------|---------|
| pluginsToBeUpdated | 更新要求プラグインマップ | Map<String, PluginUpdateInfo> |

### 更新処理

| 操作 | 対象 | 更新値 | 備考 |
|-----|-----------------|-------|------|
| PUT | pluginsToBeUpdated | PluginUpdateInfo | ifPluginOlderThenReportまたはaddPluginToUpdate呼び出し時 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| プラグイン未検出 | 指定プラグイン名が存在しない | 更新要求をスキップ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 該当なし（画面操作のため） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（画面表示のため） |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（管理画面アクセス時に常時判定）

## セキュリティ考慮事項

- 本モニターは読み取り専用の表示機能（表示部分）
- 更新要求の登録は他のプラグインやコアからのAPI呼び出しによる
- プラグイン情報の表示には管理者権限が必要

## 備考

- このモニターはPluginManager内部クラスとして定義されている
- @Symbol("pluginUpdate")で識別可能
- Jenkins 1.491以降で導入された
- getInstance()メソッドにより他のプラグインから容易にアクセス可能
- プラグインの更新実行はプラグインマネージャー（/pluginManager）で行う

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、更新要求情報の構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | PluginManager.java | `core/src/main/java/hudson/PluginManager.java` | PluginUpdateInfo内部クラス（行2641-2649付近）を理解 |

**読解のコツ**: PluginUpdateInfoはシンプルなデータクラスで、pluginNameとmessageの2つのフィールドを持つ。

#### Step 2: エントリーポイントを理解する

処理の起点となるAdministrativeMonitorクラスを特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | PluginManager.java | `core/src/main/java/hudson/PluginManager.java` | PluginUpdateMonitor内部クラス（行2585-2651付近）を確認 |

**主要処理フロー**:
1. **行2590**: PluginUpdateMonitorクラス定義
2. **行2592**: pluginsToBeUpdatedマップでプラグイン更新情報を保持
3. **行2597-2600**: getInstance()でシングルトンとしてアクセス
4. **行2609-2616**: ifPluginOlderThenReport()でバージョン比較と登録
5. **行2618-2620**: isActivated()で更新要求の存在を確認
6. **行2633-2635**: addPluginToUpdate()で直接登録

#### Step 3: UIテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | message.jelly | `core/src/main/resources/hudson/PluginManager/PluginUpdateMonitor/message.jelly` | 警告メッセージのHTML構造とプラグインリスト表示を確認 |

**主要処理フロー**:
- **行27-35**: jenkins-alert-dangerスタイルでプラグインリストを表示
- **行30-32**: forEach でプラグインリストを繰り返し、名前とメッセージを表示

### プログラム呼び出し階層図

```
他のプラグイン/Jenkinsコア
    │
    ├─ PluginUpdateMonitor.getInstance()
    │      │
    │      ├─ ifPluginOlderThenReport(pluginName, requiredVersion, message)
    │      │      ├─ Jenkins.get().getPlugin(pluginName)
    │      │      ├─ VersionNumber比較
    │      │      └─ pluginsToBeUpdated.put()
    │      │
    │      └─ addPluginToUpdate(pluginName, message)
    │             └─ pluginsToBeUpdated.put()
    │
Jenkins管理画面（/manage）
    │
    ├─ AdministrativeMonitor.all()
    │      └─ PluginUpdateMonitor.isActivated()
    │             └─ !pluginsToBeUpdated.isEmpty()
    │
    └─ message.jelly（表示時）
           └─ getPluginsToBeUpdated()
```

### データフロー図

```
[入力]                          [処理]                        [出力]

他プラグインからの要求 ───▶ ifPluginOlderThenReport() ───▶ pluginsToBeUpdatedに登録
                                    │
                            VersionNumber比較
                                    │
管理画面アクセス ───▶ isActivated()判定 ───▶ 警告表示/非表示
                                    │
                            マップの空チェック
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| PluginManager.java | `core/src/main/java/hudson/` | ソース | モニター定義（内部クラス） |
| PluginWrapper.java | `core/src/main/java/hudson/` | ソース | プラグイン情報・バージョン取得 |
| message.jelly | `core/src/main/resources/hudson/PluginManager/PluginUpdateMonitor/` | テンプレート | 警告表示UI |
| description.jelly | `core/src/main/resources/hudson/PluginManager/PluginUpdateMonitor/` | テンプレート | モニター説明 |
| Messages.properties | `core/src/main/resources/hudson/` | 設定 | 国際化メッセージ |
