# 通知設計書 15-プラグイン非推奨警告（PluginDeprecationMonitor）

## 概要

本ドキュメントは、Jenkins管理画面に表示される「プラグイン非推奨警告」通知の設計仕様を定義する。この通知は、インストールされているプラグインが非推奨（deprecated）としてマークされている場合に管理者に警告を表示する。

### 本通知の処理概要

この通知は、Jenkinsの管理画面（/manage）において警告（warning）として表示される管理者モニター機能である。更新サイトのメタデータを参照し、非推奨としてマークされたプラグインがインストールされている場合に管理者に通知する。

**業務上の目的・背景**：非推奨のプラグインは、メンテナンスが停止されている、またはセキュリティ上の問題がある可能性がある。この警告により、管理者は非推奨プラグインを認識し、代替プラグインへの移行や削除を検討できる。

**通知の送信タイミング**：Jenkins管理画面（/manage）にアクセスした際に、PluginWrapper.isDeprecated()がtrueを返すプラグインが1つ以上存在する場合に表示される。非推奨情報は更新サイトのデータから取得される。

**通知の受信者**：Jenkins管理者（ADMINISTER権限を持つユーザー）。管理画面にアクセスできるユーザーのみがこの警告を確認可能。

**通知内容の概要**：非推奨としてマークされたプラグインのリスト（プラグイン名と詳細情報へのリンク）が表示される。

**期待されるアクション**：管理者は表示されたプラグインリストを確認し、リンク先で非推奨の理由を確認。代替プラグインへの移行、またはプラグインの削除を検討する。

## 通知種別

アプリ内通知（Jenkins管理画面内のAdministrativeMonitor）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（画面レンダリング時に判定） |
| 優先度 | 中（非推奨警告） |
| リトライ | 該当なし（画面表示のため） |

### 送信先決定ロジック

AdministrativeMonitorフレームワークにより、Jenkins管理画面（/manage）にアクセスした管理者権限を持つユーザーに対して自動的に表示される。

## 通知テンプレート

### 表示形式

| 項目 | 内容 |
|-----|------|
| 表示エリア | Jenkins管理画面上部の警告セクション |
| スタイル | jenkins-alert jenkins-alert-warning（黄色背景の警告スタイル） |
| 形式 | HTML（Jellyテンプレート） |

### 本文テンプレート

```html
<div class="jenkins-alert jenkins-alert-warning">
    <dl>
        <dt>非推奨プラグイン：</dt>
        <!-- 各プラグインについて繰り返し -->
        <dd><a href="詳細URL">プラグイン名</a></dd>
    </dl>
    <p>非推奨プラグインの説明...</p>
</div>
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| it.getDeprecatedPlugins() | 非推奨プラグインとURL のマップ | PluginDeprecationMonitor.getDeprecatedPlugins() | Yes |
| e.key | プラグインラッパー | PluginWrapper | Yes |
| e.key.displayName | プラグイン表示名 | PluginWrapper.getDisplayName() | Yes |
| e.value | 詳細情報URL | Deprecation.url | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | /manage画面アクセス | getDeprecatedPlugins().size() > 0 | 非推奨プラグインが存在する場合 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 非推奨プラグインなし | 全プラグインでisDeprecated() == falseの場合は非表示 |
| 更新サイトデータ未取得 | 更新サイトのデータがない場合は判定不可 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[管理画面アクセス] --> B[AdministrativeMonitor.all取得]
    B --> C[PluginDeprecationMonitor.isActivated]
    C --> D[getDeprecatedPlugins呼び出し]
    D --> E[全プラグインをスキャン]
    E --> F{isDeprecated?}
    F -->|true| G[非推奨リストに追加]
    F -->|false| H[スキップ]
    G --> I{次のプラグイン}
    H --> I
    I -->|あり| F
    I -->|なし| J{非推奨リスト<br>が空でない?}
    J -->|はい| K[警告メッセージ表示]
    J -->|いいえ| L[表示スキップ]
    K --> M[終了]
    L --> M
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| 該当なし | - | メモリ上の状態と更新サイトデータを参照 |

### データ参照

#### UpdateCenter / UpdateSite

| 参照項目 | 用途 | 取得条件 |
|-------------------|------|---------|
| deprecations | 非推奨プラグイン情報 | UpdateSite.Data.getDeprecations() |

#### PluginWrapper

| 参照項目 | 用途 | 取得条件 |
|-------------------|------|---------|
| isDeprecated() | 非推奨判定 | getDeprecations().isEmpty() == false |
| getDeprecations() | 非推奨詳細情報 | 更新サイトデータから取得 |

### 更新処理

| 操作 | 対象 | 更新値 | 備考 |
|-----|-----------------|-------|------|
| 参照のみ | - | - | 本モニターは状態を更新しない |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 更新サイトデータ未取得 | 更新サイトに接続できない | 空の非推奨リストとして扱う |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 該当なし（画面操作のため） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（画面表示のため） |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（管理画面アクセス時に常時判定）

## セキュリティ考慮事項

- 本モニターは読み取り専用で、状態変更を行わない
- 外部リンク（非推奨詳細URL）はrel="noopener noreferrer" target="_blank"で開く
- プラグイン情報の表示には管理者権限が必要

## 備考

- このモニターはPluginManager内部クラスとして定義されている
- @Symbol("pluginDeprecation")で識別可能
- Jenkins 2.246以降で導入された
- @Restricted(NoExternalUse.class)で内部API制限されている
- 非推奨情報はupdate-center.jsonのdeprecationsフィールドから取得される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、非推奨情報の構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | PluginWrapper.java | `core/src/main/java/hudson/PluginWrapper.java` | isDeprecated()、getDeprecations()メソッドを理解 |

**読解のコツ**: PluginWrapper.isDeprecated()は行374-381にあり、getDeprecations()が空でないかを確認する。getDeprecations()は行1399-1416で更新サイトデータから非推奨情報を取得する。

#### Step 2: エントリーポイントを理解する

処理の起点となるAdministrativeMonitorクラスを特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | PluginManager.java | `core/src/main/java/hudson/PluginManager.java` | PluginDeprecationMonitor内部クラス（行2653-2681付近）を確認 |

**主要処理フロー**:
1. **行2661**: PluginDeprecationMonitorクラス定義
2. **行2663-2665**: getDisplayName()で国際化メッセージ取得
3. **行2667-2670**: isActivated()で非推奨プラグインの存在を確認
4. **行2672-2680**: getDeprecatedPlugins()でプラグインリストを生成

#### Step 3: UIテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | message.jelly | `core/src/main/resources/hudson/PluginManager/PluginDeprecationMonitor/message.jelly` | 警告メッセージのHTML構造とプラグインリスト表示を確認 |

**主要処理フロー**:
- **行27-36**: jenkins-alert-warningスタイルでプラグインリストを表示
- **行30-32**: forEach でプラグインリストを繰り返し、リンク付きでプラグイン名を表示

### プログラム呼び出し階層図

```
Jenkins管理画面（/manage）
    │
    ├─ AdministrativeMonitor.all()
    │      └─ PluginDeprecationMonitor.isActivated()
    │             └─ !getDeprecatedPlugins().isEmpty()
    │
    └─ message.jelly（表示時）
           └─ getDeprecatedPlugins()
                  └─ Jenkins.get().getPluginManager().getPlugins()
                         └─ PluginWrapper.isDeprecated()
                                └─ getDeprecations()
                                       └─ UpdateSite.Data.getDeprecations()
```

### データフロー図

```
[入力]                          [処理]                           [出力]

更新サイト(update-center.json) ───▶ UpdateSite.Data.getDeprecations() ───▶ 非推奨情報
                                           │
                                    PluginWrapper.getDeprecations()
                                           │
管理画面アクセス ───▶ isActivated()判定 ───▶ 警告表示/非表示
                                           │
                            getDeprecatedPlugins()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| PluginManager.java | `core/src/main/java/hudson/` | ソース | モニター定義（内部クラス） |
| PluginWrapper.java | `core/src/main/java/hudson/` | ソース | プラグイン情報・非推奨判定 |
| UpdateSite.java | `core/src/main/java/hudson/model/` | ソース | 更新サイトデータ・非推奨情報 |
| message.jelly | `core/src/main/resources/hudson/PluginManager/PluginDeprecationMonitor/` | テンプレート | 警告表示UI |
| description.jelly | `core/src/main/resources/hudson/PluginManager/PluginDeprecationMonitor/` | テンプレート | モニター説明 |
| Messages.properties | `core/src/main/resources/hudson/` | 設定 | 国際化メッセージ |
