# 通知設計書 17-SCMポーリング渋滞警告（SCMTrigger.AdministrativeMonitorImpl）

## 概要

本ドキュメントは、Jenkins管理画面に表示される「SCMポーリング渋滞警告」通知の設計仕様を定義する。この通知は、SCMポーリングキューが渋滞（処理待ちが溜まっている）状態の場合に管理者に警告を表示する。

### 本通知の処理概要

この通知は、Jenkinsの管理画面（/manage）において警告（warning）として表示される管理者モニター機能である。SCMポーリングの実行キューが処理能力を超えて滞留している状態を検出し、管理者に通知する。

**業務上の目的・背景**：SCMポーリングは、ソースコード管理システムの変更を定期的にチェックする機能である。多数のジョブが同時にポーリングを行う場合や、ポーリング処理が遅い場合、キューが渋滞する可能性がある。渋滞が発生すると、変更検出が遅延し、ビルドのタイムリーな実行に影響する。

**通知の送信タイミング**：SCMポーリングが実行されるたびにclogCheck()が呼び出され、キューの状態をチェックする。キューが「飢餓状態」（STARVATION_THRESHOLD時間以上処理待ち）の場合にonフラグがtrueになり、管理画面で警告が表示される。

**通知の受信者**：Jenkins管理者（ADMINISTER権限を持つユーザー）。管理画面にアクセスできるユーザーのみがこの警告を確認可能。

**通知内容の概要**：SCMポーリングキューが渋滞していることの警告メッセージが表示される。

**期待されるアクション**：管理者はポーリングスレッド数の増加（システム設定で変更可能）、ポーリング頻度の削減、またはジョブの整理を検討する。

## 通知種別

アプリ内通知（Jenkins管理画面内のAdministrativeMonitor）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（ポーリング実行時に状態更新、画面表示時に判定） |
| 優先度 | 中（パフォーマンス警告） |
| リトライ | 該当なし（画面表示のため） |

### 送信先決定ロジック

AdministrativeMonitorフレームワークにより、Jenkins管理画面（/manage）にアクセスした管理者権限を持つユーザーに対して自動的に表示される。

## 通知テンプレート

### 表示形式

| 項目 | 内容 |
|-----|------|
| 表示エリア | Jenkins管理画面上部の警告セクション |
| スタイル | jenkins-alert jenkins-alert-warning（黄色背景の警告スタイル） |
| 形式 | HTML（Jellyテンプレート） |

### 本文テンプレート

```html
<div class="jenkins-alert jenkins-alert-warning">
    SCMポーリングキューが渋滞しています。
    ポーリングスレッド数の増加を検討してください。
</div>
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| rootURL | JenkinsのルートURL | Jenkins.get().getRootUrl() | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| バッチ処理 | SCMポーリング実行 | queue.isStarving(STARVATION_THRESHOLD) | キューがSTARVATION_THRESHOLD以上滞留 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| on == false | キューが正常に処理されている場合は非表示 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[SCMトリガー発火] --> B[run メソッド呼び出し]
    B --> C{同期ポーリング?}
    C -->|はい| D[Runner.run直接実行]
    C -->|いいえ| E[queue.execute(Runner)]
    E --> F[clogCheck 呼び出し]
    F --> G{isClogged?}
    G -->|はい| H[on = true]
    G -->|いいえ| I[on = false]
    H --> J[管理画面アクセス]
    I --> J
    J --> K[AdministrativeMonitor.all取得]
    K --> L[AdministrativeMonitorImpl.isActivated]
    L --> M{on == true?}
    M -->|はい| N[警告メッセージ表示]
    M -->|いいえ| O[表示スキップ]
    N --> P[終了]
    O --> P
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| 該当なし | - | メモリ上の状態を参照 |

### メモリ参照

#### SequentialExecutionQueue

| 参照項目 | 用途 | 取得条件 |
|-------------------|------|---------|
| isStarving(threshold) | キュー飢餓状態判定 | 指定時間以上の滞留チェック |

### 更新処理

| 操作 | 対象 | 更新値 | 備考 |
|-----|-----------------|-------|------|
| UPDATE | AdministrativeMonitorImpl.on | true/false | clogCheck()呼び出し時 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| キュー渋滞 | STARVATION_THRESHOLD超過 | ポーリングスレッド数増加推奨 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 該当なし（画面操作のため） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（画面表示のため） |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（管理画面アクセス時に常時判定）

## セキュリティ考慮事項

- 本モニターは読み取り専用で、状態変更を行わない
- キュー状態の表示には管理者権限が必要

## 備考

- このモニターはSCMTrigger内部クラスとして定義されている
- STARVATION_THRESHOLDのデフォルト値は1時間（3600000ミリ秒）
- STARVATION_THRESHOLDはシステムプロパティで変更可能
- ポーリングスレッド数はシステム設定の「SCMポーリングの同時実行数」で変更可能
- デフォルトのスレッド数は10、範囲は5〜100

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、SCMポーリングキューの構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SCMTrigger.java | `core/src/main/java/hudson/triggers/SCMTrigger.java` | DescriptorImpl内のqueueフィールド（行232）とSequentialExecutionQueueの役割を理解 |

**読解のコツ**: SequentialExecutionQueueは、同じジョブの重複ポーリングを防ぎつつ、複数スレッドでポーリングを実行するキューシステム。

#### Step 2: エントリーポイントを理解する

処理の起点となるAdministrativeMonitorクラスを特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SCMTrigger.java | `core/src/main/java/hudson/triggers/SCMTrigger.java` | AdministrativeMonitorImpl内部クラス（行396-410付近）を確認 |

**主要処理フロー**:
1. **行396-397**: AdministrativeMonitorImplクラス定義（@Extension付き）
2. **行399-401**: getDisplayName()でモニター名を返却
3. **行403**: onフラグで警告状態を保持
4. **行405-408**: isActivated()でonフラグを返却
5. **行269-270**: isClogged()でキューの飢餓状態をチェック
6. **行277-279**: clogCheck()でonフラグを更新

#### Step 3: UIテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | message.jelly | `core/src/main/resources/hudson/triggers/SCMTrigger/AdministrativeMonitorImpl/message.jelly` | 警告メッセージのHTML構造を確認 |

**主要処理フロー**:
- **行27-29**: jenkins-alert-warningスタイルで警告メッセージを表示

### プログラム呼び出し階層図

```
SCMTrigger.run()
    │
    ├─ DescriptorImpl.synchronousPolling判定
    │      │
    │      ├─ true: Runner.run()直接実行
    │      │
    │      └─ false: queue.execute(Runner)
    │             └─ clogCheck()
    │                    └─ isClogged()
    │                           └─ queue.isStarving(STARVATION_THRESHOLD)
    │                                  └─ AdministrativeMonitorImpl.on = result

Jenkins管理画面（/manage）
    │
    ├─ AdministrativeMonitor.all()
    │      └─ AdministrativeMonitorImpl.isActivated()
    │             └─ return on
    │
    └─ message.jelly（表示時）
```

### データフロー図

```
[入力]                          [処理]                           [出力]

SCMトリガー発火 ───▶ queue.execute(Runner) ───▶ ポーリング実行
                           │
                    clogCheck()
                           │
                    isClogged()判定
                           │
管理画面アクセス ───▶ isActivated() ───▶ 警告表示/非表示
                           │
                    onフラグ参照
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SCMTrigger.java | `core/src/main/java/hudson/triggers/` | ソース | モニター定義（内部クラス）、ポーリング処理 |
| SequentialExecutionQueue.java | `core/src/main/java/hudson/util/` | ソース | ポーリングキュー管理 |
| message.jelly | `core/src/main/resources/hudson/triggers/SCMTrigger/AdministrativeMonitorImpl/` | テンプレート | 警告表示UI |
| description.jelly | `core/src/main/resources/hudson/triggers/SCMTrigger/AdministrativeMonitorImpl/` | テンプレート | モニター説明 |
| Messages.properties | `core/src/main/resources/hudson/triggers/` | 設定 | 国際化メッセージ |
