# 通知設計書 19-ノードオフライン警告（MonitorMarkedNodeOffline）

## 概要

本ドキュメントは、Jenkins管理画面に表示される「ノードオフライン警告」通知の設計仕様を定義する。この通知は、NodeMonitor（ノード監視機能）によってノード（エージェント）がオフラインとしてマークされた場合に管理者に警告を表示する。

### 本通知の処理概要

この通知は、Jenkinsの管理画面（/manage）において警告（warning）として表示される管理者モニター機能である。ノード監視機能がノードの問題（ディスク容量不足、メモリ不足、クロック同期問題など）を検出し、ノードをオフラインにした場合に管理者に通知する。

**業務上の目的・背景**：ノード（エージェント）は、ビルド処理を実行する計算リソースである。ノード監視機能は、ノードの健全性を定期的にチェックし、問題があるノードを自動的にオフラインにする。この警告により、管理者はオフラインになったノードの存在と原因を認識し、適切な対処を行える。

**通知の送信タイミング**：NodeMonitorがノードをオフラインにマークした際に、MonitorMarkedNodeOffline.activeフラグがtrueに設定される。管理画面アクセス時にこのフラグがチェックされる。

**通知の受信者**：Jenkins管理者（ADMINISTER権限を持つユーザー）。管理画面にアクセスできるユーザーのみがこの警告を確認可能。

**通知内容の概要**：ノードがオフラインにマークされたことの警告メッセージと、Dismissボタンが表示される。詳細なノード情報は別の画面で確認する。

**期待されるアクション**：管理者は「Dismiss」ボタンで警告を非表示にするか、ノード管理画面（/computer）で詳細を確認し、問題のあるノードを修復または除外する。

## 通知種別

アプリ内通知（Jenkins管理画面内のAdministrativeMonitor）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（ノード監視時に状態更新、画面表示時に判定） |
| 優先度 | 中（ノード健全性警告） |
| リトライ | 該当なし（画面表示のため） |

### 送信先決定ロジック

AdministrativeMonitorフレームワークにより、Jenkins管理画面（/manage）にアクセスした管理者権限を持つユーザーに対して自動的に表示される。

## 通知テンプレート

### 表示形式

| 項目 | 内容 |
|-----|------|
| 表示エリア | Jenkins管理画面上部の警告セクション |
| スタイル | jenkins-alert jenkins-alert-warning（黄色背景の警告スタイル） |
| 形式 | HTML（Jellyテンプレート） |

### 本文テンプレート

```html
<div class="jenkins-alert jenkins-alert-warning">
    <form method="post" action="${rootURL}/${it.url}/disable">
        <button>Dismiss</button>
    </form>
    ノード監視機能によってノードがオフラインとしてマークされました。
    詳細はノード管理画面で確認してください。
</div>
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| rootURL | JenkinsのルートURL | Jenkins.get().getRootUrl() | Yes |
| it.url | モニターのURL | AdministrativeMonitor.getUrl() | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| バッチ処理 | ノード監視実行 | ノードがオフラインにマークされた | NodeMonitor.markOffline呼び出し |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| active == false | オフラインマークされたノードがない、またはdisableされた場合は非表示 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[NodeMonitor定期実行] --> B[各ノードを監視]
    B --> C{問題検出?}
    C -->|あり| D[markOffline呼び出し]
    C -->|なし| E[次のノード]
    D --> F[MonitorMarkedNodeOffline.active = true]
    F --> G[管理画面アクセス]
    E --> G
    G --> H[AdministrativeMonitor.all取得]
    H --> I[MonitorMarkedNodeOffline.isActivated]
    I --> J{active == true?}
    J -->|はい| K[警告メッセージ表示]
    J -->|いいえ| L[表示スキップ]
    K --> M{ユーザーアクション}
    M -->|Dismiss| N[disable呼び出し]
    N --> O[終了]
    L --> O
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| 該当なし | - | メモリ上の状態を参照 |

### メモリ参照

#### MonitorMarkedNodeOffline

| 参照項目 | 用途 | 取得条件 |
|-------------------|------|---------|
| active | オフラインマーク発生フラグ | public boolean |

### 更新処理

| 操作 | 対象 | 更新値 | 備考 |
|-----|-----------------|-------|------|
| UPDATE | active | true | AbstractNodeMonitorDescriptor.markOffline呼び出し時 |
| UPDATE | disabled | true | Dismissボタン押下時 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| ディスク容量不足 | DiskSpaceMonitorでしきい値以下 | ディスククリーンアップ |
| メモリ不足 | SwapSpaceMonitorでしきい値以下 | メモリ増設またはプロセス最適化 |
| クロック同期問題 | ClockMonitorでしきい値以上のずれ | NTP設定の確認 |
| 応答タイムアウト | ResponseTimeMonitorでしきい値超過 | ネットワーク/ノード確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 該当なし（画面操作のため） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（画面表示のため） |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（管理画面アクセス時に常時判定）

## セキュリティ考慮事項

- 本モニターは読み取り専用の表示機能
- Dismissボタンは基底クラスのdisable()メソッドを使用
- ノード情報の表示には管理者権限が必要

## 備考

- このモニターは独立したクラスとして定義されている
- Jenkins 1.301以降で導入された（@since 1.301）
- 監視を完全に無効化するには、ノード管理画面でNodeMonitorを無効化する
- activeフラグはpublic変数として直接アクセス可能（後方互換性のため）
- 個々のノードオフライン情報は、/computer/{nodeName}で確認可能

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、モニターの基本構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | MonitorMarkedNodeOffline.java | `core/src/main/java/hudson/node_monitors/MonitorMarkedNodeOffline.java` | クラス全体（行39-52）を確認。非常にシンプルな構造 |

**読解のコツ**: このクラスは非常にシンプルで、activeというpublicフラグのみを持つ。状態管理の複雑さは呼び出し元に委譲されている。

#### Step 2: 呼び出し元を理解する

フラグを更新するmarkOfflineメソッドの呼び出し元を特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | AbstractNodeMonitorDescriptor.java | `core/src/main/java/hudson/node_monitors/AbstractNodeMonitorDescriptor.java` | markOffline()メソッド（行247-257）を確認 |

**主要処理フロー**:
1. **行247**: markOffline(Computer c, OfflineCause oc)メソッド定義
2. **行248**: isIgnored()チェック（無視設定の場合は何もしない）
3. **行250**: c.setTemporaryOfflineCause(oc)でノードをオフライン化
4. **行252-255**: MonitorMarkedNodeOffline.active = trueを設定

#### Step 3: ノードモニターの種類を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | DiskSpaceMonitor.java | `core/src/main/java/hudson/node_monitors/` | ディスク容量監視の例として参照 |

#### Step 4: UIテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | message.jelly | `core/src/main/resources/hudson/node_monitors/MonitorMarkedNodeOffline/message.jelly` | 警告メッセージのHTML構造を確認 |

**主要処理フロー**:
- **行27-33**: jenkins-alert-warningスタイルでDismissボタンと警告メッセージを表示

### プログラム呼び出し階層図

```
NodeMonitor実行（定期的）
    │
    └─ AbstractNodeMonitorDescriptor.monitor()
           │
           └─ 各Computerについて監視
                  │
                  └─ 問題検出時
                         └─ markOffline(c, OfflineCause)
                                ├─ c.setTemporaryOfflineCause(oc)
                                └─ MonitorMarkedNodeOffline.active = true

Jenkins管理画面（/manage）
    │
    ├─ AdministrativeMonitor.all()
    │      └─ MonitorMarkedNodeOffline.isActivated()
    │             └─ return active
    │
    └─ message.jelly（表示時）
           └─ Dismissボタン → disable()
```

### データフロー図

```
[入力]                          [処理]                           [出力]

NodeMonitor定期実行 ───▶ monitor() ───▶ 監視データ収集
                              │
                        問題判定
                              │
                        markOffline()
                              │
管理画面アクセス ───▶ isActivated() ───▶ 警告表示/非表示
                              │
                        activeフラグ参照

Dismissボタン ───▶ disable() ───▶ モニター非表示化
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| MonitorMarkedNodeOffline.java | `core/src/main/java/hudson/node_monitors/` | ソース | モニター定義 |
| AbstractNodeMonitorDescriptor.java | `core/src/main/java/hudson/node_monitors/` | ソース | ノード監視基底クラス、markOffline |
| NodeMonitor.java | `core/src/main/java/hudson/node_monitors/` | ソース | ノード監視インターフェース |
| DiskSpaceMonitor.java | `core/src/main/java/hudson/node_monitors/` | ソース | ディスク容量監視 |
| SwapSpaceMonitor.java | `core/src/main/java/hudson/node_monitors/` | ソース | スワップ容量監視 |
| message.jelly | `core/src/main/resources/hudson/node_monitors/MonitorMarkedNodeOffline/` | テンプレート | 警告表示UI |
| description.jelly | `core/src/main/resources/hudson/node_monitors/MonitorMarkedNodeOffline/` | テンプレート | モニター説明 |
| Messages.properties | `core/src/main/resources/hudson/node_monitors/` | 設定 | 国際化メッセージ |
