# 通知設計書 20-初期化完了警告（CompletedInitializationMonitor）

## 概要

本ドキュメントは、Jenkins管理画面に表示される「初期化完了警告」通知の設計仕様を定義する。この通知は、Jenkinsの初期化処理が正常に完了していない場合に管理者に警告を表示する。

### 本通知の処理概要

この通知は、Jenkinsの管理画面（/manage）において警告（warning）として表示される管理者モニター機能である。JenkinsのInitMilestone（初期化マイルストーン）がCOMPLETEDに達していない場合に、初期化が未完了であることを管理者に通知する。

**業務上の目的・背景**：Jenkinsの初期化処理は、プラグインのロードや各種サービスの起動など、複数のステップで構成されている。初期化が正常に完了しない場合、一部の機能が利用できない、または予期しない動作が発生する可能性がある。この警告により、管理者は初期化の問題を認識し、原因調査を行える。

**通知の送信タイミング**：Jenkins管理画面（/manage）にアクセスした際に、Jenkins.get().getInitLevel()がInitMilestone.COMPLETEDでない場合に表示される。通常、Jenkinsが完全に起動すればこの警告は表示されない。

**通知の受信者**：Jenkins管理者（ADMINISTER権限を持つユーザー）。管理画面にアクセスできるユーザーのみがこの警告を確認可能。

**通知内容の概要**：初期化が完了していないことの警告メッセージ、考えられる原因（@Initializer(after = InitMilestone.COMPLETED)の使用など）、およびバグ報告へのリンクが表示される。

**期待されるアクション**：管理者はJenkinsのログを確認し、初期化が停止した原因を調査する。プラグインの問題が疑われる場合は、問題のプラグインを無効化するか、Jenkinsバグトラッカーに報告する。

## 通知種別

アプリ内通知（Jenkins管理画面内のAdministrativeMonitor）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（画面レンダリング時に判定） |
| 優先度 | 高（システム初期化に関わる警告） |
| リトライ | 該当なし（画面表示のため） |

### 送信先決定ロジック

AdministrativeMonitorフレームワークにより、Jenkins管理画面（/manage）にアクセスした管理者権限を持つユーザーに対して自動的に表示される。

## 通知テンプレート

### 表示形式

| 項目 | 内容 |
|-----|------|
| 表示エリア | Jenkins管理画面上部の警告セクション |
| スタイル | jenkins-alert jenkins-alert-warning（黄色背景の警告スタイル） |
| 形式 | HTML（Jellyテンプレート） |

### 本文テンプレート

```html
<div class="jenkins-alert jenkins-alert-warning">
    Jenkinsの初期化が完了していません。現在の初期化レベル: {initLevel}
    例: プラグインで @Initializer(after = InitMilestone.COMPLETED) が使用されている可能性があります。
    <a href="https://www.jenkins.io/redirect/troubleshooting/initialization-not-completed">ドキュメントを参照</a>
    <a href="https://www.jenkins.io/redirect/report-an-issue">バグを報告</a>してください。
</div>
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| app.initLevel | 現在の初期化レベル | Jenkins.get().getInitLevel() | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | /manage画面アクセス | initLevel != COMPLETED | 初期化が完了していない場合 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| initLevel == COMPLETED | 初期化が正常に完了している場合は非表示 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[Jenkins起動] --> B[初期化処理開始]
    B --> C[各InitMilestone通過]
    C --> D{COMPLETED到達?}
    D -->|はい| E[初期化完了]
    D -->|いいえ/停止| F[初期化未完了状態]
    E --> G[管理画面アクセス]
    F --> G
    G --> H[AdministrativeMonitor.all取得]
    H --> I[CompletedInitializationMonitor.isActivated]
    I --> J{initLevel == COMPLETED?}
    J -->|はい| K[表示スキップ]
    J -->|いいえ| L[警告メッセージ表示]
    K --> M[終了]
    L --> M
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| 該当なし | - | メモリ上の状態を参照 |

### メモリ参照

#### Jenkins

| 参照項目 | 用途 | 取得条件 |
|-------------------|------|---------|
| initLevel | 現在の初期化マイルストーン | Jenkins.get().getInitLevel() |

### 更新処理

| 操作 | 対象 | 更新値 | 備考 |
|-----|-----------------|-------|------|
| 参照のみ | - | - | 本モニターは状態を更新しない |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 初期化未完了 | InitMilestone.COMPLETEDに到達しない | ログ確認、プラグイン無効化 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 該当なし（画面操作のため） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（画面表示のため） |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（管理画面アクセス時に常時判定）

## セキュリティ考慮事項

- 本モニターは読み取り専用で、状態変更を行わない
- 外部リンクはrel="noopener noreferrer" target="_blank"で開く
- 初期化状態の表示には管理者権限が必要

## 備考

- @Restricted(NoExternalUse.class)で内部API制限されている
- @Symbol("completedInitialization")で識別可能
- Jenkins 2.21以降で導入された（@since 2.21）
- HealthCheckインターフェースも実装しており、/healthチェックでも使用される
- 正常な状態ではこの警告は表示されない（起動完了後にCOMPLETEDになるため）

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、InitMilestoneの概念を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | InitMilestone.java | `core/src/main/java/hudson/init/InitMilestone.java` | 初期化マイルストーンの種類と順序を理解 |

**読解のコツ**: InitMilestoneは列挙型で、STARTED → PLUGINS_LISTED → PLUGINS_PREPARED → PLUGINS_STARTED → EXTENSIONS_AUGMENTED → JOB_LOADED → COMPLETEDの順序で進行する。

#### Step 2: エントリーポイントを理解する

処理の起点となるAdministrativeMonitorクラスを特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | CompletedInitializationMonitor.java | `core/src/main/java/jenkins/diagnostics/CompletedInitializationMonitor.java` | クラス全体（行42-75）を確認 |

**主要処理フロー**:
1. **行43-44**: @Extension @Symbol("completedInitialization")で登録
2. **行46-49**: getDisplayName()で国際化メッセージ取得
3. **行51-54**: isActivated()で初期化完了チェック
4. **行56-61**: isInitCompleted()でInitMilestone.COMPLETEDかを確認
5. **行63-74**: HealthCheckImpl内部クラスでヘルスチェックAPIにも対応

#### Step 3: UIテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | message.jelly | `core/src/main/resources/jenkins/diagnostics/CompletedInitializationMonitor/message.jelly` | 警告メッセージのHTML構造を確認 |

**主要処理フロー**:
- **行3-11**: jenkins-alert-warningスタイルで警告メッセージ、例、外部リンクを表示

### プログラム呼び出し階層図

```
Jenkins起動
    │
    └─ 初期化処理
           │
           ├─ InitMilestone.STARTED
           ├─ InitMilestone.PLUGINS_LISTED
           ├─ ...
           └─ InitMilestone.COMPLETED（正常終了時）

Jenkins管理画面（/manage）
    │
    ├─ AdministrativeMonitor.all()
    │      └─ CompletedInitializationMonitor.isActivated()
    │             └─ !isInitCompleted()
    │                    └─ Jenkins.get().getInitLevel() == COMPLETED?
    │
    └─ message.jelly（表示時）
           └─ app.initLevel（現在のレベル表示）

ヘルスチェックAPI（/health）
    │
    └─ HealthCheck.check()
           └─ CompletedInitializationMonitor.HealthCheckImpl.check()
                  └─ isInitCompleted()
```

### データフロー図

```
[入力]                          [処理]                           [出力]

Jenkins起動 ───▶ 初期化処理 ───▶ initLevel更新
                      │
              各InitMilestone通過
                      │
管理画面アクセス ───▶ isActivated() ───▶ 警告表示/非表示
                      │
              initLevel == COMPLETED?
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| CompletedInitializationMonitor.java | `core/src/main/java/jenkins/diagnostics/` | ソース | モニター定義、ヘルスチェック |
| InitMilestone.java | `core/src/main/java/hudson/init/` | ソース | 初期化マイルストーン定義 |
| Jenkins.java | `core/src/main/java/jenkins/model/` | ソース | Jenkinsコア、初期化状態管理 |
| message.jelly | `core/src/main/resources/jenkins/diagnostics/CompletedInitializationMonitor/` | テンプレート | 警告表示UI |
| description.jelly | `core/src/main/resources/jenkins/diagnostics/CompletedInitializationMonitor/` | テンプレート | モニター説明 |
| Messages.properties | `core/src/main/resources/jenkins/diagnostics/` | 設定 | 国際化メッセージ |
