# 通知設計書 21-URIエンコーディング警告

## 概要

本ドキュメントは、JenkinsのURIエンコーディング設定に問題がある場合に管理者へ警告を表示する通知機能（URICheckEncodingMonitor）の設計仕様を定義する。

### 本通知の処理概要

本通知は、JenkinsサーバーのサーブレットコンテナがURLをUTF-8でデコードしていない場合に、管理者に対して警告を表示する機能を提供する。

**業務上の目的・背景**：Jenkinsで非ASCII文字（日本語など）を含むジョブ名やパス名を使用する場合、サーブレットコンテナがURLをUTF-8でデコードする必要がある。正しく設定されていない場合、文字化けやジョブへのアクセス不可などの問題が発生するため、事前に警告を行い、適切な対応を促す。

**通知の送信タイミング**：Jenkinsの管理画面にアクセスした際に、JavaScriptを使用して非同期でエンコーディングチェックが実行され、問題がある場合に警告メッセージが表示される。

**通知の受信者**：Jenkins管理者（ADMINISTER権限を持つユーザー）が管理画面を閲覧した際に表示される。

**通知内容の概要**：サーブレットコンテナがUTF-8でURLをデコードしていないこと、および設定変更の必要性を示す警告メッセージが表示される。

**期待されるアクション**：管理者はサーブレットコンテナ（Tomcat等）の設定を確認し、URIEncodingをUTF-8に設定する必要がある。

## 通知種別

アプリ内通知（Jenkins管理画面への警告バナー表示）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（画面アクセス時に非同期JavaScriptで確認） |
| 優先度 | 中 |
| リトライ | 無し |

### 送信先決定ロジック

AdministrativeMonitorとして実装されているため、`/manage`画面にアクセスした管理者に対して表示される。表示条件は以下の通り：
- システムのデフォルトCharsetがISO-8859-1以外であること
- エンコーディングチェックで問題が検出されること

## 通知テンプレート

### 画面通知の場合

| 項目 | 内容 |
|-----|------|
| 表示名 | Check URI Encoding |
| 表示位置 | 管理画面のAdministrativeMonitorセクション |
| 形式 | 警告バナー（HTMLマークアップ付き） |

### 本文テンプレート

```
Your container doesn't use UTF-8 to decode URLs. If you use non-ASCII characters as a job name etc,
this will cause problems.
See Tomcat i18n for more details.
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| expected | 期待される文字列（非ASCII文字） | ハードコード値 "\u57f7\u4e8b" | Yes |
| value | 実際に受信された文字列 | リクエストパラメータ | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | 管理画面アクセス | チェック有効かつエンコーディング不一致 | JavaScriptで非同期チェック実行 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| Charset.defaultCharset()がISO-8859-1の場合 | チェック自体が無効化される |
| エンコーディングチェックが成功した場合 | 正常にUTF-8でデコードされている |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[管理画面アクセス] --> B{チェック有効?}
    B -->|Yes| C[JavaScript非同期リクエスト送信]
    B -->|No| I[表示なし]
    C --> D[doCheckURIEncoding実行]
    D --> E{期待値と一致?}
    E -->|No| F[FormValidation.warningWithMarkup返却]
    E -->|Yes| G[FormValidation.ok返却]
    F --> H[警告バナー表示]
    G --> I[表示なし]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（データベースを使用しない）

### 更新テーブル一覧

該当なし

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| リクエスト失敗 | JavaScriptリクエストが失敗 | サイレント失敗（エラー表示なし） |
| 権限不足 | ADMINISTER権限がない | チェック処理がスキップされる |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0 |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（管理画面アクセス時に表示）

## セキュリティ考慮事項

- チェック実行にはADMINISTER権限が必要
- 警告メッセージはHTMLマークアップを含むが、XSS対策としてエスケープ処理が行われている

## 備考

- このモニターは`@Restricted(NoExternalUse.class)`で外部利用が制限されている
- `isActivationFake()`がtrueを返すため、常時アクティブだが実際の判定はJavaScriptで行われる

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

AdministrativeMonitorの基本構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | AdministrativeMonitor.java | `core/src/main/java/hudson/model/AdministrativeMonitor.java` | 管理モニターの基底クラス構造を理解 |

**読解のコツ**: AdministrativeMonitorは抽象クラスで、`isActivated()`メソッドが表示条件を決定する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | URICheckEncodingMonitor.java | `core/src/main/java/jenkins/diagnostics/URICheckEncodingMonitor.java` | メインのモニター実装 |

**主要処理フロー**:
1. **25-27行目**: `isCheckEnabled()` - デフォルトCharsetがISO-8859-1かどうかを確認
2. **29-32行目**: `isActivated()` - 常にtrueを返す（実際の判定はJS側）
3. **44-57行目**: `doCheckURIEncoding()` - 実際のエンコーディングチェック処理

#### Step 3: UI層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | message.jelly | `core/src/main/resources/jenkins/diagnostics/URICheckEncodingMonitor/message.jelly` | 警告表示のUI定義 |
| 3-2 | uri-check-encoding-monitor.js | `core/src/main/resources/jenkins/diagnostics/URICheckEncodingMonitor/uri-check-encoding-monitor.js` | 非同期チェックのJavaScript |

**主要処理フロー**:
- **3-6行目**: チェック有効時のみUI要素を表示
- JavaScriptで非同期リクエストを送信し、結果に応じて警告を表示

### プログラム呼び出し階層図

```
Jenkins管理画面 (/manage)
    │
    ├─ message.jelly (UI表示)
    │      └─ uri-check-encoding-monitor.js (非同期チェック)
    │             └─ doCheckURIEncoding() (サーバー側チェック)
    │
    └─ URICheckEncodingMonitor
           ├─ isCheckEnabled()
           ├─ isActivated()
           └─ getDisplayName()
```

### データフロー図

```
[入力]               [処理]                    [出力]

ブラウザリクエスト ───▶ doCheckURIEncoding ───▶ FormValidation
(非ASCII文字列)           │                      (ok/warning)
                          │
                    エンコーディング比較
                    (expected vs value)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| URICheckEncodingMonitor.java | `core/src/main/java/jenkins/diagnostics/URICheckEncodingMonitor.java` | ソース | メインモニター実装 |
| message.jelly | `core/src/main/resources/jenkins/diagnostics/URICheckEncodingMonitor/message.jelly` | テンプレート | UI表示定義 |
| uri-check-encoding-monitor.js | `core/src/main/resources/jenkins/diagnostics/URICheckEncodingMonitor/uri-check-encoding-monitor.js` | ソース | クライアント側チェック |
| Messages.properties | `core/src/main/resources/jenkins/diagnostics/Messages.properties` | 設定 | メッセージ定義 |
| URICheckEncodingMonitorTest.java | `test/src/test/java/jenkins/diagnostics/URICheckEncodingMonitorTest.java` | テスト | 単体テスト |
