# 通知設計書 22-エージェントポート強制警告

## 概要

本ドキュメントは、Jenkinsエージェント接続ポートの設定がシステムプロパティで指定された値と異なる場合に管理者へ警告を表示する通知機能（EnforceSlaveAgentPortAdministrativeMonitor）の設計仕様を定義する。

### 本通知の処理概要

本通知は、Jenkinsのエージェント接続用TCPポートの設定がシステムプロパティ（`jenkins.model.Jenkins.slaveAgentPort`）で強制された値と異なる場合に、管理者に対して警告を表示し、設定を修正するためのアクションを提供する機能である。

**業務上の目的・背景**：大規模な組織やセキュリティ要件が厳しい環境では、ファイアウォール設定との整合性を保つため、エージェント接続ポートを特定の値に固定する必要がある。システムプロパティで設定された値と実際の設定値が異なる場合、意図しないセキュリティリスクやネットワーク接続の問題が発生する可能性があるため、管理者に警告を表示して修正を促す。

**通知の送信タイミング**：Jenkinsの管理画面にアクセスした際に、ポート設定の整合性チェックが実行され、不一致が検出された場合に警告が表示される。

**通知の受信者**：Jenkins管理者（ADMINISTER権限を持つユーザー）が管理画面を閲覧した際に表示される。

**通知内容の概要**：現在のエージェント接続ポート設定がシステムプロパティで強制された値と異なることを示す警告メッセージが表示され、修正アクションが提供される。

**期待されるアクション**：管理者は「Act」ボタンをクリックして、システムプロパティで指定されたポート値に設定を修正する。

## 通知種別

アプリ内通知（Jenkins管理画面への警告バナー表示）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（画面アクセス時にチェック） |
| 優先度 | 高 |
| リトライ | 無し |

### 送信先決定ロジック

AdministrativeMonitorとして実装されているため、`/manage`画面にアクセスした管理者に対して表示される。表示条件は以下の通り：
- `SLAVE_AGENT_PORT_ENFORCE`システムプロパティがtrueであること
- 現在の`slaveAgentPort`設定値がシステムプロパティで指定された初期値と異なること

## 通知テンプレート

### 画面通知の場合

| 項目 | 内容 |
|-----|------|
| 表示名 | Enforce TCP Agent Port |
| 表示位置 | 管理画面のAdministrativeMonitorセクション |
| 形式 | 警告バナー |

### 本文テンプレート

```
The TCP port for inbound agents is currently set to a different value than
what is configured via the system property. Click the button below to
update the setting to the enforced value.
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| expectedPort | 期待されるポート番号 | システムプロパティから計算 | Yes |
| systemPropertyName | システムプロパティ名 | jenkins.model.Jenkins.slaveAgentPort | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | 管理画面アクセス | ENFORCE=trueかつポート不一致 | 設定値とシステムプロパティ値の比較 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| SLAVE_AGENT_PORT_ENFORCEがfalse | ポート強制が無効の場合 |
| ポート設定値が期待値と一致 | 正常な状態 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[管理画面アクセス] --> B{ENFORCE有効?}
    B -->|No| I[表示なし]
    B -->|Yes| C[現在のポート取得]
    C --> D[期待値を計算]
    D --> E{値が一致?}
    E -->|Yes| I[表示なし]
    E -->|No| F[警告バナー表示]
    F --> G{Actボタン押下?}
    G -->|Yes| H[ポート設定を強制更新]
    H --> I[管理画面にリダイレクト]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（XML設定ファイルとシステムプロパティを使用）

### 更新対象

| 対象 | 操作 | 概要 |
|------|------|------|
| Jenkins設定 | UPDATE | slaveAgentPortの値を更新 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 権限不足 | ADMINISTER権限がない | 設定更新操作は失敗する |
| 設定保存失敗 | ファイルシステムエラー | IOException発生、ログ出力 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0 |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（管理画面アクセス時に表示）

## セキュリティ考慮事項

- エージェントポートの設定変更はセキュリティに直接影響するため、慎重に扱う必要がある
- doAct()メソッドは@RequirePOSTでCSRF保護されている
- システムプロパティによる強制は、管理者が誤ってポート設定を変更することを防止する

## 備考

- このモニターは`@Restricted(NoExternalUse.class)`で外部利用が制限されている
- Jenkinsクラスの内部クラスとして実装されている
- @Injectアノテーションでjenkinsインスタンスが注入される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Jenkins.java | `core/src/main/java/jenkins/model/Jenkins.java` | slaveAgentPort フィールドとSLAVE_AGENT_PORT_ENFORCE定数の理解 |

**読解のコツ**: Jenkinsクラスは巨大なため、検索でEnforceSlaveAgentPortAdministrativeMonitorを探す。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Jenkins.java (内部クラス) | `core/src/main/java/jenkins/model/Jenkins.java` | EnforceSlaveAgentPortAdministrativeMonitorクラス（1285-1314行目） |

**主要処理フロー**:
1. **1290-1291行目**: `getDisplayName()` - 表示名を返す
2. **1294-1296行目**: `getSystemPropertyName()` - システムプロパティ名を返す
3. **1298-1301行目**: `getExpectedPort()` - 期待されるポート値を計算
4. **1303-1307行目**: `doAct()` - ポート設定を強制更新するアクション
5. **1309-1313行目**: `isActivated()` - 表示条件をチェック

#### Step 3: 関連するメソッドを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Jenkins.java | `core/src/main/java/jenkins/model/Jenkins.java` | getSlaveAgentPortInitialValue()メソッド |
| 3-2 | Jenkins.java | `core/src/main/java/jenkins/model/Jenkins.java` | forceSetSlaveAgentPort()メソッド |

### プログラム呼び出し階層図

```
Jenkins管理画面 (/manage)
    │
    └─ EnforceSlaveAgentPortAdministrativeMonitor
           ├─ isActivated()
           │      ├─ Jenkins.get().slaveAgentPort
           │      └─ getSlaveAgentPortInitialValue()
           │
           ├─ getDisplayName()
           ├─ getSystemPropertyName()
           ├─ getExpectedPort()
           │
           └─ doAct() (POSTリクエスト)
                  └─ forceSetSlaveAgentPort()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

システムプロパティ ───▶ getSlaveAgentPortInitialValue() ──┐
                                                          │
slaveAgentPort設定値 ──────────────────────────────────────┼─▶ isActivated()
                                                          │      │
SLAVE_AGENT_PORT_ENFORCE ─────────────────────────────────┘      │
                                                                 ▼
                                                         警告バナー表示
                                                                 │
                                                     [Actボタン押下]
                                                                 │
                                                                 ▼
                                                   forceSetSlaveAgentPort()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Jenkins.java | `core/src/main/java/jenkins/model/Jenkins.java` | ソース | メインモニター実装（内部クラス） |
| Messages.properties | `core/src/main/resources/jenkins/model/Messages.properties` | 設定 | メッセージ定義（73行目） |
| message.jelly | `core/src/main/resources/jenkins/model/Jenkins/EnforceSlaveAgentPortAdministrativeMonitor/message.jelly` | テンプレート | UI表示定義 |
