# 通知設計書 23-Javaバージョン推奨警告

## 概要

本ドキュメントは、使用中のJavaバージョンがサポート終了に近い場合に管理者へ警告を表示する通知機能（JavaVersionRecommendationAdminMonitor）の設計仕様を定義する。

### 本通知の処理概要

本通知は、JenkinsコントローラーでサポートされているJava LTSバージョンのサポート終了日が近づいている場合に、管理者に対して警告または危険レベルのメッセージを表示し、Javaバージョンのアップグレードを促す機能を提供する。

**業務上の目的・背景**：Jenkinsは特定のJava LTSバージョン（Java 21、Java 25など）をサポートしているが、各バージョンにはサポート終了日が設定されている。サポート終了後はセキュリティパッチや不具合修正が提供されなくなるため、事前に管理者に通知し、計画的なアップグレードを促す必要がある。

**通知の送信タイミング**：サポート終了日の12ヶ月前から警告が表示され始め、3ヶ月を切ると危険レベルに昇格する。管理画面へのアクセス時に表示される。

**通知の受信者**：Jenkins.SYSTEM_READ権限を持つユーザーが管理画面を閲覧した際に表示される。

**通知内容の概要**：現在使用中のJavaバージョン、サポート終了日、推奨されるアクション（Javaバージョンのアップグレード）が表示される。

**期待されるアクション**：管理者はJenkinsのドキュメントを参照し、新しいJava LTSバージョンへのアップグレードを計画・実施する。

## 通知種別

アプリ内通知（Jenkins管理画面への警告/危険バナー表示）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（画面アクセス時にチェック） |
| 優先度 | 高（サポート終了3ヶ月未満で危険レベル） |
| リトライ | 無し |

### 送信先決定ロジック

AdministrativeMonitorとして実装されているため、`/manage`画面にアクセスしたユーザーに対して表示される。表示条件は以下の通り：
- システムプロパティで無効化されていないこと
- サポート終了までの期間が12ヶ月未満であること

## 通知テンプレート

### 画面通知の場合

| 項目 | 内容 |
|-----|------|
| 表示名 | Java Version Recommendation |
| 表示位置 | 管理画面のAdministrativeMonitorセクション |
| 形式 | 警告/危険バナー（重要度に応じて色が変化） |

### 本文テンプレート

```
You are running Jenkins on Java {version} which will reach end of life on {date}.
We recommend upgrading to a newer Java version before that date.
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| javaVersion | 現在のJavaバージョン番号 | Runtime.version().feature() | Yes |
| endOfLifeDate | サポート終了日 | SUPPORTED_JAVA_VERSIONS Map | Yes |
| severity | 重要度（warning/danger） | 終了日までの期間から計算 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | 管理画面アクセス | 終了日まで12ヶ月未満 | 警告レベルで表示 |
| 画面操作 | 管理画面アクセス | 終了日まで3ヶ月未満 | 危険レベルで表示 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| システムプロパティで無効化 | JavaVersionRecommendationAdminMonitor.disabled=true |
| サポート終了まで12ヶ月以上 | 警告不要 |
| ユーザーが「Dismiss」した場合 | 同一条件での再表示を抑止 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[管理画面アクセス] --> B{無効化されている?}
    B -->|Yes| I[表示なし]
    B -->|No| C[Javaバージョン取得]
    C --> D[サポート終了日を検索]
    D --> E{終了日まで12ヶ月未満?}
    E -->|No| I[表示なし]
    E -->|Yes| F{終了日まで3ヶ月未満?}
    F -->|Yes| G[DANGERレベルで表示]
    F -->|No| H[WARNINGレベルで表示]
    G --> J{ユーザーアクション?}
    H --> J
    J -->|Yes| K[外部リンクへ遷移]
    J -->|No/Dismiss| L[モニター無効化]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（静的定義とシステムプロパティを使用）

### 参照データ

| データ | 内容 |
|--------|------|
| SUPPORTED_JAVA_VERSIONS | Java 21: 2027-09-30, Java 25: 2029-09-30 |

### 更新対象

| 対象 | 操作 | 概要 |
|------|------|------|
| モニター設定 | UPDATE | disable(true)で無効化 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 設定保存失敗 | ファイルシステムエラー | IOException発生、ログ出力 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0 |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（管理画面アクセス時に表示）

## セキュリティ考慮事項

- 表示にはJenkins.SYSTEM_READ権限が必要
- 無効化操作にはJenkins.ADMINISTER権限が必要
- 外部リンク（jenkins.io）へのリダイレクトを含む

## 備考

- モニターIDにはJavaバージョン、終了日、重要度が含まれ、条件変更時に再表示される
- Eclipse Temurinのサポート終了日より前にJenkinsでのサポートを終了する設計
- @Symbolアノテーションで"javaVersionRecommendation"として参照可能

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | JavaVersionRecommendationAdminMonitor.java | `core/src/main/java/jenkins/monitor/JavaVersionRecommendationAdminMonitor.java` | SUPPORTED_JAVA_VERSIONSの定義（77-84行目） |

**読解のコツ**: NavigableMapを使用してJavaバージョンとサポート終了日のマッピングを保持している。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | JavaVersionRecommendationAdminMonitor.java | `core/src/main/java/jenkins/monitor/JavaVersionRecommendationAdminMonitor.java` | コンストラクタとgetId()メソッド（86-111行目） |

**主要処理フロー**:
1. **86-88行目**: コンストラクタでgetId()を呼び出し
2. **98-111行目**: IDにJavaバージョン、終了日、重要度を含める
3. **116-118行目**: isActivated() - 終了日まで12ヶ月未満かチェック
4. **152-154行目**: getDeprecationPeriod() - 終了日までの期間を計算
5. **157-159行目**: getSeverity() - 3ヶ月未満ならDANGER、それ以外はWARNING

#### Step 3: アクション処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | JavaVersionRecommendationAdminMonitor.java | `core/src/main/java/jenkins/monitor/JavaVersionRecommendationAdminMonitor.java` | doAct()メソッド（133-143行目） |

**主要処理フロー**:
- **136-138行目**: noパラメータがある場合はモニターを無効化
- **141行目**: それ以外の場合はjenkins.ioのドキュメントへリダイレクト

### プログラム呼び出し階層図

```
Jenkins管理画面 (/manage)
    │
    └─ JavaVersionRecommendationAdminMonitor
           ├─ isActivated()
           │      └─ getDeprecationPeriod()
           │             └─ getEndOfLife()
           │
           ├─ getSeverityAsString()
           │      └─ getSeverity()
           │             └─ getDeprecationPeriod()
           │
           ├─ getJavaVersion()
           │      └─ Runtime.version().feature()
           │
           ├─ getEndOfLifeAsDate()
           │      └─ getEndOfLife()
           │
           └─ doAct() (POSTリクエスト)
                  ├─ disable(true)
                  └─ HttpRedirect
```

### データフロー図

```
[入力]                    [処理]                         [出力]

Runtime.version() ──────▶ SUPPORTED_JAVA_VERSIONS ──┐
                                ↓                    │
                         getEndOfLife() ─────────────┼─▶ getDeprecationPeriod()
                                                     │         │
LocalDate.now() ─────────────────────────────────────┘         ▼
                                                        isActivated()
                                                              │
                                                              ▼
                                                  ┌─────────────────────┐
                                                  │ < 12ヶ月: 表示       │
                                                  │ < 3ヶ月: DANGER      │
                                                  │ >= 3ヶ月: WARNING    │
                                                  └─────────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| JavaVersionRecommendationAdminMonitor.java | `core/src/main/java/jenkins/monitor/JavaVersionRecommendationAdminMonitor.java` | ソース | メインモニター実装 |
| message.jelly | `core/src/main/resources/jenkins/monitor/JavaVersionRecommendationAdminMonitor/message.jelly` | テンプレート | UI表示定義 |
| Main.java | `war/src/main/java/executable/Main.java` | ソース | 起動時のJavaバージョンチェック |
