# 通知設計書 26-下流プロジェクトビルドトリガー

## 概要

本ドキュメントは、上流プロジェクトのビルド完了後に下流プロジェクトのビルドをトリガーする通知機能（BuildTrigger）の設計仕様を定義する。

### 本通知の処理概要

本通知は、上流プロジェクト（親プロジェクト）のビルドが完了した際に、設定された下流プロジェクト（子プロジェクト）のビルドを自動的にトリガーする機能である。これはJenkinsのパイプライン機能の基盤となる依存関係管理の中心的なコンポーネントである。

**業務上の目的・背景**：ソフトウェア開発において、複数のプロジェクト間には依存関係が存在する。例えば、共通ライブラリプロジェクトのビルドが成功した後に、それを使用するアプリケーションプロジェクトをビルドする必要がある。この依存関係を自動化することで、手動での介入なしに連続したビルドパイプラインを構築できる。

**通知の送信タイミング**：上流プロジェクトのビルド完了時に、ビルド結果が設定された閾値（SUCCESS、UNSTABLE等）以上の場合にトリガーされる。

**通知の受信者**：下流プロジェクトのビルドキューに対してトリガーが送信される。ビルドログには、どのプロジェクトがトリガーされたかが出力される。

**通知内容の概要**：ビルドキューへの投入とUpstreamCauseの設定。

**期待されるアクション**：下流プロジェクトのビルドが自動的に開始される。

## 通知種別

ビルドトリガー（システム内イベント通知）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（ビルド完了後にキューに投入） |
| 優先度 | 中（quietPeriod適用） |
| リトライ | 無し（キューに投入済みの場合は再投入しない） |

### 送信先決定ロジック

1. BuildTriggerの設定でchildProjects（カンマ区切り）を解析
2. 各下流プロジェクトに対して以下をチェック：
   - プロジェクトの存在確認
   - Item.BUILD権限の確認
   - ビルド可能状態（有効化されている）の確認
3. DependencyGraphを介して依存関係を解決

## 通知テンプレート

### ビルドログ出力

| 項目 | 内容 |
|-----|------|
| トリガー成功 | Triggering {project} #{buildNumber} |
| 既にキュー内 | {project} #{buildNumber} is already in the queue |
| 権限不足 | you have no permission to build {project} |
| 無効化中 | {project} is disabled |
| ビルド不可 | {project} is not buildable |

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| childProjects | 下流プロジェクト名（カンマ区切り） | 設定値 | Yes |
| threshold | トリガー条件となるビルド結果 | 設定値（デフォルトSUCCESS） | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| ビルド完了 | needsToRunAfterFinalized | 結果が閾値以上 | DependencyGraph経由で実行 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| ビルド結果が閾値未満 | SUCCESSを期待してFAILEDの場合など |
| 下流プロジェクトが無効化されている | isDisabled()がtrue |
| 権限不足 | Item.BUILD権限がない |
| 下流プロジェクトが既にキュー内 | 重複投入を防止 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[上流ビルド完了] --> B[DependencyGraph取得]
    B --> C[下流プロジェクト一覧取得]
    C --> D{各プロジェクトに対して}
    D --> E{shouldTriggerBuild?}
    E -->|No| F[スキップ]
    E -->|Yes| G{権限チェック}
    G -->|NG| H[権限エラーログ]
    G -->|OK| I{無効化チェック}
    I -->|無効| J[無効化ログ]
    I -->|有効| K[scheduleBuild2]
    K --> L{成功?}
    L -->|Yes| M[Triggeringログ]
    L -->|No| N[In Queueログ]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（XML設定とメモリ上のDependencyGraphを使用）

### 参照データ

| データ | 内容 |
|--------|------|
| DependencyGraph | プロジェクト間の依存関係グラフ |
| childProjects | 設定された下流プロジェクト名リスト |

### 更新対象

| 対象 | 操作 | 概要 |
|------|------|------|
| ビルドキュー | INSERT | 下流プロジェクトのビルドを投入 |
| CauseAction | INSERT | UpstreamCauseを設定 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| プロジェクト未存在 | 下流プロジェクトが削除されている | ログ出力、スキップ |
| 権限不足 | Item.BUILD権限がない | ログ出力、スキップ |
| 無効化 | 下流プロジェクトが無効化されている | ログ出力、スキップ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0 |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（ビルド完了時に即座に実行）

## セキュリティ考慮事項

- 下流プロジェクトへのItem.BUILD権限が必要
- 認証はTasks.getAuthenticationOf2()で取得されたユーザーコンテキストで実行
- フォルダリネーム時に自動的にchildProjectsが更新される

## 備考

- 対となる機能はReverseBuildTrigger（下流側で上流を指定）
- DependencyDeclarerインターフェースを実装
- @Symbolで"downstream"として参照可能
- ビルドステップではなくRecorderとして実装されている

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | BuildTrigger.java | `core/src/main/java/hudson/tasks/BuildTrigger.java` | フィールド定義（98-109行目） |

**読解のコツ**: childProjectsはカンマ区切りの文字列、thresholdはResult型でデフォルトSUCCESS。

#### Step 2: 依存関係グラフ構築を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | BuildTrigger.java | `core/src/main/java/hudson/tasks/BuildTrigger.java` | buildDependencyGraph()メソッド（314-333行目） |

**主要処理フロー**:
1. **315行目**: getChildProjects()で下流プロジェクト一覧を取得
2. **316-332行目**: 各プロジェクトに対してDependency追加
3. **319-331行目**: shouldTriggerBuildで権限と閾値をチェック

#### Step 3: 実行処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | BuildTrigger.java | `core/src/main/java/hudson/tasks/BuildTrigger.java` | execute()静的メソッド（258-311行目） |

**主要処理フロー**:
1. **263-276行目**: DependencyGraphを取得（非同期計算の結果を使用）
2. **278-287行目**: 下流プロジェクトをトポロジカルソート
3. **289-308行目**: 各依存関係に対してscheduleBuild呼び出し

#### Step 4: ビルドトリガー処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | BuildTrigger.java | `core/src/main/java/hudson/tasks/BuildTrigger.java` | perform()メソッド（196-240行目） |

**主要処理フロー**:
- **198-203行目**: AbstractProject以外のJobを処理
- **228行目**: UpstreamCauseを設定してscheduleBuild2呼び出し

### プログラム呼び出し階層図

```
上流プロジェクトのビルド完了
    │
    ├─ perform() (AbstractProject以外のJob)
    │      └─ scheduleBuild2(quietPeriod, UpstreamCause)
    │
    └─ execute() (AbstractProject - DependencyGraph経由)
           │
           ├─ getDependencyGraph()
           │
           ├─ getDownstreamDependencies()
           │      └─ sort() トポロジカルソート
           │
           └─ shouldTriggerBuild()
                  ├─ 権限チェック
                  └─ 閾値チェック
                         │
                         └─ scheduleBuild(quietPeriod, UpstreamCause, actions)
```

### データフロー図

```
[入力]                    [処理]                        [出力]

childProjects ─────▶ Items.fromNameList() ──┐
                                             │
上流ビルド結果 ─────▶ threshold比較 ─────────┼─▶ shouldTriggerBuild()
                                             │         │
Item.BUILD権限 ───────────────────────────────┘         ▼
                                                   scheduleBuild2()
                                                        │
                                                        ▼
                                               UpstreamCause設定
                                                        │
                                                        ▼
                                                ビルドキュー投入
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| BuildTrigger.java | `core/src/main/java/hudson/tasks/BuildTrigger.java` | ソース | メイントリガー実装 |
| DependencyGraph.java | `core/src/main/java/hudson/model/DependencyGraph.java` | ソース | 依存関係グラフ |
| Cause.java | `core/src/main/java/hudson/model/Cause.java` | ソース | UpstreamCause定義 |
| BuildTriggerTest.java | `test/src/test/java/hudson/tasks/BuildTriggerTest.java` | テスト | 単体テスト |
