# 通知設計書 29-タイマートリガー

## 概要

本ドキュメントは、cronスケジュールに基づいて定期的にビルドをトリガーする通知機能（TimerTrigger）の設計仕様を定義する。

### 本通知の処理概要

本通知は、設定されたcronスケジュール式に従って定期的にビルドを自動実行するシンプルなトリガー機能である。SCMの変更を確認せず、スケジュールに従って無条件にビルドを実行する。

**業務上の目的・背景**：定期的なビルド実行が必要なユースケースは多い。夜間バッチビルド、定期的なテスト実行、日次・週次のレポート生成など、時間に基づいてビルドをスケジュールする必要がある場合に使用する。SCMTriggerとは異なり、変更の有無に関わらずビルドを実行するため、定期的なリグレッションテストやパフォーマンステストに適している。

**通知の送信タイミング**：設定されたcronスケジュールに従って実行される。例えば、「0 0 * * *」は毎日深夜0時に実行される。

**通知の受信者**：プロジェクトのビルドキューに対してトリガーが送信される。

**通知内容の概要**：TimerTriggerCauseを設定してビルドをスケジュール。

**期待されるアクション**：プロジェクトのビルドが自動的に開始される。

## 通知種別

ビルドトリガー（定期実行）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（Trigger.Cronから直接呼び出し） |
| 優先度 | 高（quietPeriod=0） |
| リトライ | 無し |

### 送信先決定ロジック

1. cronスケジュール（spec）をCronTabListでパース
2. 現在時刻がスケジュールにマッチした場合にrun()が呼び出される
3. scheduleBuild(0, TimerTriggerCause)でビルドをトリガー

## 通知テンプレート

### ビルド原因メッセージ

```
Started by timer
```

### フォームバリデーションメッセージ

| 状況 | メッセージ |
|------|-----------|
| 正常 | Would last have run at {date}; would next run at {date}. |
| 空のスケジュール | No schedules so will never run |
| 稀な日付 | This schedule will match dates only rarely... |
| 構文エラー | （エラーメッセージ） |
| スペース欠落 | You appear to be missing whitespace between * and *. |

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| spec | cronスケジュール式 | 設定値 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| スケジュール | cronスケジュール実行 | 常に | 無条件でビルド実行 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| jobがnull | プロジェクトが削除されている場合 |
| スケジュールが空 | specが空の場合、実行されない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[cronスケジュール実行] --> B{job != null?}
    B -->|No| C[終了]
    B -->|Yes| D[scheduleBuild]
    D --> E[TimerTriggerCause設定]
    E --> F[ビルドキュー投入]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし

### 更新対象

| 対象 | 操作 | 概要 |
|------|------|------|
| ビルドキュー | INSERT | プロジェクトのビルドを投入 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| スケジュール構文エラー | 不正なcron式 | FormValidationでエラー表示 |
| 稀な日付警告 | 2月29日など | FormValidationで警告表示 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0 |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

cronスケジュールで指定

## セキュリティ考慮事項

- プロジェクト設定変更にはItem.CONFIGURE権限が必要
- Hashを使用してジョブ名に基づく分散を実現し、サーバー負荷を平準化

## 備考

- @Symbolで"cron"として参照可能
- Trigger<BuildableItem>を継承
- CronTabListでスケジュール式をパース
- Hashを使用した分散スケジューリングをサポート

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | TimerTrigger.java | `core/src/main/java/hudson/triggers/TimerTrigger.java` | クラス定義（53-58行目） |

**読解のコツ**: specフィールドは親クラスTriggerで定義されている。

#### Step 2: トリガー実行を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | TimerTrigger.java | `core/src/main/java/hudson/triggers/TimerTrigger.java` | run()メソッド（60-67行目） |

**主要処理フロー**:
1. **62-63行目**: jobがnullの場合は早期リターン
2. **66行目**: scheduleBuild(0, TimerTriggerCause)でビルドをトリガー

#### Step 3: フォームバリデーションを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | TimerTrigger.java | `core/src/main/java/hudson/triggers/TimerTrigger.java` | DescriptorImpl.doCheckSpec()メソッド（90-121行目） |

**主要処理フロー**:
1. **92行目**: CronTabList.create()でパース
2. **94-96行目**: updateValidationsForSanity()で警告チェック
3. **109-121行目**: updateValidationsForNextRun()で次回実行日時を表示

#### Step 4: ビルド原因を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | TimerTrigger.java | `core/src/main/java/hudson/triggers/TimerTrigger.java` | TimerTriggerCause内部クラス（125-140行目） |

**主要処理フロー**:
- **127-129行目**: getShortDescription()で"Started by timer"を返す
- **131-139行目**: equals()とhashCode()で同一性判定

### プログラム呼び出し階層図

```
Trigger.Cron (1分ごとに実行)
    │
    └─ checkTriggers()
           │
           └─ CronTabList.check()
                  │
                  └─ TimerTrigger.run()
                         │
                         └─ job.scheduleBuild(0, TimerTriggerCause)
```

### データフロー図

```
[入力]                    [処理]                        [出力]

spec (cron式) ─────▶ CronTabList.create() ──┐
                                             │
                            Trigger.Cron ────┼─▶ run()
                                             │       │
                                             │       ▼
Hash.from(job.getFullName()) ────────────────┘  scheduleBuild()
                                                     │
                                                     ▼
                                            TimerTriggerCause
                                                     │
                                                     ▼
                                            ビルドキュー投入
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| TimerTrigger.java | `core/src/main/java/hudson/triggers/TimerTrigger.java` | ソース | メイントリガー実装 |
| Trigger.java | `core/src/main/java/hudson/triggers/Trigger.java` | ソース | 基底クラス |
| CronTabList.java | `core/src/main/java/hudson/scheduler/CronTabList.java` | ソース | cron式パーサー |
| Hash.java | `core/src/main/java/hudson/scheduler/Hash.java` | ソース | 分散スケジューリング |
| TimerTriggerTest.java | `core/src/test/java/hudson/triggers/TimerTriggerTest.java` | テスト | 単体テスト |
