# 通知設計書 3-JENKINS_HOMEディスク使用量警告（HudsonHomeDiskUsageMonitor）

## 概要

本ドキュメントは、JENKINS_HOMEのディスク容量が不足している場合に管理者へ警告を表示するHudsonHomeDiskUsageMonitor（JENKINS_HOMEディスク使用量警告）の通知設計について記述する。

### 本通知の処理概要

HudsonHomeDiskUsageMonitorは、JENKINS_HOMEディレクトリのディスク空き容量を定期的に監視し、容量が不足している場合に管理者に対して警告メッセージを表示する通知機能である。

**業務上の目的・背景**：JenkinsのJENKINS_HOMEディレクトリには、設定ファイル、ビルド履歴、成果物、プラグインなど重要なデータが保存される。ディスク容量が不足すると、ビルドの失敗、設定の保存失敗、システム全体の不安定化など深刻な問題が発生する。本通知は、ディスク容量の問題が深刻化する前に管理者に警告し、早期対処を促すことを目的とする。

**通知の送信タイミング**：HudsonHomeDiskUsageCheckerが1時間ごとにディスク使用量をチェックする。チェック結果として「使用率90%以上」かつ「空き容量が閾値（デフォルト10GB）未満」の場合に、HudsonHomeDiskUsageMonitorのactivatedフラグがtrueに設定され、次回の管理画面アクセス時に警告が表示される。

**通知の受信者**：Jenkins管理画面（/manage）にアクセスできる管理者が対象となる。

**通知内容の概要**：JENKINS_HOMEディレクトリのパスとともに、ディスク容量が不足している旨のメッセージが表示される。「Tell me more」ボタンで詳細画面への誘導、「Dismiss」ボタンで警告の非表示化が可能。詳細画面では、登録されたSolution拡張ポイントによる解決策が提示される。

**期待されるアクション**：管理者は「Tell me more」をクリックして詳細画面に遷移し、提示された解決策（古いビルドの削除、成果物のクリーンアップ等）を実行するか、ディスク容量の増設を検討することが期待される。

## 通知種別

アプリ内通知（管理画面バナー表示）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（定期チェック）+ 同期（画面表示） |
| 優先度 | 高 |
| リトライ | 無（画面表示のため不要） |

### 送信先決定ロジック

Jenkins管理画面（/manage）にアクセスした管理者に対して表示される。activatedフラグがtrueの場合のみ表示。

## 通知テンプレート

### アプリ内通知の場合

| 項目 | 内容 |
|-----|------|
| 表示位置 | 管理画面上部 |
| アラートタイプ | jenkins-alert-warning（警告） |
| 形式 | HTML |

### 本文テンプレート

```html
<div class="jenkins-alert jenkins-alert-warning">
  <form method="post" action="${rootURL}/${it.url}/act" name="${it.id}">
    <f:submit name="yes" value="Tell me more"/>
    <f:submit name="no" value="Dismiss"/>
  </form>
  ${%blurb(app.rootDir)}
</div>
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| rootURL | JenkinsのルートURL | Jenkins.get().getRootUrl() | Yes |
| it.url | モニターのURL | AdministrativeMonitor.getUrl() | Yes |
| it.id | モニターのID | AdministrativeMonitor.id | Yes |
| app.rootDir | JENKINS_HOMEディレクトリパス | Jenkins.get().getRootDir() | Yes |
| blurb | 警告メッセージ本文 | Messages.properties | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| スケジュール | 1時間ごとの定期チェック | total/free > 10 AND free < FREE_SPACE_THRESHOLD | 使用率90%以上かつ空き容量が閾値未満 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| disable(true)が呼び出された場合 | 管理者が「Dismiss」をクリックした場合 |
| ディスク情報が取得できない場合 | free/totalが0以下の場合、チェック自体がキャンセルされる |
| 空き容量が十分な場合 | 条件を満たさなくなった場合、自動的にactivatedがfalseに |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[HudsonHomeDiskUsageChecker実行<br>1時間ごと] --> B{ディスク情報取得可能?}
    B -->|No| C[チェックをキャンセル]
    B -->|Yes| D{total/free > 10 AND<br>free < threshold?}
    D -->|No| E[activated = false]
    D -->|Yes| F[activated = true]
    F --> G[次回管理画面アクセス時]
    G --> H{isEnabled AND isActivated?}
    H -->|No| I[表示しない]
    H -->|Yes| J[警告バナー表示]
    J --> K{ユーザーアクション}
    K -->|Tell me more| L[詳細画面表示]
    K -->|Dismiss| M[disable true]
    L --> N[Solution一覧表示]
    M --> O[終了]
    E --> O
    C --> O
    I --> O
    N --> O
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（ファイルシステム情報を参照）

### 参照情報

| 情報 | 用途 | 備考 |
|------|------|------|
| Jenkins.getRootDir().getUsableSpace() | 空き容量取得 | Javaファイルシステム API |
| Jenkins.getRootDir().getTotalSpace() | 総容量取得 | Javaファイルシステム API |

### 更新ファイル

| ファイル | 操作 | 概要 |
|---------|------|------|
| $JENKINS_HOME/config.xml | UPDATE | disable()呼び出し時にdisabledAdministrativeMonitorsを更新 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| ディスク情報取得失敗 | getUsableSpace/getTotalSpaceが0以下を返す | チェックをキャンセルしログ出力 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（次回の定期チェックで再試行） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

該当なし（定期チェックによる制御）

### 配信時間帯

制限なし（1時間ごとに継続的にチェック）

### 閾値設定

| 項目 | デフォルト値 | 設定方法 |
|-----|------------|---------|
| FREE_SPACE_THRESHOLD | 10GB (10737418240 bytes) | システムプロパティ `hudson.diagnosis.HudsonHomeDiskUsageChecker.freeSpaceThreshold` |

## セキュリティ考慮事項

- doAct()は`@RequirePOST`で保護されている
- 管理者権限が必要

## 備考

- Symbol: `diskUsageCheck`
- パッケージ: hudson.diagnosis
- 関連クラス: HudsonHomeDiskUsageChecker（定期チェック実行）
- 拡張ポイント: HudsonHomeDiskUsageMonitor.Solution（解決策の提供）
- メッセージリソース: hudson/diagnosis/Messages.properties

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

HudsonHomeDiskUsageMonitorとHudsonHomeDiskUsageCheckerの関係を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | HudsonHomeDiskUsageMonitor.java | `core/src/main/java/hudson/diagnosis/HudsonHomeDiskUsageMonitor.java` | activatedフラグ、Solutionインナークラス |
| 1-2 | HudsonHomeDiskUsageChecker.java | `core/src/main/java/hudson/diagnosis/HudsonHomeDiskUsageChecker.java` | 定期チェックロジック |

**読解のコツ**: CheckerがMonitorのactivatedフラグを直接更新する設計に注目。

#### Step 2: 定期チェック処理を理解する

HudsonHomeDiskUsageCheckerクラスがPeriodicWorkを継承。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | HudsonHomeDiskUsageChecker.java | `core/src/main/java/hudson/diagnosis/HudsonHomeDiskUsageChecker.java` | doRun()でディスク使用量チェック |

**主要処理フロー**:
1. **44-46行目**: `getRecurrencePeriod()` - HOURを返し1時間ごとに実行
2. **49-51行目**: `doRun()` - getRootDir()から空き/総容量を取得
3. **52-57行目**: 情報取得不可の場合、チェックをキャンセル
4. **65行目**: 条件判定 `total / free > 10 && free < FREE_SPACE_THRESHOLD`
5. **74-75行目**: FREE_SPACE_THRESHOLDのデフォルト値（10GB）

#### Step 3: モニター処理を理解する

HudsonHomeDiskUsageMonitorクラスがエントリーポイント。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | HudsonHomeDiskUsageMonitor.java | `core/src/main/java/hudson/diagnosis/HudsonHomeDiskUsageMonitor.java` | isActivated()でactivatedフラグ参照、doAct()でユーザーアクション処理 |

**主要処理フロー**:
- **50行目**: activatedフラグ（package-private、Checkerから更新）
- **57-59行目**: `isActivated()` - activatedフラグを返す
- **69-77行目**: `doAct()` - yes/noパラメータで分岐
- **79-91行目**: `getSolutions()`, `getSolution()` - Solution拡張ポイント

#### Step 4: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | message.jelly | `core/src/main/resources/hudson/diagnosis/HudsonHomeDiskUsageMonitor/message.jelly` | 警告バナーUI |
| 4-2 | index.jelly | `core/src/main/resources/hudson/diagnosis/HudsonHomeDiskUsageMonitor/index.jelly` | 詳細画面、Solution一覧 |

### プログラム呼び出し階層図

```
[定期実行]
HudsonHomeDiskUsageChecker.doRun() (1時間ごと)
    │
    ├─ Jenkins.getRootDir().getUsableSpace()
    ├─ Jenkins.getRootDir().getTotalSpace()
    │
    └─ HudsonHomeDiskUsageMonitor.get().activated = true/false

[画面表示]
Jenkins.getAdministrativeMonitors()
    │
    ├─ HudsonHomeDiskUsageMonitor.isEnabled()
    │
    ├─ HudsonHomeDiskUsageMonitor.isActivated()
    │      └─ return activated
    │
    └─ HudsonHomeDiskUsageMonitor.doAct(req, rsp)
           ├─ "no" → disable(true)
           └─ "yes" → redirectToDot() → index.jelly表示
                          └─ getSolutions() → Solution.all()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ファイルシステム ───▶ HudsonHomeDiskUsageChecker ───▶ activatedフラグ更新
  │                       │                                │
  │                       └─ 1時間ごと実行                   │
  │                                                        ▼
  │                                              管理画面アクセス時
  │                                                        │
  ▼                                                        ▼
getUsableSpace()                              警告バナー表示
getTotalSpace()                                     │
                                                    ▼
                                              詳細画面（Solution一覧）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| HudsonHomeDiskUsageMonitor.java | `core/src/main/java/hudson/diagnosis/HudsonHomeDiskUsageMonitor.java` | ソース | メインモニタークラス |
| HudsonHomeDiskUsageChecker.java | `core/src/main/java/hudson/diagnosis/HudsonHomeDiskUsageChecker.java` | ソース | 定期チェッククラス |
| AdministrativeMonitor.java | `core/src/main/java/hudson/model/AdministrativeMonitor.java` | ソース | 基底クラス |
| PeriodicWork.java | `core/src/main/java/hudson/model/PeriodicWork.java` | ソース | 定期実行基底クラス |
| message.jelly | `core/src/main/resources/hudson/diagnosis/HudsonHomeDiskUsageMonitor/message.jelly` | テンプレート | 警告バナーUI |
| index.jelly | `core/src/main/resources/hudson/diagnosis/HudsonHomeDiskUsageMonitor/index.jelly` | テンプレート | 詳細画面 |
| description.jelly | `core/src/main/resources/hudson/diagnosis/HudsonHomeDiskUsageMonitor/description.jelly` | テンプレート | 説明文 |
| Messages.properties | `core/src/main/resources/hudson/diagnosis/Messages.properties` | リソース | メッセージ定義 |
| HudsonHomeDiskUsageMonitorTest.java | `test/src/test/java/hudson/diagnosis/HudsonHomeDiskUsageMonitorTest.java` | テスト | 単体テスト |
