# 通知設計書 32-リモート原因（RemoteCause）

## 概要

本ドキュメントは、Jenkins のビルド原因通知機能のうち、リモート API 経由でビルドがトリガーされた場合に記録・表示される `RemoteCause` の設計について記述する。

### 本通知の処理概要

リモート原因（RemoteCause）は、Jenkins のビルドがどのような理由で開始されたかを追跡するための `Cause` クラス階層の一部であり、リモート API（HTTP リクエスト）経由でビルドがトリガーされた場合に使用される。

**業務上の目的・背景**：CI/CD パイプラインでは、外部システム（GitHub Webhook、他のビルドシステム、スクリプトなど）から Jenkins のビルドをトリガーすることが一般的である。RemoteCause は、どのホストからビルドがトリガーされたか、およびオプションでトリガー理由のメモを記録することで、ビルドのトレーサビリティを確保する。これにより、セキュリティ監査やトラブルシューティングにおいて、外部からのビルドトリガーを追跡できる。

**通知の送信タイミング**：外部システムが Jenkins の Remote API（`/build` または `/buildWithParameters` エンドポイント）を呼び出した時点で、リクエスト元のホスト情報と（指定があれば）メモが `RemoteCause` として記録される。この情報はビルドの `CauseAction` に関連付けられ、ビルドの実行開始時にコンソールログに出力される。

**通知の受信者**：この通知は特定の受信者に送信されるものではなく、ビルド履歴画面やビルドの詳細ページを閲覧するすべてのユーザーが確認できる形で表示される。ビルドのコンソールログにも出力される。

**通知内容の概要**：通知には、ビルドをトリガーしたリモートホストのアドレス（IP アドレスまたはホスト名）が含まれる。また、API 呼び出し時に `cause` パラメータが指定されていれば、その内容もメモとして表示される。

**期待されるアクション**：受信者（ビルド履歴閲覧者）は、ビルドが外部システムからトリガーされたことを認識し、必要に応じてトリガー元システムの調査や、セキュリティ監査を行うことができる。

## 通知種別

- アプリ内通知（ビルド履歴画面、ビルド詳細ページ）
- コンソールログ出力

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（ビルド開始時に即時記録） |
| 優先度 | 中 |
| リトライ | 無（永続化された情報のため） |

### 送信先決定ロジック

送信先は決定されない。ビルド原因情報はビルドオブジェクトに関連付けられ、ビルドの詳細ページやコンソールログを閲覧する全ユーザーに表示される。

## 通知テンプレート

### コンソールログ出力の場合

| 項目 | 内容 |
|-----|------|
| 形式 | テキスト |

### 本文テンプレート

メモなしの場合：
```
Started by remote host {addr}
```

メモありの場合：
```
Started by remote host {addr} with note: {note}
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| addr | リモートホストのアドレス（IPまたはホスト名） | HTTPリクエストのリモートホスト情報 | Yes |
| note | トリガー理由のメモ | `cause` パラメータ | No |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| API | Remote API 経由のビルドトリガー | 常に記録 | `/job/{jobName}/build` または `/job/{jobName}/buildWithParameters` への POST リクエスト |
| Webhook | 外部サービスからの Webhook | 常に記録 | GitHub、GitLab などからの Webhook リクエスト |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| なし | Remote API 経由のビルドでは常に記録される |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[外部システムがRemote APIを呼び出し] --> B[RemoteCauseインスタンス生成]
    B --> C[リクエストからホスト情報を取得]
    C --> D[causeパラメータからメモを取得]
    D --> E{メモが存在?}
    E -->|Yes| F[addrとnoteを設定]
    E -->|No| G[addrのみ設定、noteはnull]
    F --> H[CauseActionにRemoteCauseを追加]
    G --> H
    H --> I[ビルドキューに投入]
    I --> J[ビルド開始時にonAddedToコールバック]
    J --> K[コンソールログにgetShortDescriptionで出力]
    K --> L[終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

Jenkinsはファイルベースの永続化を使用しており、従来のRDBMSは使用しない。

| ストレージ | 用途 | 備考 |
|-----------|------|------|
| jobs/{jobName}/builds/{buildNumber}/build.xml | ビルド情報とCauseの永続化 | XStreamでシリアライズ |

### 参照項目詳細

該当なし（外部からの入力情報のみ使用）

### 更新テーブル一覧

| ストレージ | 操作 | 概要 |
|-----------|------|------|
| jobs/{jobName}/builds/{buildNumber}/build.xml | INSERT | ビルド情報にCauseを含めて永続化 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| ホスト情報取得失敗 | HTTPリクエストからホスト情報を取得できない場合 | 空文字列または"unknown"として記録 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 制限なし | ビルドごとに1回記録されるため制限不要 |

### 配信時間帯

制限なし（ビルド実行時に即時記録）

## セキュリティ考慮事項

- リモートホストのアドレスはログに記録されるため、プライベートIPアドレスの露出に注意
- `note` パラメータの内容はユーザー入力であるため、XSS対策が必要（Jenkins 2.315以降では`getShortDescription()`の戻り値はテキストとして解釈される）
- Remote API へのアクセスは Jenkins の認証・認可設定に従う

## 備考

- Remote API を使用したビルドトリガーには、適切な認証トークン（API Token または Crumb）が必要
- `cause` パラメータは URL エンコードされた文字列として渡される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、ビルド原因を表現するデータ構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Cause.java | `core/src/main/java/hudson/model/Cause.java` | Causeクラス階層の基底クラス。getShortDescription()メソッドの役割を理解する |
| 1-2 | Cause.java (RemoteCause) | `core/src/main/java/hudson/model/Cause.java` 502-538行 | RemoteCauseの実装。addr、note、getShortDescription()の実装を確認 |

**読解のコツ**: `@Exported`アノテーションは REST API で公開されるプロパティを示す。

#### Step 2: エントリーポイントを理解する

処理の起点となるRemoteCauseのコンストラクタを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Cause.java | `core/src/main/java/hudson/model/Cause.java` 506-509行 | コンストラクタ。hostとnoteを受け取る |

**主要処理フロー**:
1. **506行**: `RemoteCause(String host, String note)`コンストラクタが呼ばれる
2. **507行**: `this.addr = host` でホストアドレスを設定
3. **508行**: `this.note = note` でメモを設定

#### Step 3: 表示ロジックを理解する

ビルド履歴画面やコンソールログへの出力方法を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Cause.java | `core/src/main/java/hudson/model/Cause.java` 511-517行 | getShortDescription()の実装 |

**主要処理フロー**:
- **512行**: noteがnullでないかチェック
- **513行**: noteがある場合は`Messages.Cause_RemoteCause_ShortDescriptionWithNote(addr, note)`
- **515行**: noteがない場合は`Messages.Cause_RemoteCause_ShortDescription(addr)`

### プログラム呼び出し階層図

```
外部システムがRemote APIを呼び出し
    │
    ├─ new RemoteCause(host, note)
    │      ├─ this.addr = host
    │      └─ this.note = note
    │
    ├─ CauseAction.addCause(cause)
    │
    └─ Build.run()
           └─ cause.onAddedTo(build)
           └─ cause.print(listener)
                  └─ getShortDescription()
                         └─ Messages.Cause_RemoteCause_*
```

### データフロー図

```
[入力]               [処理]                    [出力]

HTTP Request ───▶ RemoteCause() ───▶ addr (String)
  │                     │                 note (String)
  │                     │
  ├─ host           │
  └─ cause param ───┘
                          │
                          ▼
                    CauseAction
                          │
                          ▼
                    Build.run()
                          │
                          ▼
                    getShortDescription()
                          │
                          ▼
                    [コンソールログ]
                    [ビルド詳細ページ]
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Cause.java | `core/src/main/java/hudson/model/Cause.java` | ソース | Cause基底クラスとRemoteCauseの定義 |
| CauseAction.java | `core/src/main/java/hudson/model/CauseAction.java` | ソース | ビルドにCauseを関連付けるAction |
| Messages.properties | `core/src/main/resources/hudson/model/Messages.properties` | リソース | メッセージ定義 |
