# 通知設計書 35-ディスク容量モニター（DiskSpaceMonitor）

## 概要

本ドキュメントは、Jenkins のノードモニター機能のうち、エージェントノードのリモートファイルシステムルートのディスク空き容量を監視し、閾値以下で警告・オフライン化を行う `DiskSpaceMonitor` の設計について記述する。

### 本通知の処理概要

ディスク容量モニター（DiskSpaceMonitor）は、Jenkins のエージェントノードの健全性を監視する `NodeMonitor` の一種であり、各ノードのリモートファイルシステムルート（ワークスペースが配置されるディレクトリ）のディスク空き容量を定期的にチェックする。

**業務上の目的・背景**：CI/CD パイプラインでは、ビルドアーティファクト、チェックアウトしたソースコード、依存関係のキャッシュなどがディスク容量を消費する。ディスク容量が不足すると、ビルドが失敗したり、システムが不安定になる可能性がある。DiskSpaceMonitor は、ディスク容量が閾値を下回った場合にノードを自動的にオフラインにし、ビルドの失敗を防止するとともに、管理者に警告を表示して対処を促す。

**通知の送信タイミング**：NodeMonitor は定期的（デフォルト60分間隔）に全てのエージェントノードを監視する。各監視サイクルでノードのディスク空き容量が取得され、閾値（デフォルト1GiB）以下の場合にノードがオフラインにマークされ、管理画面に警告が表示される。警告閾値（デフォルト2GiB）以下の場合は、オフラインにはならないが警告が表示される。

**通知の受信者**：管理者およびノード一覧ページを閲覧するユーザーに対して、ノード一覧画面のディスク容量カラムに情報が表示される。ノードがオフラインになった場合、`MonitorMarkedNodeOffline` 管理モニターが有効化され、管理画面にも通知される。

**通知内容の概要**：ディスクの空き容量、パス、総容量が表示される。閾値以下の場合は赤色でハイライトされ、ノードのオフライン理由として詳細なメッセージが設定される。

**期待されるアクション**：管理者は、ディスク容量が不足しているノードを特定し、不要なファイルの削除、ディスクの増設、ワークスペースのクリーンアップなどの対処を行う。対処後、ノードを手動でオンラインに戻すか、次の監視サイクルで閾値を超えていれば自動的にオンラインに戻る。

## 通知種別

- アプリ内通知（ノード一覧画面、管理画面）
- ノードのオフラインマーク

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（定期ポーリング） |
| 優先度 | 高（ノードの可用性に影響） |
| リトライ | 有（次の監視サイクルで再試行） |

### 送信先決定ロジック

全ての管理者および `Jenkins.ADMINISTER` 権限を持つユーザーが警告を確認できる。一般ユーザーにはディスク容量カラムが非表示となる。

## 通知テンプレート

### ノード一覧画面の場合

| 項目 | 内容 |
|-----|------|
| 形式 | HTML（カラム表示） |

### 本文テンプレート

正常時：
```
{size} of {path} ({totalSize})
```

警告時（閾値以下）：
```
Disk space is too low. Only {size} left on {path}. Threshold is {threshold}. Total is {totalSize}
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| size | ディスク空き容量 | `File.getUsableSpace()` | Yes |
| path | 監視対象パス | `File.getCanonicalPath()` | Yes |
| totalSize | ディスク総容量 | `File.getTotalSpace()` | Yes |
| threshold | オフライン閾値 | 設定値（デフォルト1GiB） | Yes |
| warningThreshold | 警告閾値 | 設定値（デフォルト2GiB） | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| スケジュール | 定期監視（デフォルト60分間隔） | 常に実行 | AbstractNodeMonitorDescriptor による定期実行 |
| 手動 | triggerUpdate()呼び出し | 任意のタイミング | 管理画面からの手動更新 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| isIgnored() == true | モニターが無視設定の場合、オフライン化しない |
| ノードがnull | ノードが存在しない場合はスキップ |
| rootPathがnull | リモートファイルシステムルートが取得できない場合はスキップ |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[定期監視タイマー発火] --> B[monitor実行]
    B --> C[全ノードに対してcreateCallable実行]
    C --> D[GetUsableSpaceをノードで実行]
    D --> E[DiskSpace取得]
    E --> F{size <= threshold?}
    F -->|Yes| G[DiskSpaceにtrigger設定]
    G --> H{isIgnored?}
    H -->|No| I[markOffline実行]
    H -->|Yes| J[オフライン化スキップ]
    I --> K[MonitorMarkedNodeOffline.active = true]
    F -->|No| L{size > threshold?}
    L -->|Yes| M{オフライン原因がDiskSpace?}
    M -->|Yes| N[markOnline実行]
    M -->|No| O[処理継続]
    J --> P[監視データ更新]
    K --> P
    N --> P
    O --> P
    L -->|No| P
    P --> Q[終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

Jenkinsはファイルベースの永続化を使用しており、従来のRDBMSは使用しない。

| ストレージ | 用途 | 備考 |
|-----------|------|------|
| nodeMonitors.xml | NodeMonitor設定の永続化 | 閾値設定を含む |
| nodes/{nodeName}/config.xml | ノード設定 | DiskSpaceMonitorNodePropertyを含む場合あり |

### 参照項目詳細

#### DiskSpaceMonitorNodeProperty

| 参照項目 | 用途 | 取得条件 |
|-------------------|------|---------|
| freeDiskSpaceThreshold | ノード固有の閾値 | ノードプロパティから取得 |
| freeDiskSpaceWarningThreshold | ノード固有の警告閾値 | ノードプロパティから取得 |

### 更新テーブル一覧

| ストレージ | 操作 | 概要 |
|-----------|------|------|
| なし | - | モニターデータはメモリ上のみで管理 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| ノード未接続 | ノードのチャネルがnull | nullを返し、次のサイクルで再試行 |
| ディスク情報取得失敗 | File.getUsableSpace()が0以下を返す | nullを返す |
| 閾値解析エラー | DiskSpace.parse()でParseException | デフォルト閾値（1GiB）を使用 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 無制限（次の監視サイクルで自動再試行） |
| リトライ間隔 | 監視間隔（デフォルト60分） |
| リトライ対象エラー | 全てのエラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 監視間隔 | デフォルト60分（システムプロパティで変更可能） |
| 監視タイムアウト | 30秒 |

### 配信時間帯

制限なし（常時監視）

## セキュリティ考慮事項

- ディスク容量カラムは `Jenkins.ADMINISTER` 権限を持つユーザーにのみ表示される
- パス情報には機密情報が含まれる可能性があるため、アクセス制御に注意

## 備考

- `DiskSpaceMonitor` は `@Symbol("diskSpace")` アノテーションを持ち、JCasC で `diskSpace` として設定可能
- ノード固有の閾値は `DiskSpaceMonitorNodeProperty` で設定可能
- Jenkins 1.123 から存在する古いモニター
- 閾値は "1GB", "500MB", "1GiB" などの人間が読める形式で指定可能

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、ディスク容量情報を表現するデータ構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | DiskSpaceMonitorDescriptor.java | `core/src/main/java/hudson/node_monitors/DiskSpaceMonitorDescriptor.java` 106-281行 | DiskSpaceクラスの定義。size、path、totalSize、threshold、warningThreshold を持つ |
| 1-2 | DiskSpaceMonitorDescriptor.java | `core/src/main/java/hudson/node_monitors/DiskSpaceMonitorDescriptor.java` 252-278行 | DiskSpace.parse()メソッド。人間が読める形式を解析 |

**読解のコツ**: `DiskSpace` は `MonitorOfflineCause` を継承しており、ノードのオフライン理由として使用される。

#### Step 2: モニター本体を理解する

DiskSpaceMonitor の実装を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | DiskSpaceMonitor.java | `core/src/main/java/hudson/node_monitors/DiskSpaceMonitor.java` 47-125行 | DiskSpaceMonitorの実装 |
| 2-2 | AbstractDiskSpaceMonitor.java | `core/src/main/java/hudson/node_monitors/AbstractDiskSpaceMonitor.java` | 共通の閾値処理ロジック |

**主要処理フロー**:
1. **56-69行**: `getThresholdBytes(Computer c)` でノード固有または全体の閾値を取得
2. **72-85行**: `getWarningThresholdBytes(Computer c)` で警告閾値を取得
3. **87-89行**: `getFreeSpace(Computer c)` で監視データを取得

#### Step 3: 監視実行フローを理解する

監視がどのように実行されるかを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | DiskSpaceMonitorDescriptor.java | `core/src/main/java/hudson/node_monitors/DiskSpaceMonitorDescriptor.java` 57-100行 | monitor()メソッドのオーバーライド |
| 3-2 | DiskSpaceMonitorDescriptor.java | `core/src/main/java/hudson/node_monitors/DiskSpaceMonitorDescriptor.java` 78-100行 | markNodeOfflineOrOnline()メソッド |
| 3-3 | AbstractNodeMonitorDescriptor.java | `core/src/main/java/hudson/node_monitors/AbstractNodeMonitorDescriptor.java` | 基底クラスの監視ロジック |

**主要処理フロー**:
- **78-100行**: 閾値との比較、オフライン/オンライン処理

### プログラム呼び出し階層図

```
Timer（定期実行）
    │
    └─ AbstractNodeMonitorDescriptor.triggerUpdate()
           │
           └─ Record.run()
                  │
                  └─ monitor()
                         │
                         ├─ monitorDetailed()
                         │      └─ createCallable(c)
                         │             └─ GetUsableSpace
                         │                    └─ File.getUsableSpace()
                         │
                         └─ markNodeOfflineOrOnline(c, d, monitor)
                                ├─ size.setThreshold(threshold)
                                ├─ [size <= threshold]
                                │      └─ markOffline(c, size)
                                │             └─ MonitorMarkedNodeOffline.active = true
                                │
                                └─ [size > threshold && isOffline]
                                       └─ markOnline(c)
```

### データフロー図

```
[入力]               [処理]                    [出力]

Node.getRootPath() ───▶ GetUsableSpace ───▶ DiskSpace
                              │                  │
                              ▼                  ├─ size
                        File.getUsableSpace()   ├─ path
                        File.getTotalSpace()    └─ totalSize
                              │
                              ▼
                        monitor()
                              │
                              ▼
                        markNodeOfflineOrOnline()
                              │
                              ├─ [閾値以下]
                              │      └─ markOffline()
                              │             └─ setTemporaryOfflineCause()
                              │
                              └─ [閾値超過]
                                     └─ markOnline()
                                            └─ setTemporaryOfflineCause(null)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| DiskSpaceMonitor.java | `core/src/main/java/hudson/node_monitors/DiskSpaceMonitor.java` | ソース | DiskSpaceMonitorの実装 |
| DiskSpaceMonitorDescriptor.java | `core/src/main/java/hudson/node_monitors/DiskSpaceMonitorDescriptor.java` | ソース | Descriptor実装とDiskSpaceクラス |
| AbstractDiskSpaceMonitor.java | `core/src/main/java/hudson/node_monitors/AbstractDiskSpaceMonitor.java` | ソース | 共通の閾値処理 |
| DiskSpaceMonitorNodeProperty.java | `core/src/main/java/hudson/node_monitors/DiskSpaceMonitorNodeProperty.java` | ソース | ノード固有の閾値設定 |
| NodeMonitor.java | `core/src/main/java/hudson/node_monitors/NodeMonitor.java` | ソース | 基底クラス |
| AbstractNodeMonitorDescriptor.java | `core/src/main/java/hudson/node_monitors/AbstractNodeMonitorDescriptor.java` | ソース | 監視実行ロジック |
| MonitorMarkedNodeOffline.java | `core/src/main/java/hudson/node_monitors/MonitorMarkedNodeOffline.java` | ソース | オフライン通知の管理モニター |
| Messages.properties | `core/src/main/resources/hudson/node_monitors/Messages.properties` | リソース | メッセージ定義 |
