# 通知設計書 36-一時領域モニター（TemporarySpaceMonitor）

## 概要

本ドキュメントは、Jenkins のノードモニター機能のうち、エージェントノードの一時ディレクトリ（/tmp など）のディスク空き容量を監視し、閾値以下で警告・オフライン化を行う `TemporarySpaceMonitor` の設計について記述する。

### 本通知の処理概要

一時領域モニター（TemporarySpaceMonitor）は、Jenkins のエージェントノードの健全性を監視する `NodeMonitor` の一種であり、各ノードの一時ディレクトリ（`java.io.tmpdir` システムプロパティで指定されるディレクトリ）のディスク空き容量を定期的にチェックする。

**業務上の目的・背景**：ビルドプロセスでは、コンパイル、テスト実行、アーティファクト生成などの過程で一時ファイルが大量に作成されることがある。一時ディレクトリの容量が不足すると、ビルドが予期せず失敗する可能性がある。TemporarySpaceMonitor は、一時ディレクトリの容量が閾値を下回った場合にノードを自動的にオフラインにし、ビルドの失敗を防止するとともに、管理者に警告を表示して対処を促す。

**通知の送信タイミング**：NodeMonitor は定期的（デフォルト60分間隔）に全てのエージェントノードを監視する。各監視サイクルでノードの一時ディレクトリの空き容量が取得され、閾値（デフォルト1GiB）以下の場合にノードがオフラインにマークされ、管理画面に警告が表示される。

**通知の受信者**：管理者およびノード一覧ページを閲覧するユーザーに対して、ノード一覧画面の一時領域カラムに情報が表示される。ノードがオフラインになった場合、`MonitorMarkedNodeOffline` 管理モニターが有効化され、管理画面にも通知される。

**通知内容の概要**：一時ディレクトリの空き容量、パス、総容量が表示される。閾値以下の場合は赤色でハイライトされ、ノードのオフライン理由として詳細なメッセージが設定される。

**期待されるアクション**：管理者は、一時領域が不足しているノードを特定し、一時ファイルの削除、ディスクの増設、一時ディレクトリの変更などの対処を行う。

## 通知種別

- アプリ内通知（ノード一覧画面、管理画面）
- ノードのオフラインマーク

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（定期ポーリング） |
| 優先度 | 高（ノードの可用性に影響） |
| リトライ | 有（次の監視サイクルで再試行） |

### 送信先決定ロジック

全ての管理者および `Jenkins.ADMINISTER` 権限を持つユーザーが警告を確認できる。一般ユーザーには一時領域カラムが非表示となる。

## 通知テンプレート

### ノード一覧画面の場合

| 項目 | 内容 |
|-----|------|
| 形式 | HTML（カラム表示） |

### 本文テンプレート

DiskSpaceMonitor と同様の形式を使用（DiskSpace クラスを共有）

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| size | 一時ディレクトリの空き容量 | `File.getUsableSpace()` | Yes |
| path | 一時ディレクトリのパス | `System.getProperty("java.io.tmpdir")` | Yes |
| totalSize | ディスク総容量 | `File.getTotalSpace()` | Yes |
| threshold | オフライン閾値 | 設定値（デフォルト1GiB） | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| スケジュール | 定期監視（デフォルト60分間隔） | 常に実行 | AbstractNodeMonitorDescriptor による定期実行 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| isIgnored() == true | モニターが無視設定の場合、オフライン化しない |
| ノードがnull | ノードが存在しない場合はスキップ |
| rootPathがnull | リモートファイルシステムルートが取得できない場合はスキップ |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[定期監視タイマー発火] --> B[monitor実行]
    B --> C[全ノードに対してcreateCallable実行]
    C --> D[GetTempSpaceをノードで実行]
    D --> E[java.io.tmpdirを取得]
    E --> F[DiskSpace取得]
    F --> G{size <= threshold?}
    G -->|Yes| H[markOffline実行]
    G -->|No| I[通常表示]
    H --> J[MonitorMarkedNodeOffline.active = true]
    I --> K[監視データ更新]
    J --> K
    K --> L[終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| ストレージ | 用途 | 備考 |
|-----------|------|------|
| nodeMonitors.xml | NodeMonitor設定の永続化 | 閾値設定を含む |
| nodes/{nodeName}/config.xml | ノード設定 | DiskSpaceMonitorNodePropertyを含む場合あり |

### 参照項目詳細

#### DiskSpaceMonitorNodeProperty

| 参照項目 | 用途 | 取得条件 |
|-------------------|------|---------|
| freeTempSpaceThreshold | ノード固有の一時領域閾値 | ノードプロパティから取得 |
| freeTempSpaceWarningThreshold | ノード固有の一時領域警告閾値 | ノードプロパティから取得 |

### 更新テーブル一覧

該当なし（モニターデータはメモリ上のみで管理）

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| ノード未接続 | ノードのチャネルがnull | nullを返し、次のサイクルで再試行 |
| ディスク情報取得失敗 | File.getUsableSpace()が0以下を返す | nullを返す |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 無制限（次の監視サイクルで自動再試行） |
| リトライ間隔 | 監視間隔（デフォルト60分） |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 監視間隔 | デフォルト60分 |

### 配信時間帯

制限なし（常時監視）

## セキュリティ考慮事項

- 一時領域カラムは `Jenkins.ADMINISTER` 権限を持つユーザーにのみ表示される
- パス情報には機密情報が含まれる可能性があるため、アクセス制御に注意

## 備考

- `TemporarySpaceMonitor` は `@Symbol("tmpSpace")` アノテーションを持ち、JCasC で `tmpSpace` として設定可能
- 一時ディレクトリは `System.getProperty("java.io.tmpdir")` で取得される
- ノード固有の閾値は `DiskSpaceMonitorNodeProperty` の `freeTempSpaceThreshold` で設定可能

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

DiskSpaceMonitor と同様の DiskSpace クラスを使用する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | DiskSpaceMonitorDescriptor.java | `core/src/main/java/hudson/node_monitors/DiskSpaceMonitorDescriptor.java` 106-281行 | DiskSpaceクラス（TemporarySpaceMonitorでも使用） |

#### Step 2: モニター本体を理解する

TemporarySpaceMonitor の実装を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | TemporarySpaceMonitor.java | `core/src/main/java/hudson/node_monitors/TemporarySpaceMonitor.java` 51-151行 | TemporarySpaceMonitorの実装 |
| 2-2 | TemporarySpaceMonitor.java | `core/src/main/java/hudson/node_monitors/TemporarySpaceMonitor.java` 136-150行 | GetTempSpaceクラス |

**主要処理フロー**:
1. **60-73行**: `getThresholdBytes(Computer c)` でノード固有または全体の閾値を取得
2. **136-150行**: `GetTempSpace.invoke()` で一時ディレクトリの空き容量を取得

#### Step 3: 一時ディレクトリ取得ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | TemporarySpaceMonitor.java | `core/src/main/java/hudson/node_monitors/TemporarySpaceMonitor.java` 137-147行 | GetTempSpace.invoke()の実装 |

**主要処理フロー**:
- **141行**: `System.getProperty("java.io.tmpdir")` で一時ディレクトリを取得
- **142行**: `f.getUsableSpace()` で空き容量を取得
- **144-145行**: DiskSpace オブジェクトを生成し、totalSize を設定

### プログラム呼び出し階層図

```
Timer（定期実行）
    │
    └─ AbstractNodeMonitorDescriptor.triggerUpdate()
           │
           └─ monitor()
                  │
                  └─ createCallable(c)
                         │
                         └─ GetTempSpace
                                │
                                ├─ System.getProperty("java.io.tmpdir")
                                ├─ File.getUsableSpace()
                                └─ File.getTotalSpace()
                                       │
                                       ▼
                                 DiskSpace
```

### データフロー図

```
[入力]               [処理]                    [出力]

java.io.tmpdir ───▶ GetTempSpace ───▶ DiskSpace
                         │                  │
                         ▼                  ├─ size
                   File(tmpdir)            ├─ path
                         │                  └─ totalSize
                         ├─ getUsableSpace()
                         └─ getTotalSpace()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| TemporarySpaceMonitor.java | `core/src/main/java/hudson/node_monitors/TemporarySpaceMonitor.java` | ソース | TemporarySpaceMonitorの実装 |
| DiskSpaceMonitorDescriptor.java | `core/src/main/java/hudson/node_monitors/DiskSpaceMonitorDescriptor.java` | ソース | DiskSpaceクラス定義（共有） |
| AbstractDiskSpaceMonitor.java | `core/src/main/java/hudson/node_monitors/AbstractDiskSpaceMonitor.java` | ソース | 共通の閾値処理 |
| DiskSpaceMonitorNodeProperty.java | `core/src/main/java/hudson/node_monitors/DiskSpaceMonitorNodeProperty.java` | ソース | ノード固有の閾値設定 |
| Messages.properties | `core/src/main/resources/hudson/node_monitors/Messages.properties` | リソース | メッセージ定義 |
