# 通知設計書 40-アーキテクチャモニター（ArchitectureMonitor）

## 概要

本ドキュメントは、Jenkins のノードモニター機能のうち、エージェントノードのシステムアーキテクチャ情報（OS 名とアーキテクチャ）を取得し表示する `ArchitectureMonitor` の設計について記述する。

### 本通知の処理概要

アーキテクチャモニター（ArchitectureMonitor）は、Jenkins のエージェントノードの情報を収集する `NodeMonitor` の一種であり、各ノードの OS 名とシステムアーキテクチャを取得し、ノード一覧画面に表示する。

**業務上の目的・背景**：分散ビルド環境では、異なる OS やアーキテクチャを持つ複数のエージェントが存在することが一般的である。管理者やユーザーが各ノードのシステム情報を一覧で確認できることで、特定のビルドを実行するのに適したノードの選択、プラットフォーム固有の問題のトラブルシューティング、ビルド環境のドキュメント化などが容易になる。

**通知の送信タイミング**：NodeMonitor は定期的（デフォルト60分間隔）に全てのエージェントノードを監視する。各監視サイクルでノードの OS 名とアーキテクチャ情報が取得され、ノード一覧画面に表示される。

**通知の受信者**：全てのユーザーがノード一覧画面でアーキテクチャ情報を確認できる。このモニターは情報表示のみを目的としており、ノードをオフラインにする機能を持たない（`canTakeOffline()` が false を返す）。

**通知内容の概要**：OS 名とアーキテクチャが「OS名 (アーキテクチャ)」の形式で表示される。例：「Linux (amd64)」、「Windows 10 (amd64)」、「Mac OS X (aarch64)」など。

**期待されるアクション**：管理者やユーザーは、ノードのシステム情報を参照して、適切なビルド環境の選択やトラブルシューティングに活用する。

## 通知種別

- アプリ内通知（ノード一覧画面）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（定期ポーリング） |
| 優先度 | 低（参考情報のみ） |
| リトライ | 有（次の監視サイクルで再試行） |

### 送信先決定ロジック

全てのユーザーがノード一覧画面でアーキテクチャ情報を確認できる。

## 通知テンプレート

### ノード一覧画面の場合

| 項目 | 内容 |
|-----|------|
| 形式 | テキスト（カラム表示） |

### 本文テンプレート

```
{os.name} ({os.arch})
```

例：
- `Linux (amd64)`
- `Windows 10 (amd64)`
- `Mac OS X (aarch64)`

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| os.name | OS 名 | `System.getProperty("os.name")` | Yes |
| os.arch | アーキテクチャ | `System.getProperty("os.arch")` | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| スケジュール | 定期監視（デフォルト60分間隔） | 常に実行 | AbstractNodeMonitorDescriptor による定期実行 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| なし | 常に情報を取得して表示 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[定期監視タイマー発火] --> B[monitor実行]
    B --> C[全ノードに対してcreateCallable実行]
    C --> D[GetArchTaskをノードで実行]
    D --> E[System.getProperty os.name 取得]
    E --> F[System.getProperty os.arch 取得]
    F --> G[文字列を結合して返す]
    G --> H[監視データ更新]
    H --> I[終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| ストレージ | 用途 | 備考 |
|-----------|------|------|
| nodeMonitors.xml | NodeMonitor設定の永続化 | |

### 参照項目詳細

該当なし（システムプロパティによる取得）

### 更新テーブル一覧

該当なし（モニターデータはメモリ上のみで管理）

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| ノード未接続 | ノードとの通信が確立できない場合 | nullを返し、次のサイクルで再試行 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 無制限（次の監視サイクルで自動再試行） |
| リトライ間隔 | 監視間隔（デフォルト60分） |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 監視間隔 | デフォルト60分 |

### 配信時間帯

制限なし（常時監視）

## セキュリティ考慮事項

- OS 名とアーキテクチャ情報は一般的なシステム情報であり、特に機密性は低い
- ただし、詳細なシステム情報が攻撃者に有用な情報となる可能性があるため、Jenkins のアクセス制御を適切に設定する

## 備考

- `ArchitectureMonitor` は `@Symbol("architecture")` アノテーションを持ち、JCasC で `architecture` として設定可能
- このモニターは `canTakeOffline()` が false を返すため、ノードを自動的にオフラインにしない
- 非常にシンプルなモニターであり、システムプロパティを取得するのみ

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: モニター本体を理解する

ArchitectureMonitor は非常にシンプルなモニターであり、主要なロジックは1つのファイルに集約されている。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ArchitectureMonitor.java | `core/src/main/java/hudson/node_monitors/ArchitectureMonitor.java` 41-79行 | ArchitectureMonitorの全実装 |

**読解のコツ**: このモニターは非常にシンプルで、`GetArchTask` という内部クラスでシステムプロパティを取得するだけ。

#### Step 2: タスク実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ArchitectureMonitor.java | `core/src/main/java/hudson/node_monitors/ArchitectureMonitor.java` 66-78行 | GetArchTaskクラス |

**主要処理フロー**:
1. **71行**: `System.getProperty("os.name")` で OS 名を取得
2. **72行**: `System.getProperty("os.arch")` でアーキテクチャを取得
3. **73行**: `os + " (" + arch + ')'` の形式で文字列を結合して返す

#### Step 3: Descriptor を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ArchitectureMonitor.java | `core/src/main/java/hudson/node_monitors/ArchitectureMonitor.java` 47-64行 | DescriptorImpl |

**主要処理フロー**:
- **49-51行**: `createCallable()` で `GetArchTask` を返す
- **54-56行**: `getDisplayName()` でメッセージから表示名を取得
- **59-61行**: `canTakeOffline()` で false を返す（オフライン化しない）

### プログラム呼び出し階層図

```
Timer（定期実行）
    │
    └─ AbstractNodeMonitorDescriptor.triggerUpdate()
           │
           └─ monitor()
                  │
                  └─ createCallable(c)
                         │
                         └─ GetArchTask
                                │
                                └─ call()
                                       │
                                       ├─ System.getProperty("os.name")
                                       ├─ System.getProperty("os.arch")
                                       │
                                       └─ os + " (" + arch + ')'
```

### データフロー図

```
[入力]               [処理]                    [出力]

                  GetArchTask.call()
                         │
System.getProperty() ────┼─▶ os.name
                         │
System.getProperty() ────┼─▶ os.arch
                         │
                         ▼
              os + " (" + arch + ')'
                         │
                         ▼
              [ノード一覧画面]
              "Linux (amd64)"
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ArchitectureMonitor.java | `core/src/main/java/hudson/node_monitors/ArchitectureMonitor.java` | ソース | ArchitectureMonitorの実装 |
| NodeMonitor.java | `core/src/main/java/hudson/node_monitors/NodeMonitor.java` | ソース | 基底クラス |
| AbstractAsyncNodeMonitorDescriptor.java | `core/src/main/java/hudson/node_monitors/AbstractAsyncNodeMonitorDescriptor.java` | ソース | 非同期監視の基底Descriptor |
| MasterToSlaveCallable.java | `core/src/main/java/jenkins/security/MasterToSlaveCallable.java` | ソース | コントローラーからエージェントへの呼び出し |
| Messages.properties | `core/src/main/resources/hudson/node_monitors/Messages.properties` | リソース | メッセージ定義 |
