# 通知設計書 7-Jenkinsコア更新通知（CoreUpdateMonitor）

## 概要

本ドキュメントは、Jenkins本体の更新が利用可能な場合に管理者へ通知を表示するCoreUpdateMonitor（Jenkinsコア更新通知）の通知設計について記述する。

### 本通知の処理概要

CoreUpdateMonitorは、UpdateCenterの情報を参照し、Jenkins本体（コア）の新しいバージョンが利用可能な場合に管理者に対して更新を促す通知メッセージを表示する通知機能である。

**業務上の目的・背景**：Jenkinsは継続的に新機能の追加、バグ修正、セキュリティ修正がリリースされる。特にセキュリティ修正は迅速な適用が重要である。本通知は、管理者がJenkinsの新バージョンを認識し、計画的なアップグレードを実施できるよう情報を提供することを目的とする。

**通知の送信タイミング**：UpdateCenterがupdate-center.jsonを取得・パースした後、サイトデータが準備完了（isSiteDataReady()がtrue）になった時点で、hasCoreUpdates()がtrueを返す場合に通知が有効化される。管理画面アクセス時に表示される。

**通知の受信者**：Jenkins.SYSTEM_READ権限を持つユーザーが対象となる。getRequiredPermission()でSYSTEM_READを返すため、管理者以外でもシステム読み取り権限があれば通知を確認できる。

**通知内容の概要**：新しいバージョン番号、ダウンロードリンク、変更履歴へのリンクが表示される。アップグレードの状態（進行中、完了、失敗）に応じて異なるメッセージが表示される。管理者は「Or Upgrade Automatically」ボタンで自動アップグレードを開始できる。

**期待されるアクション**：管理者は変更履歴を確認した上で、手動でダウンロードしてアップグレードするか、「Or Upgrade Automatically」で自動アップグレードを実行することが期待される。アップグレード完了後は、Jenkinsの再起動が必要。

## 通知種別

アプリ内通知（管理画面バナー表示）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（画面レンダリング時） |
| 優先度 | 中 |
| リトライ | 無（画面表示のため不要） |

### 送信先決定ロジック

Jenkins.SYSTEM_READ権限を持つユーザーに対して表示される。サイトデータが準備完了かつコアアップデートが存在する場合に有効化。

## 通知テンプレート

### アプリ内通知の場合

| 項目 | 内容 |
|-----|------|
| 表示位置 | 管理画面上部 |
| アラートタイプ | jenkins-alert-info（情報） |
| 形式 | HTML |

### 本文テンプレート

```html
<div class="jenkins-alert jenkins-alert-info">
  <!-- 状態に応じた表示分岐 -->
  <j:choose>
    <!-- アップグレード成功時 -->
    <j:when test="${upJob.status.success}">
      <!-- 再起動可能な場合 -->
      <j:when test="${lifecycle.canRestart()}">
        ${%UpgradeComplete(ucData.core.version,rootURL)}
      </j:when>
      <!-- 再起動不可の場合 -->
      <j:otherwise>
        ${%UpgradeCompleteRestartNotSupported(ucData.core.version)}
      </j:otherwise>
    </j:when>

    <!-- アップグレード失敗時 -->
    <j:when test="${upJob!=null and upJob.error != null}">
      ${%UpgradeFailed(ucData.core.version,upJob.errorMessage,rootURL+'/updateCenter/')}
      <j:if test="${ucData.canUpgrade()}">
        <form method="post" action="${rootURL}/updateCenter/upgrade">
          <f:submit value="Retry"/>
        </form>
      </j:if>
    </j:when>

    <!-- アップグレード進行中 -->
    <j:when test="${upJob!=null}">
      ${%UpgradeProgress(ucData.core.version,rootURL+'/updateCenter/')}
    </j:when>

    <!-- 新バージョン利用可能（デフォルト） -->
    <j:otherwise>
      ${%NewVersionAvailable(ucData.core.version,ucData.core.url,changelog_url)}
      <l:isAdmin>
        <j:if test="${ucData.canUpgrade()}">
          <form method="post" action="${rootURL}/updateCenter/upgrade">
            <f:submit value="Or Upgrade Automatically"/>
          </form>
        </j:if>
      </l:isAdmin>
    </j:otherwise>
  </j:choose>
</div>
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| ucData | 更新サイトデータ | UpdateSite.getData() | Yes |
| ucData.core.version | 新バージョン番号 | UpdateSite.Data.core.version | Yes |
| ucData.core.url | ダウンロードURL | UpdateSite.Data.core.url | Yes |
| changelog_url | 変更履歴URL | Jenkins.CHANGELOG_URL | Yes |
| upJob | アップグレードジョブ | UpdateCenter.getHudsonJob() | No |
| lifecycle.canRestart() | 再起動可能か | Lifecycle.get().canRestart() | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | 管理画面アクセス | isSiteDataReady() && hasCoreUpdates() | サイトデータ準備完了かつコア更新あり |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| !isSiteDataReady() | サイトデータが未準備の場合 |
| !hasCoreUpdates() | コア更新が存在しない場合 |
| getCoreSource() == null | コアソースが見つからない場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[管理画面アクセス] --> B{isSiteDataReady?}
    B -->|No| C[表示しない]
    B -->|Yes| D{getCoreSource != null?}
    D -->|No| C
    D -->|Yes| E{hasCoreUpdates?}
    E -->|No| C
    E -->|Yes| F[通知バナー表示]
    F --> G{upJobの状態}
    G -->|null| H[NewVersionAvailable表示]
    G -->|実行中| I[UpgradeProgress表示]
    G -->|成功| J[UpgradeComplete表示]
    G -->|失敗| K[UpgradeFailed表示]
    H --> L{管理者?}
    L -->|Yes| M[Upgrade Automaticallyボタン表示]
    L -->|No| N[ボタン非表示]
    K --> O{canUpgrade?}
    O -->|Yes| P[Retryボタン表示]
    O -->|No| Q[ボタン非表示]
    J --> R{canRestart?}
    R -->|Yes| S[再起動リンク表示]
    R -->|No| T[手動再起動促す]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（ファイル/メモリ上のデータを参照）

### 参照データ構造

| データ構造 | 用途 | 備考 |
|-----------|------|------|
| UpdateSite.Data | 更新サイトデータ | update-center.jsonのパース結果 |
| UpdateCenter.hudsonJob | コアアップグレードジョブ | アップグレード状態の追跡 |

### 更新ファイル

| ファイル | 操作 | 概要 |
|---------|------|------|
| $JENKINS_HOME/war/jenkins.war | UPDATE | 自動アップグレード時に新バージョンをダウンロード |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| アップグレード失敗 | ダウンロード/展開エラー | エラーメッセージ表示、Retryボタン提供 |
| サイトデータ未準備 | ネットワーク問題等 | 通知を表示しない |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 手動（Retryボタンによる再試行） |
| リトライ間隔 | ユーザー操作依存 |
| リトライ対象エラー | アップグレード失敗 |

## 配信設定

### レート制限

該当なし（画面表示のため）

### 配信時間帯

制限なし（常時有効）

## セキュリティ考慮事項

- getRequiredPermission()でJenkins.SYSTEM_READを返し、読み取り専用アクセスを許可
- 自動アップグレードボタンは`<l:isAdmin>`で管理者のみに表示
- アップグレードアクションはUpdateCenter経由で権限チェック

## 備考

- Symbol: `coreUpdate`
- パッケージ: hudson.model.UpdateCenter（インナークラス）
- 関連クラス: UpdateSite, UpdateCenter, Lifecycle
- メッセージリソース: hudson/model/Messages.properties

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

UpdateCenterとUpdateSiteの関係を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | UpdateCenter.java | `core/src/main/java/hudson/model/UpdateCenter.java` | CoreUpdateMonitorインナークラス、UpdateSiteとの連携 |
| 1-2 | UpdateSite.java | `core/src/main/java/hudson/model/UpdateSite.java` | Data構造、hasCoreUpdates() |

**読解のコツ**: UpdateCenterが複数のUpdateSiteを管理し、getCoreSource()で更新情報を取得する点に注目。

#### Step 2: 有効化判定を理解する

CoreUpdateMonitorのisActivated()。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | UpdateCenter.java | `core/src/main/java/hudson/model/UpdateCenter.java` | isActivated()の実装（1197-1204行目付近） |

**主要処理フロー**:
1. **1197-1201行目**: `isActivated()` - isSiteDataReady()チェック
2. **1202-1203行目**: getData()とhasCoreUpdates()チェック
3. **1206-1210行目**: `getData()` - getCoreSource()からデータ取得

#### Step 3: ビューテンプレートを理解する

message.jellyの条件分岐。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | message.jelly | `core/src/main/resources/hudson/model/UpdateCenter/CoreUpdateMonitor/message.jelly` | 状態に応じた表示分岐 |

**主要処理フロー**:
- **28-29行目**: ucData, upJob変数設定
- **31-40行目**: アップグレード成功時の処理
- **42-49行目**: アップグレード失敗時の処理
- **50-52行目**: アップグレード進行中の処理
- **53-62行目**: 新バージョン利用可能時の処理

### プログラム呼び出し階層図

```
Jenkins.getAdministrativeMonitors()
    │
    ├─ CoreUpdateMonitor.isActivated()
    │      │
    │      ├─ UpdateCenter.isSiteDataReady()
    │      │
    │      └─ CoreUpdateMonitor.getData()
    │             │
    │             ├─ UpdateCenter.getCoreSource()
    │             │      └─ UpdateSite選択
    │             │
    │             └─ UpdateSite.getData()
    │                    └─ hasCoreUpdates()
    │
    └─ message.jelly表示
           │
           ├─ ucData.core (新バージョン情報)
           │
           ├─ app.updateCenter.hudsonJob (アップグレードジョブ)
           │
           └─ Lifecycle.get().canRestart() (再起動可否)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

update-center.json ───▶ UpdateSite.getData() ───▶ Data構造
                                │
                                └─ hasCoreUpdates()
                                        │
                                        ▼
                              管理画面アクセス時
                                        │
                                        ▼
                              CoreUpdateMonitor.isActivated()
                                        │
                                        ▼
                              通知バナー表示
                                        │
                         ┌──────────────┼──────────────┐
                         ▼              ▼              ▼
                   NewVersion      Progress        Complete
                   Available                       / Failed
                         │
                         ▼
               Upgrade Automatically
                         │
                         ▼
               UpdateCenter.upgrade()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| UpdateCenter.java | `core/src/main/java/hudson/model/UpdateCenter.java` | ソース | 親クラス、CoreUpdateMonitor定義 |
| UpdateSite.java | `core/src/main/java/hudson/model/UpdateSite.java` | ソース | 更新サイトデータ管理 |
| AdministrativeMonitor.java | `core/src/main/java/hudson/model/AdministrativeMonitor.java` | ソース | 基底クラス |
| Lifecycle.java | `core/src/main/java/hudson/lifecycle/Lifecycle.java` | ソース | 再起動制御 |
| message.jelly | `core/src/main/resources/hudson/model/UpdateCenter/CoreUpdateMonitor/message.jelly` | テンプレート | 通知バナーUI |
| description.jelly | `core/src/main/resources/hudson/model/UpdateCenter/CoreUpdateMonitor/description.jelly` | テンプレート | 説明文 |
| Messages.properties | `core/src/main/resources/hudson/model/Messages.properties` | リソース | メッセージ定義 |
