# 通知設計書 8-更新サイト警告通知（UpdateSiteWarningsMonitor）

## 概要

本ドキュメントは、プラグインやコアに関するセキュリティ警告がある場合に管理者へ通知を表示するUpdateSiteWarningsMonitor（更新サイト警告通知）の通知設計について記述する。

### 本通知の処理概要

UpdateSiteWarningsMonitorは、Update Centerから取得したセキュリティ警告情報を監視し、現在インストールされているJenkinsコアやプラグインに該当する警告がある場合に管理者に対して警告メッセージを表示する通知機能である。

**業務上の目的・背景**：Jenkinsおよびプラグインには、定期的にセキュリティ脆弱性が発見される。Jenkins Security Advisoryとして公開される警告は、update-center.jsonを通じて配信される。本通知は、管理者がこれらのセキュリティ警告を迅速に認識し、影響を受けるコンポーネントの更新や対策を行えるよう情報を提供することを目的とする。

**通知の送信タイミング**：UpdateCenterがupdate-center.jsonを取得・パースした後、サイトデータが準備完了（isSiteDataReady()がtrue）になった時点で、UpdateSiteWarningsConfigurationを通じて適用可能な警告が検出された場合に通知が有効化される。

**通知の受信者**：Jenkins.SYSTEM_READ権限を持つユーザーが対象となる。セキュリティ関連通知として分類される。

**通知内容の概要**：コア警告とプラグイン警告が別々に表示される。各警告には、説明メッセージ、詳細へのリンク、修正可能かどうかの情報が含まれる。「Plugin Manager」ボタンでプラグインマネージャーへ、「Configure」ボタンでセキュリティ設定画面への誘導が可能。

**期待されるアクション**：管理者は警告の詳細を確認し、修正可能な場合はプラグインマネージャーで更新を実行する。修正不可の場合は、代替策の検討やリスクの受容を判断する。警告を非表示にしたい場合は、セキュリティ設定画面で個別に設定できる。

## 通知種別

アプリ内通知（管理画面バナー表示）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（画面レンダリング時） |
| 優先度 | 高（セキュリティ関連） |
| リトライ | 無（画面表示のため不要） |

### 送信先決定ロジック

Jenkins.SYSTEM_READ権限を持つユーザーに対して表示される。サイトデータが準備完了かつアクティブな警告が存在する場合に有効化。

## 通知テンプレート

### アプリ内通知の場合

| 項目 | 内容 |
|-----|------|
| 表示位置 | 管理画面上部 |
| アラートタイプ | jenkins-alert-danger（危険） |
| 形式 | HTML（Groovyテンプレート） |

### 本文テンプレート（message.groovy）

```groovy
div(class: "jenkins-alert jenkins-alert-danger", role: "alert") {
    // 管理者のみボタン表示
    l.isAdmin() {
        form(method: "post", action: "${rootURL}/${my.url}/forward") {
            if (!pluginWarnings.isEmpty()) {
                f.submit(name: 'fix', value: _("pluginManager.link"))
            }
            f.submit(name: 'configure', value: _("configureSecurity.link"))
        }
    }

    text(_("blurb"))

    // コア警告
    if (!coreWarnings.isEmpty()) {
        dl {
            dt { text(_("coreTitle", jenkins.model.Jenkins.version)) }
            listWarnings(coreWarnings, true)
        }
    }

    // プラグイン警告
    if (!pluginWarnings.isEmpty()) {
        dl {
            pluginWarnings.each { plugin, warnings ->
                dt { a(_("pluginTitle", plugin.displayName, plugin.version), href: plugin.url) }
                listWarnings(warnings, false)
            }
        }
    }

    // 非表示警告がある場合
    if (my.hasApplicableHiddenWarnings()) {
        text(_("more"))
    }
}
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| coreWarnings | コアに関する警告リスト | getActiveCoreWarnings() | Yes |
| pluginWarnings | プラグインに関する警告マップ | getActivePluginWarningsByPlugin() | Yes |
| my.hasApplicableHiddenWarnings() | 非表示の警告があるか | UpdateSiteWarningsMonitor | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | 管理画面アクセス | isSiteDataReady() && (コア警告あり or プラグイン警告あり) | アクティブな警告が存在する場合 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| !isSiteDataReady() | サイトデータが未準備の場合 |
| getActiveWarnings().isEmpty() | アクティブな警告が存在しない場合 |
| 警告がignoreリストに含まれる場合 | UpdateSiteWarningsConfigurationで非表示設定済み |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[管理画面アクセス] --> B{isSiteDataReady?}
    B -->|No| C[表示しない]
    B -->|Yes| D[getApplicableWarnings取得]
    D --> E{ignoredWarningsで除外}
    E --> F[getActiveWarnings]
    F --> G{警告が空?}
    G -->|Yes| C
    G -->|No| H[警告バナー表示]
    H --> I[コア警告表示]
    I --> J[プラグイン警告表示]
    J --> K{ユーザーアクション}
    K -->|Plugin Manager| L[/pluginManagerへ]
    K -->|Configure| M[/configureSecurityへ]
    L --> N[終了]
    M --> N
    C --> N
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（ファイル/メモリ上のデータを参照）

### 参照データ構造

| データ構造 | 用途 | 備考 |
|-----------|------|------|
| UpdateSite.Warning | 警告情報 | update-center.jsonのwarningsセクション |
| UpdateSiteWarningsConfiguration | 警告設定 | 非表示設定の管理 |

### 更新ファイル

該当なし（非表示設定はUpdateSiteWarningsConfigurationが管理）

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| サイトデータ未準備 | ネットワーク問題等 | 通知を表示しない |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0 |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

該当なし（画面表示のため）

### 配信時間帯

制限なし（常時有効）

## セキュリティ考慮事項

- isSecurity()がtrueを返し、セキュリティ関連通知として分類される
- getRequiredPermission()でJenkins.SYSTEM_READを返し、読み取り専用アクセスを許可
- doForward()は`@RequirePOST`で保護、管理者権限をチェック
- ボタンは`l.isAdmin()`で管理者のみに表示

## 備考

- パッケージ: jenkins.security
- @Restricted(NoExternalUse.class)で外部使用制限
- 関連クラス: UpdateSiteWarningsConfiguration（警告設定管理）
- 警告タイプ: CORE, PLUGIN
- メッセージリソース: jenkins/security/Messages.properties

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

UpdateSite.WarningとUpdateSiteWarningsConfigurationの関係を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | UpdateSite.java | `core/src/main/java/hudson/model/UpdateSite.java` | Warningクラス、WarningType列挙 |
| 1-2 | UpdateSiteWarningsConfiguration.java | `core/src/main/java/jenkins/security/UpdateSiteWarningsConfiguration.java` | 警告設定管理、getApplicableWarnings() |

**読解のコツ**: Warningは適用可能性（isRelevant）を持ち、Configurationで非表示設定（ignoredWarnings）を管理する点に注目。

#### Step 2: モニター処理を理解する

UpdateSiteWarningsMonitorのisActivated()と警告取得。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | UpdateSiteWarningsMonitor.java | `core/src/main/java/jenkins/security/UpdateSiteWarningsMonitor.java` | isActivated()、getActiveWarnings()、警告分類 |

**主要処理フロー**:
1. **83-88行目**: `isActivated()` - サイトデータ準備チェック、警告存在チェック
2. **95-106行目**: `getActiveCoreWarnings()` - コア警告のフィルタリング
3. **108-127行目**: `getActivePluginWarningsByPlugin()` - プラグイン警告のグルーピング
4. **130-141行目**: `getActiveWarnings()` - 適用可能警告から非表示を除外

#### Step 3: ビューテンプレートを理解する

message.groovyの表示ロジック。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | message.groovy | `core/src/main/resources/jenkins/security/UpdateSiteWarningsMonitor/message.groovy` | 警告一覧表示、修正可能性判定 |

**主要処理フロー**:
- **30-62行目**: listWarnings()関数 - 警告表示とfixable判定
- **64-65行目**: coreWarnings, pluginWarnings取得
- **67-76行目**: 管理者のみボタン表示
- **80-102行目**: コア警告とプラグイン警告の表示

### プログラム呼び出し階層図

```
Jenkins.getAdministrativeMonitors()
    │
    ├─ UpdateSiteWarningsMonitor.isActivated()
    │      │
    │      ├─ UpdateCenter.isSiteDataReady()
    │      │
    │      ├─ getActiveCoreWarnings()
    │      │      └─ getActiveWarnings() → type == CORE
    │      │
    │      └─ getActivePluginWarningsByPlugin()
    │             └─ getActiveWarnings() → type == PLUGIN
    │
    └─ UpdateSiteWarningsMonitor.getActiveWarnings()
           │
           ├─ UpdateSiteWarningsConfiguration.getApplicableWarnings()
           │      └─ UpdateSite.Warning.isRelevant()
           │
           └─ ignoredWarnings除外
                  └─ UpdateSiteWarningsConfiguration.getIgnoredWarnings()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

update-center.json ───▶ UpdateSite.Data ───▶ warnings解析
                                │
                                └─ Warning.isRelevant()
                                        │
                                        ▼
                              getApplicableWarnings()
                                        │
                                        ▼
                              ignoredWarnings除外
                                        │
                                        ▼
                              getActiveWarnings()
                                        │
                         ┌──────────────┴──────────────┐
                         ▼                              ▼
                   CORE警告                      PLUGIN警告
                         │                              │
                         └──────────────┬──────────────┘
                                        │
                                        ▼
                              警告バナー表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| UpdateSiteWarningsMonitor.java | `core/src/main/java/jenkins/security/UpdateSiteWarningsMonitor.java` | ソース | メインクラス |
| UpdateSiteWarningsConfiguration.java | `core/src/main/java/jenkins/security/UpdateSiteWarningsConfiguration.java` | ソース | 警告設定管理 |
| UpdateSite.java | `core/src/main/java/hudson/model/UpdateSite.java` | ソース | 警告データ構造 |
| AdministrativeMonitor.java | `core/src/main/java/hudson/model/AdministrativeMonitor.java` | ソース | 基底クラス |
| message.groovy | `core/src/main/resources/jenkins/security/UpdateSiteWarningsMonitor/message.groovy` | テンプレート | 警告バナーUI |
| Messages.properties | `core/src/main/resources/jenkins/security/Messages.properties` | リソース | メッセージ定義 |
