---
generated_at: 2026-01-22 20:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：1-セキュリティ無効警告（SecurityIsOffMonitor）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **C-18 導入バージョン**：具体的なバージョン情報の根拠不足

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/jenkins/diagnostics/SecurityIsOffMonitor.java`
- E-02: `core/src/main/java/hudson/model/AdministrativeMonitor.java`
- E-03: `core/src/main/resources/jenkins/diagnostics/SecurityIsOffMonitor/message.jelly`
- E-04: `core/src/main/resources/jenkins/diagnostics/Messages.properties`
- E-05: `docs/code-to-docs/通知一覧/通知一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | セキュリティ無効時に警告を表示する | E-01 (30-32行目: isActivated) | ○ |
| C-02 | Jenkins.isUseSecurity()でセキュリティ状態を判定 | E-01 (31行目) | ○ |
| C-03 | isSecurity()がtrueを返す | E-01 (34-37行目) | ○ |
| C-04 | @Extension, @Symbolアノテーションで登録 | E-01 (21行目) | ○ |
| C-05 | Symbol名は"securityIsOff" | E-01 (21行目) | ○ |
| C-06 | パッケージはjenkins.diagnostics | E-01 (1行目) | ○ |
| C-07 | doAct()でユーザーアクション処理 | E-01 (42-50行目) | ○ |
| C-08 | @RequirePOSTでPOST保護 | E-01 (42行目) | ○ |
| C-09 | "no"パラメータでdisable(true)呼び出し | E-01 (44-46行目) | ○ |
| C-10 | "yes"で/configureSecurity へリダイレクト | E-01 (47-49行目) | ○ |
| C-11 | message.jellyで警告UI定義 | E-03 | ○ |
| C-12 | jenkins-alert-warningクラス使用 | E-03 (27行目) | ○ |
| C-13 | Setup SecurityとDismissボタン表示 | E-03 (29-30行目) | ○ |
| C-14 | DisplayNameはMessages.propertiesで定義 | E-04 (2行目) | ○ |
| C-15 | AdministrativeMonitorを継承 | E-01 (22行目), E-02 | ○ |
| C-16 | disable()でconfig.xml更新 | E-02 (128-138行目) | ○ |
| C-17 | 通知一覧に記載あり | E-05 (No.1) | ○ |
| C-18 | 導入バージョンはJenkins 1.x系 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-18: 導入バージョンの具体的な情報がソースコード内に記載されていない
  - 候補：Git履歴 / リリースノート / Javadoc @since タグ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な機能・処理フローはソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] isActivated()のロジックが正しく記述されているか確認
- [ ] セキュリティ関連通知としての重要性が適切に記載されているか確認
- [ ] 導入バージョン情報の正確性を別途確認
