---
generated_at: 2026-01-22 20:48:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：10-レガシーAPIトークン警告（LegacyApiTokenAdministrativeMonitor）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/jenkins/security/apitoken/LegacyApiTokenAdministrativeMonitor.java`
- E-02: `core/src/main/java/hudson/model/AdministrativeMonitor.java`
- E-03: `core/src/main/resources/jenkins/security/apitoken/LegacyApiTokenAdministrativeMonitor/manage.jelly`
- E-04: `core/src/main/resources/jenkins/security/apitoken/Messages.properties`
- E-05: `docs/code-to-docs/通知一覧/通知一覧.csv`
- E-06: `test/src/test/java/jenkins/security/apitoken/LegacyApiTokenAdministrativeMonitorTest.java`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | User.getAll()で全ユーザースキャン | E-01 (69行目: isActivated) | ○ |
| C-02 | hasLegacyToken()でレガシートークン存在判定 | E-01 (72行目) | ○ |
| C-03 | isSecurity()がtrue | E-01 (76-79行目) | ○ |
| C-04 | getImpactedUserList()で影響ユーザー取得 | E-01 (86-94行目) | ○ |
| C-05 | getLegacyTokenOf()でレガシートークン取得 | E-01 (97-101行目) | ○ |
| C-06 | getLegacyStatsOf()でトークン統計取得 | E-01 (104-114行目) | ○ |
| C-07 | hasFreshToken()で新トークン判定 | E-01 (120-138行目) | ○ |
| C-08 | hasMoreRecentlyUsedToken()で最近使用トークン判定 | E-01 (143-162行目) | ○ |
| C-09 | doRevokeAllSelected()で@RequirePOST保護 | E-01 (164行目) | ○ |
| C-10 | doRevokeAllSelected()で一括取り消し | E-01 (171-197行目) | ○ |
| C-11 | @Extension, @Symbolアノテーションで登録 | E-01 (52-53行目) | ○ |
| C-12 | Symbol名は"legacyApiTokenUsage" | E-01 (53行目) | ○ |
| C-13 | @Restricted(NoExternalUse.class)で外部使用制限 | E-01 (54行目) | ○ |
| C-14 | コンストラクタでid="legacyApiToken"設定 | E-01 (58-60行目) | ○ |
| C-15 | manage.jellyで詳細管理画面定義 | E-03 | ○ |
| C-16 | ユーザーID、フルネーム、トークン名列 | E-03 (43-48行目) | ○ |
| C-17 | 作成日、使用回数、最終使用日列 | E-03 (45-47行目) | ○ |
| C-18 | HasFreshToken、HasMoreRecentlyUsedToken列 | E-03 (48-55行目) | ○ |
| C-19 | DisplayNameはMessages.propertiesで定義 | E-04 (24行目) | ○ |
| C-20 | テストファイルが存在 | E-06 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主要な機能・処理フローがソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] isActivated()の全ユーザースキャンロジックが正しく説明されているか確認
- [ ] hasFreshToken/hasMoreRecentlyUsedTokenの判定ロジックが正しく説明されているか確認
- [ ] doRevokeAllSelected()の一括取り消し処理が正しく説明されているか確認
