---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：11-APIトークン新規レガシー有効警告

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **Jenkins 2.129での導入時期**：リリースノート未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/java/jenkins/security/apitoken/ApiTokenPropertyEnabledNewLegacyAdministrativeMonitor.java` 行44-69
- E-02: `core/src/main/java/jenkins/security/apitoken/ApiTokenPropertyConfiguration.java` 行40-98
- E-03: `core/src/main/resources/jenkins/security/apitoken/ApiTokenPropertyEnabledNewLegacyAdministrativeMonitor/message.jelly` 行24-34
- E-04: `core/src/main/resources/jenkins/security/apitoken/Messages.properties` 行22-24
- E-05: `core/src/main/java/hudson/model/AdministrativeMonitor.java`（基底クラス）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AdministrativeMonitorを継承した管理者警告機能 | E-01 行44 | ○ |
| C-02 | isCreationOfLegacyTokenEnabled()でアクティブ判定 | E-01 行51-53 | ○ |
| C-03 | isSecurity()がtrueを返す | E-01 行55-58 | ○ |
| C-04 | @RequirePOSTでCSRF対策 | E-01 行60 | ○ |
| C-05 | doActでyes/no分岐処理 | E-01 行61-68 | ○ |
| C-06 | creationOfLegacyTokenEnabledフィールドの存在 | E-02 行51 | ○ |
| C-07 | GlobalConfiguration継承による永続化 | E-02 行40 | ○ |
| C-08 | setCreationOfLegacyTokenEnabled後にsave()呼び出し | E-02 行80-83 | ○ |
| C-09 | jenkins-alert-warningスタイルの使用 | E-03 行26 | ○ |
| C-10 | Preventボタンとdismissボタンの存在 | E-03 行28-29 | ○ |
| C-11 | @Symbol("apiTokenNewLegacyWithoutExisting") | E-01 行42 | ○ |
| C-12 | @Extension注釈によるSPI登録 | E-01 行41 | ○ |
| C-13 | Messages.displayName()による国際化 | E-01 行47, E-04 行23 | ○ |
| C-14 | HttpResponses.redirectViaContextPath("manage")でリダイレクト | E-01 行67 | ○ |
| C-15 | CloudBees社による2018年実装 | E-01 行1-23（コピーライト） | ○ |
| C-16 | @Restricted(NoExternalUse.class)による内部API制限 | E-01 行43 | ○ |
| C-17 | POSTリクエストのみ受付 | E-01 行60 | ○ |
| C-18 | Jenkins 2.129以降で導入 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **Jenkins 2.129での導入時期**：ApiTokenPropertyConfiguration.javaのJavadocに「@since 2.129」の記載があるが、モニター自体の導入バージョンは明示されていない
  - 候補：Jenkinsリリースノート / GitHubのコミット履歴 / CHANGELOGファイル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な機能・処理フローはソースコードで確認済み
- バージョン情報の正確性のみ要確認

## 6) レビュアーチェックリスト（最小）
- [ ] Jenkins 2.129でのApiTokenPropertyConfigurationの導入と、モニターの導入が同時かを確認
- [ ] 国際化メッセージファイル（message.jelly内の%warningMessage）の実際の内容を確認
- [ ] 本番環境でのモニター表示動作を確認
