---
generated_at: 2026-01-22 10:42:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：15-プラグイン非推奨警告

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/java/hudson/PluginManager.java` 行2653-2681
- E-02: `core/src/main/java/hudson/PluginWrapper.java` 行374-381, 1399-1416
- E-03: `core/src/main/resources/hudson/PluginManager/PluginDeprecationMonitor/message.jelly` 行24-37
- E-04: `core/src/main/java/hudson/model/AdministrativeMonitor.java`（基底クラス）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AdministrativeMonitorを継承した管理者警告機能 | E-01 行2661 | ○ |
| C-02 | PluginManager内部クラスとして定義 | E-01 行2661 | ○ |
| C-03 | getDeprecatedPlugins()で非推奨プラグインを取得 | E-01 行2672-2680 | ○ |
| C-04 | isActivated()で非推奨プラグイン存在チェック | E-01 行2668-2670 | ○ |
| C-05 | PluginWrapper.isDeprecated()で非推奨判定 | E-02 行374-381 | ○ |
| C-06 | getDeprecations()で非推奨詳細情報を取得 | E-02 行1399-1416 | ○ |
| C-07 | LinkedHashMapでプラグイン名順ソート | E-01 行2673-2679 | ○ |
| C-08 | @Symbol("pluginDeprecation") | E-01 行2659 | ○ |
| C-09 | @Extension注釈によるSPI登録 | E-01 行2660 | ○ |
| C-10 | @Restricted(NoExternalUse.class) | E-01 行2658 | ○ |
| C-11 | jenkins-alert-warningスタイルの使用 | E-03 行27 | ○ |
| C-12 | プラグイン名とリンクの表示 | E-03 行31 | ○ |
| C-13 | forEachでプラグインリストを繰り返し表示 | E-03 行30 | ○ |
| C-14 | rel="noopener noreferrer" target="_blank"で外部リンク | E-03 行31 | ○ |
| C-15 | getDisplayName()による国際化 | E-01 行2663-2665 | ○ |
| C-16 | Jenkins 2.246以降で導入（@since 2.246） | E-01 行2656 | ○ |
| C-17 | deprecations.get(0).urlで詳細URLを取得 | E-01 行2678 | ○ |
| C-18 | Comparator.comparing(PluginWrapper::getDisplayName)でソート | E-01 行2676 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（すべての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な機能・処理フローはソースコードで完全に確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 更新サイトのdeprecationsデータ形式を確認
- [ ] 本番環境で実際に非推奨プラグインがある場合の表示を確認
- [ ] 国際化メッセージ（%DeprecatedPlugins, %DeprecatedPluginsDescription）の実際の内容を確認
