---
generated_at: 2026-01-22 10:45:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：16-プラグインラッパー警告

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/java/hudson/PluginWrapper.java` 行1204-1253, 174-197, 202
- E-02: `core/src/main/resources/hudson/PluginWrapper/PluginWrapperAdministrativeMonitor/message.jelly` 行1-35
- E-03: `core/src/main/java/hudson/model/AdministrativeMonitor.java`（基底クラス）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AdministrativeMonitorを継承した管理者警告機能 | E-01 行1210 | ○ |
| C-02 | PluginWrapper内部クラスとして定義 | E-01 行1210 | ○ |
| C-03 | pluginsマップでエラープラグインを保持 | E-01 行1211 | ○ |
| C-04 | addPlugin()でエラープラグインを登録 | E-01 行1213-1215 | ○ |
| C-05 | isActivated()でエラープラグイン存在チェック | E-01 行1217-1220 | ○ |
| C-06 | NOTICE静的フィールドとして定義 | E-01 行1205 | ○ |
| C-07 | @Extension注釈によるSPI登録 | E-01 行1204 | ○ |
| C-08 | dependencyErrorsフィールドの存在 | E-01 行202 | ○ |
| C-09 | getOriginalDependencyErrors()メソッド | E-01 行179-182 | ○ |
| C-10 | getDerivedDependencyErrors()メソッド | E-01 行190-192 | ○ |
| C-11 | hasOriginalDependencyErrors()メソッド | E-01 行185-187 | ○ |
| C-12 | hasDerivedDependencyErrors()メソッド | E-01 行195-197 | ○ |
| C-13 | jenkins-alert-dangerスタイルの使用 | E-02 行3 | ○ |
| C-14 | Correctボタンのフォーム | E-02 行4-6 | ○ |
| C-15 | 直接依存エラーの表示 | E-02 行9-18 | ○ |
| C-16 | 間接依存エラーの表示（条件付き） | E-02 行19-32 | ○ |
| C-17 | プラグイン名とバージョンの表示 | E-02 行12, 25 | ○ |
| C-18 | doAct()でプラグインマネージャーへリダイレクト | E-01 行1243-1248 | ○ |
| C-19 | hasAnyDerivedDependencyErrors()メソッド | E-01 行1222-1224 | ○ |
| C-20 | get()静的メソッドでシングルトン取得 | E-01 行1250-1252 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（すべての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な機能・処理フローはソースコードで完全に確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 実際に依存関係エラーが発生した場合の表示を確認
- [ ] 直接エラーと間接エラーの区別が正しく表示されることを確認
- [ ] Correctボタン押下後のプラグインマネージャーでの操作フローを確認
- [ ] 国際化メッセージ（%blurbOriginal, %blurbDerived等）の実際の内容を確認
