---
generated_at: 2026-01-22 10:48:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：17-SCMポーリング渋滞警告

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/java/hudson/triggers/SCMTrigger.java` 行160-194, 232, 269-279, 396-410, 782
- E-02: `core/src/main/resources/hudson/triggers/SCMTrigger/AdministrativeMonitorImpl/message.jelly` 行24-31
- E-03: `core/src/main/java/hudson/model/AdministrativeMonitor.java`（基底クラス）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AdministrativeMonitorを継承した管理者警告機能 | E-01 行397 | ○ |
| C-02 | SCMTrigger内部クラスとして定義 | E-01 行397 | ○ |
| C-03 | onフラグで警告状態を保持 | E-01 行404 | ○ |
| C-04 | isActivated()でonフラグを返却 | E-01 行406-408 | ○ |
| C-05 | @Extension注釈によるSPI登録 | E-01 行396 | ○ |
| C-06 | queue変数（SequentialExecutionQueue） | E-01 行232 | ○ |
| C-07 | isClogged()でキュー飢餓判定 | E-01 行269-271 | ○ |
| C-08 | clogCheck()でonフラグ更新 | E-01 行277-279 | ○ |
| C-09 | STARVATION_THRESHOLDのデフォルト1時間 | E-01 行782 | ○ |
| C-10 | run()でqueue.execute(Runner)呼び出し | E-01 行191 | ○ |
| C-11 | run()後にclogCheck()呼び出し | E-01 行192 | ○ |
| C-12 | synchronousPollingによる分岐 | E-01 行182-193 | ○ |
| C-13 | jenkins-alert-warningスタイルの使用 | E-02 行27 | ○ |
| C-14 | getDisplayName()による国際化 | E-01 行399-401 | ○ |
| C-15 | ポーリングスレッド数デフォルト10 | E-01 行247 | ○ |
| C-16 | スレッド数範囲5〜100 | E-01 行245-246 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（すべての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な機能・処理フローはソースコードで完全に確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 実際にキュー渋滞が発生した場合の警告表示を確認
- [ ] STARVATION_THRESHOLDのシステムプロパティによる変更動作を確認
- [ ] 国際化メッセージ（%blurb）の実際の内容を確認
- [ ] ポーリングスレッド数変更後の動作を確認
