---
generated_at: 2026-01-22 10:55:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：19-ノードオフライン警告

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/java/hudson/node_monitors/MonitorMarkedNodeOffline.java` 行39-52
- E-02: `core/src/main/java/hudson/node_monitors/AbstractNodeMonitorDescriptor.java` 行247-257
- E-03: `core/src/main/resources/hudson/node_monitors/MonitorMarkedNodeOffline/message.jelly` 行24-34
- E-04: `core/src/main/java/hudson/model/AdministrativeMonitor.java`（基底クラス）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AdministrativeMonitorを継承した管理者警告機能 | E-01 行40 | ○ |
| C-02 | activeフラグでオフラインマーク発生を保持 | E-01 行46 | ○ |
| C-03 | isActivated()でactiveフラグを返却 | E-01 行48-50 | ○ |
| C-04 | @Extension注釈によるSPI登録 | E-01 行39 | ○ |
| C-05 | markOffline()でactive = trueを設定 | E-02 行253-255 | ○ |
| C-06 | isIgnored()チェックでモニター無視 | E-02 行248 | ○ |
| C-07 | setTemporaryOfflineCause()でノードオフライン化 | E-02 行250 | ○ |
| C-08 | jenkins-alert-warningスタイルの使用 | E-03 行27 | ○ |
| C-09 | Dismissボタンでdisable呼び出し | E-03 行28-29 | ○ |
| C-10 | getDisplayName()による国際化 | E-01 行41-43 | ○ |
| C-11 | Jenkins 1.301以降で導入（@since 1.301） | E-01 行37 | ○ |
| C-12 | activeはpublic変数 | E-01 行46 | ○ |
| C-13 | AdministrativeMonitor.all().get()でインスタンス取得 | E-02 行253 | ○ |
| C-14 | ノード監視機能でノード問題検出 | E-02 行247-257（コンテキスト） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（すべての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な機能・処理フローはソースコードで完全に確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 実際にノードがオフラインにマークされた場合の警告表示を確認
- [ ] Dismissボタン押下後の動作を確認
- [ ] 各NodeMonitor（DiskSpace, SwapSpace, Clock, ResponseTime）の動作を確認
- [ ] 国際化メッセージ（%blurb）の実際の内容を確認
