---
generated_at: 2026-01-22 10:35:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：22-エージェントポート強制警告

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **message.jellyの詳細内容**：UIテンプレートファイルを確認推奨

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/java/jenkins/model/Jenkins.java` (1285-1314行目) - EnforceSlaveAgentPortAdministrativeMonitor実装
- E-02: `core/src/main/resources/jenkins/model/Messages.properties` (73行目)

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | EnforceSlaveAgentPortAdministrativeMonitorはJenkinsの内部クラスである | E-01 (1285行目) | ○ |
| C-02 | @Extensionアノテーションでエクステンションとして登録される | E-01 (1283行目) | ○ |
| C-03 | @Restrictedで外部利用が制限されている | E-01 (1284行目) | ○ |
| C-04 | @InjectでJenkinsインスタンスが注入される | E-01 (1286-1287行目) | ○ |
| C-05 | 表示名は"Enforce TCP Agent Port"である | E-02 (73行目) | ○ |
| C-06 | システムプロパティ名はjenkins.model.Jenkins.slaveAgentPortである | E-01 (1294-1296行目) | ○ |
| C-07 | getExpectedPortでgetSlaveAgentPortInitialValueを呼び出す | E-01 (1298-1301行目) | ○ |
| C-08 | doActは@RequirePOSTでCSRF保護されている | E-01 (1303行目) | ○ |
| C-09 | doActはforceSetSlaveAgentPortを呼び出す | E-01 (1305行目) | ○ |
| C-10 | doActは/manageにリダイレクトする | E-01 (1306行目) | ○ |
| C-11 | isActivatedはSLAVE_AGENT_PORT_ENFORCEとポート値を比較する | E-01 (1311-1312行目) | ○ |
| C-12 | isActivatedはポート値が期待値と異なる場合にtrueを返す | E-01 (1312行目) | ○ |
| C-13 | AdministrativeMonitorを継承している | E-01 (1285行目) | ○ |
| C-14 | message.jellyの詳細な表示内容 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- message.jellyの詳細なUI定義内容は未確認
  - 候補：jellyファイルの直接読み込み

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な仕様はソースコードから確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] message.jellyのUI表示内容確認
- [ ] SLAVE_AGENT_PORT_ENFORCEシステムプロパティの動作確認
- [ ] forceSetSlaveAgentPortメソッドの実装確認
