---
generated_at: 2026-01-22 10:45:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：24-OS終末期警告

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - 全主張に根拠あり、追加レビュー不要

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/java/jenkins/monitor/OperatingSystemEndOfLifeAdminMonitor.java` (1-292行目)

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AdministrativeMonitorを継承している | E-01 (64行目) | ○ |
| C-02 | @Extensionアノテーションで登録される | E-01 (61行目) | ○ |
| C-03 | @Restrictedで外部利用が制限されている | E-01 (62行目) | ○ |
| C-04 | @Symbolで"operatingSystemEndOfLife"として参照可能 | E-01 (63行目) | ○ |
| C-05 | warningsStartDateフィールドでデフォルト10年後に設定 | E-01 (73行目) | ○ |
| C-06 | afterEndOfLifeDateフィールドで終了日経過を保持 | E-01 (74行目) | ○ |
| C-07 | operatingSystemNameにos.nameをデフォルト設定 | E-01 (75行目) | ○ |
| C-08 | endOfLifeDateのデフォルトは2099-12-31 | E-01 (76行目) | ○ |
| C-09 | documentationUrlのデフォルトはjenkins.io | E-01 (77行目) | ○ |
| C-10 | /etc/os-releaseをデフォルトのデータファイルとして使用 | E-01 (173行目) | ○ |
| C-11 | PRETTY_NAMEパターンでOS名を抽出 | E-01 (187行目) | ○ |
| C-12 | デフォルトの警告開始は終了日の6ヶ月前 | E-01 (128行目) | ○ |
| C-13 | JSON設定でstartを指定可能 | E-01 (128行目) | ○ |
| C-14 | buildDocumentationUrlでURLを動的生成 | E-01 (236-250行目) | ○ |
| C-15 | getRequiredPermissionはSYSTEM_READを返す | E-01 (284-286行目) | ○ |
| C-16 | doActは@RequirePOSTでCSRF保護されている | E-01 (256行目) | ○ |
| C-17 | noパラメータでモニターを無効化 | E-01 (258-261行目) | ○ |
| C-18 | 無効化時はADMINISTER権限をチェック | E-01 (259行目) | ○ |
| C-19 | isActivatedはwarningsStartDate以降でtrueを返す | E-01 (275-280行目) | ○ |
| C-20 | ignoreEndOfLifeフラグでテスト用に無効化可能 | E-01 (71行目, 271-273行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] end-of-life-data.jsonの最新性確認
- [ ] サポート対象OSの網羅性確認
- [ ] /etc/os-releaseの各OSでの動作確認
