---
generated_at: 2026-01-22 10:50:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：25-CrumbセッションID除外警告

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 全主張に根拠あり、追加レビュー不要

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/java/hudson/security/csrf/DefaultCrumbIssuer.java` (1-198行目)

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | EXCLUDE_SESSION_IDはシステムプロパティから初期化される | E-01 (51行目) | ○ |
| C-02 | 静的フィールドで非finalにされている（Groovy Console用） | E-01 (49-50行目) | ○ |
| C-03 | DefaultCrumbIssuerの内部クラスとして実装されている | E-01 (161-195行目) | ○ |
| C-04 | @Extensionアノテーションで登録される | E-01 (161行目) | ○ |
| C-05 | @Restrictedで外部利用が制限されている | E-01 (162行目) | ○ |
| C-06 | isActivatedはDefaultCrumbIssuerかつEXCLUDE_SESSION_ID=trueでtrue | E-01 (165-172行目) | ○ |
| C-07 | getCrumbIssuer()でCrumbIssuerを取得 | E-01 (167行目) | ○ |
| C-08 | isSecurity()はtrueを返す | E-01 (174-177行目) | ○ |
| C-09 | getDisplayName()で表示名を返す | E-01 (179-182行目) | ○ |
| C-10 | doActは@POSTでCSRF保護されている | E-01 (184行目) | ○ |
| C-11 | learnパラメータでjenkins.io/redirect/csrf-protection/へ遷移 | E-01 (186-188行目) | ○ |
| C-12 | dismissパラメータでモニターを無効化 | E-01 (190-191行目) | ○ |
| C-13 | issueCrumb()でEXCLUDE_SESSION_IDをチェック | E-01 (110-113行目) | ○ |
| C-14 | セッションIDが含まれる場合はセミコロンで区切って追加 | E-01 (111-112行目) | ○ |
| C-15 | SHA-256でハッシュ化 | E-01 (92-98行目, 115-116行目) | ○ |
| C-16 | excludeClientIPFromCrumbオプションは非推奨 | E-01 (79-85行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] CSRF保護の動作確認
- [ ] EXCLUDE_SESSION_ID設定時のセキュリティリスク理解
- [ ] 将来のリリースでの削除計画確認
