---
generated_at: 2026-01-22 11:05:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：28-SCMポーリングトリガー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - 全主張に根拠あり、追加レビュー不要

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/java/hudson/triggers/SCMTrigger.java` (1-783行目)
- E-02: `core/src/main/resources/hudson/triggers/Messages.properties` (23-38行目)

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Trigger<Item>を継承している | E-01 (106行目) | ○ |
| C-02 | ignorePostCommitHooksフィールドがある | E-01 (108行目) | ○ |
| C-03 | @DataBoundConstructorでscmpoll_specを受け取る | E-01 (110-113行目) | ○ |
| C-04 | @DataBoundSetterでignorePostCommitHooksを設定可能 | E-01 (150-153行目) | ○ |
| C-05 | @Symbolで"pollSCM"として参照可能 | E-01 (217行目) | ○ |
| C-06 | run()でsynchronousPollingをチェック | E-01 (182-191行目) | ○ |
| C-07 | SequentialExecutionQueueでポーリングを管理 | E-01 (232行目) | ○ |
| C-08 | maximumThreadsのデフォルトは10 | E-01 (243行目, 247行目) | ○ |
| C-09 | スレッド数は5-100の範囲 | E-01 (245-246行目, 316-321行目) | ○ |
| C-10 | isCloggedでSTARVATION_THRESHOLDをチェック | E-01 (270行目) | ○ |
| C-11 | AdministrativeMonitorImplでキュー渋滞を表示 | E-01 (396-410行目) | ○ |
| C-12 | getLogFile()でscm-polling.logを返す | E-01 (213-215行目) | ○ |
| C-13 | Runner内部クラスでポーリングを実行 | E-01 (555-702行目) | ○ |
| C-14 | SCMDecisionHandler.vetoでスキップ | E-01 (644-658行目) | ○ |
| C-15 | runPolling()でpoll()を呼び出し | E-01 (607-635行目) | ○ |
| C-16 | SCMTriggerCauseでポーリングログを保持 | E-01 (708-776行目) | ○ |
| C-17 | onAddedTo()でpolling.logをビルドに保存 | E-01 (742-755行目) | ○ |
| C-18 | getShortDescription()で"Started by an SCM change"を返す | E-02 (28行目) | ○ |
| C-19 | STARVATION_THRESHOLDのデフォルトは1時間 | E-01 (782行目) | ○ |
| C-20 | BuildActionでpollingLog表示を提供 | E-01 (418-499行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] SequentialExecutionQueueの動作確認
- [ ] SCMDecisionHandlerの拡張確認
- [ ] キュー渋滞時のAdministrativeMonitor動作確認
