---
generated_at: 2026-01-22 20:34:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：3-JENKINS_HOMEディスク使用量警告（HudsonHomeDiskUsageMonitor）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/hudson/diagnosis/HudsonHomeDiskUsageMonitor.java`
- E-02: `core/src/main/java/hudson/diagnosis/HudsonHomeDiskUsageChecker.java`
- E-03: `core/src/main/java/hudson/model/AdministrativeMonitor.java`
- E-04: `core/src/main/resources/hudson/diagnosis/HudsonHomeDiskUsageMonitor/message.jelly`
- E-05: `core/src/main/resources/hudson/diagnosis/Messages.properties`
- E-06: `docs/code-to-docs/通知一覧/通知一覧.csv`
- E-07: `test/src/test/java/hudson/diagnosis/HudsonHomeDiskUsageMonitorTest.java`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 定期的にディスク使用量をチェック | E-02 (44-46行目: getRecurrencePeriod) | ○ |
| C-02 | チェック間隔は1時間 | E-02 (45行目: HOUR) | ○ |
| C-03 | getRootDir().getUsableSpace()で空き容量取得 | E-02 (50行目) | ○ |
| C-04 | getRootDir().getTotalSpace()で総容量取得 | E-02 (51行目) | ○ |
| C-05 | ディスク情報取得不可の場合チェックキャンセル | E-02 (52-57行目) | ○ |
| C-06 | 条件: total/free > 10 AND free < threshold | E-02 (65行目) | ○ |
| C-07 | FREE_SPACE_THRESHOLDデフォルト10GB | E-02 (74-75行目) | ○ |
| C-08 | システムプロパティで閾値変更可能 | E-02 (74行目: SystemProperties.getLong) | ○ |
| C-09 | activatedフラグでモニター状態管理 | E-01 (50行目) | ○ |
| C-10 | isActivated()でactivatedを返す | E-01 (57-59行目) | ○ |
| C-11 | doAct()で@RequirePOST保護 | E-01 (69行目) | ○ |
| C-12 | Solutionインナークラスで解決策拡張 | E-01 (111-142行目) | ○ |
| C-13 | @Extension, @Symbolアノテーションで登録 | E-01 (45行目), E-02 (41行目) | ○ |
| C-14 | Symbol名は"diskUsageCheck" | E-01 (45行目) | ○ |
| C-15 | コンストラクタでid="hudsonHomeIsFull"設定 | E-01 (52-54行目) | ○ |
| C-16 | message.jellyで警告UI定義 | E-04 | ○ |
| C-17 | DisplayNameはMessages.propertiesで定義 | E-05 (6行目) | ○ |
| C-18 | テストファイルが存在 | E-07 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主要な機能・処理フローがソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] ディスク使用量チェックの条件式が正しく記述されているか確認
- [ ] CheckerとMonitorの連携が正しく説明されているか確認
- [ ] Solution拡張ポイントの説明が適切か確認
